/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.apache.sis.feature.FoliationRepresentation;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.csv.Store;
import org.apache.sis.internal.storage.wkt.FirstKeywordPeek;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@StoreMetadata(formatName="CSV", fileSuffixes={"csv"}, capabilities={Capability.READ}, resourceTypes={FeatureSet.class})
public final class StoreProvider
extends URIDataStore.Provider {
    static final String NAME = "CSV";
    static final String MOVING = "CSV-MF";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.csv");
    private static final ParameterDescriptor<FoliationRepresentation> FOLIATION;

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return Peek.INSTANCE.probeContent(this, connector);
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new Store(this, connector);
    }

    @Override
    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameters);
        StorageConnector connector = StoreProvider.connector(this, parameters);
        Parameters pg = Parameters.castOrWrap(parameters);
        connector.setOption(DataOptionKey.ENCODING, (Charset)pg.getValue(ENCODING));
        connector.setOption(DataOptionKey.FOLIATION_REPRESENTATION, pg.getValue(FOLIATION));
        return new Store(this, connector);
    }

    @Override
    protected ParameterDescriptorGroup build(ParameterBuilder builder) {
        return builder.createGroup(LOCATION_PARAM, ENCODING, FOLIATION);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        FOLIATION = ((ParameterBuilder)((ParameterBuilder)builder.addName("foliation")).setDescription(Resources.formatInternational((short)38))).create(FoliationRepresentation.class, FoliationRepresentation.ASSEMBLED);
    }

    private static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        private static final String KEYWORD = "@stboundedby";

        private Peek() {
            super(KEYWORD.length());
        }

        @Override
        protected int isKeywordChar(int c) {
            return c == 64 ? 1 : super.isKeywordChar(c);
        }

        @Override
        protected boolean isPostKeyword(int c) {
            return c == 44;
        }

        @Override
        protected ProbeResult forKeyword(char[] keyword, int length) {
            if (length == this.maxLength && KEYWORD.equalsIgnoreCase(new String(keyword))) {
                return ProbeResult.SUPPORTED;
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

