/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataOutput;

public class ChannelImageOutputStream
extends ChannelDataOutput
implements DataOutput,
Closeable {
    public ChannelImageOutputStream(String filename, WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        super(filename, channel, buffer);
    }

    public ChannelImageOutputStream(ChannelDataOutput output) throws IOException {
        super(output.filename, output.channel, output.buffer);
    }

    @Override
    public final void write(int v) throws IOException {
        this.writeByte(v);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        byte[] data = new byte[s2.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)s2.charAt(i);
        }
        this.write(data);
    }

    @Override
    public final void writeChars(String s2) throws IOException {
        this.writeChars(s2.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUTF(String s2) throws IOException {
        byte[] data = s2.getBytes("UTF-8");
        if (data.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(Resources.format((short)6, this.filename, (short)Short.MAX_VALUE, data.length));
        }
        ByteOrder oldOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            this.writeShort(data.length);
            this.write(data);
        }
        finally {
            this.buffer.order(oldOrder);
        }
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }
}

