/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.logging.Logging;

public final class DefaultFactories
extends SystemListener {
    private static final Map<Class<?>, Object> FACTORIES = new IdentityHashMap(4);

    private DefaultFactories() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<DefaultFactories> clazz = DefaultFactories.class;
        synchronized (DefaultFactories.class) {
            FACTORIES.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized <T> boolean isDefaultInstance(Class<T> type, T factory) {
        return factory == null || FACTORIES.get(type) == factory;
    }

    public static synchronized <T> T forClass(Class<T> type) {
        T factory = type.cast(FACTORIES.get(type));
        if (factory == null && !FACTORIES.containsKey(type)) {
            Object fallback = null;
            for (T candidate : DefaultFactories.createServiceLoader(type)) {
                if (candidate.getClass().getName().startsWith("org.apache.sis.")) {
                    if (factory != null) {
                        throw new ServiceConfigurationError("Found two implementations of " + String.valueOf(type));
                    }
                    factory = candidate;
                    continue;
                }
                if (fallback != null) continue;
                fallback = candidate;
            }
            if (factory == null) {
                factory = fallback;
            }
            if (factory != null) {
                for (Object existing : FACTORIES.values()) {
                    if (existing == null || !factory.getClass().equals(existing.getClass())) continue;
                    factory = type.cast(existing);
                    break;
                }
            }
            FACTORIES.put(type, factory);
        }
        return factory;
    }

    public static <T> T forBuildin(Class<T> type) {
        T factory = DefaultFactories.forClass(type);
        if (factory == null) {
            throw new ServiceConfigurationError("Missing \u201cMETA-INF/services/" + type.getName() + "\u201d file. The JAR file may be corrupted or the classpath incorrect.");
        }
        return factory;
    }

    public static <T, I extends T> I forBuildin(Class<T> type, Class<I> impl) {
        T factory = DefaultFactories.forBuildin(type);
        if (!impl.isInstance(factory)) {
            throw new ServiceConfigurationError("The \u201cMETA-INF/services/" + type.getName() + "\u201d file should contain only \u201c" + impl.getName() + "\u201d in the Apache SIS namespace, but we found \u201c" + factory.getClass().getName() + "\u201d.");
        }
        return impl.cast(factory);
    }

    public static <T> ServiceLoader<T> createServiceLoader(Class<T> service) {
        try {
            return ServiceLoader.load(service, DefaultFactories.getContextClassLoader());
        }
        catch (SecurityException e) {
            Logging.recoverableException(SystemListener.LOGGER, DefaultFactories.class, "createServiceLoader", e);
            return ServiceLoader.load(service);
        }
    }

    public static ClassLoader getContextClassLoader() throws SecurityException {
        Walker walker = new Walker();
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> {
            stream.forEach(walker);
            return walker.loader;
        });
    }

    static {
        SystemListener.add(new DefaultFactories());
    }

    private static final class Walker
    implements Consumer<StackWalker.StackFrame> {
        ClassLoader loader;
        private final Set<ClassLoader> parents = new HashSet<ClassLoader>();

        Walker() {
            this.setClassLoader(Thread.currentThread().getContextClassLoader());
        }

        private void setClassLoader(ClassLoader c) {
            this.loader = c;
            while (c != null) {
                this.parents.add(c);
                c = c.getParent();
            }
        }

        @Override
        public void accept(StackWalker.StackFrame frame) {
            ClassLoader c;
            if (frame.getClassName().startsWith("org.apache.sis.") && !this.parents.contains(c = frame.getDeclaringClass().getClassLoader())) {
                this.parents.clear();
                this.setClassLoader(c);
            }
        }
    }
}

