/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.function.Predicate;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.util.CodeList;
import org.opengis.util.ControlledVocabulary;

public final class CodeLists
implements Predicate<CodeList<?>> {
    public static final String RESOURCES = "org.opengis.metadata.CodeLists";
    private final String codename;

    private CodeLists(String codename) {
        this.codename = codename;
    }

    @Override
    public boolean test(CodeList<?> code) {
        for (String candidate : code.names()) {
            if (!CodeLists.accept(candidate, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean accept(String candidate, String codename) {
        return CharSequences.equalsFiltered(candidate, codename, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static <T extends CodeList<T>> T forName(Class<T> codeType, String name, boolean canCreate) {
        if ((name = Strings.trimOrNull(name)) == null) {
            return null;
        }
        return CodeList.valueOf(codeType, new CodeLists(name), canCreate ? name : null);
    }

    public static <T extends Enum<T>> T forName(Class<T> enumType, String name) {
        if ((name = Strings.trimOrNull(name)) != null) {
            try {
                return Enum.valueOf(enumType, name);
            }
            catch (IllegalArgumentException e) {
                Enum[] values = (Enum[])enumType.getEnumConstants();
                if (values == null) {
                    throw e;
                }
                if (values instanceof ControlledVocabulary[]) {
                    for (ControlledVocabulary code : (ControlledVocabulary[])values) {
                        for (String candidate : code.names()) {
                            if (!CodeLists.accept(candidate, name)) continue;
                            return (T)((Enum)enumType.cast(code));
                        }
                    }
                } else {
                    for (Enum code : values) {
                        if (!CodeLists.accept(code.name(), name)) continue;
                        return (T)((Enum)enumType.cast(code));
                    }
                }
            }
        }
        return null;
    }

    public static <T extends ControlledVocabulary> T[] values(Class<T> codeType) {
        Object values;
        try {
            values = codeType.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            values = Array.newInstance(codeType, 0);
        }
        return (ControlledVocabulary[])values;
    }
}

