/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.Flushable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;

public class TableAppender
extends Appender
implements Flushable {
    public static final byte ALIGN_LEFT = -1;
    public static final byte ALIGN_CENTER = 0;
    public static final byte ALIGN_RIGHT = 1;
    private static final char[][] BOX = new char[][]{{'\u250c', '\u252c', '\u2510', '\u251c', '\u253c', '\u2524', '\u2514', '\u2534', '\u2518', '\u2500', '\u2502'}, {'\u2553', '\u2565', '\u2556', '\u255f', '\u256b', '\u2562', '\u2559', '\u2568', '\u255c', '\u2500', '\u2551'}, {'\u2552', '\u2564', '\u2555', '\u255e', '\u256a', '\u2561', '\u2558', '\u2567', '\u255b', '\u2550', '\u2502'}, {'\u2554', '\u2566', '\u2557', '\u2560', '\u256c', '\u2563', '\u255a', '\u2569', '\u255d', '\u2550', '\u2551'}};
    private static final char SPACE = ' ';
    private final StringBuilder buffer = new StringBuilder(64);
    private final List<Cell> cells = new ArrayList<Cell>();
    private byte alignment = (byte)-1;
    private int currentColumn;
    private int currentRow;
    private int[] maximalColumnWidths = ArraysExt.EMPTY_INT;
    private String lineSeparator;
    private final String columnSeparator;
    private final String leftBorder;
    private final String rightBorder;
    private boolean multiLinesCells;
    private boolean skipLF;
    private boolean ownOut;

    public TableAppender() {
        this(new StringBuilder(256));
        this.ownOut = true;
    }

    public TableAppender(String separator) {
        this(new StringBuilder(256), separator);
        this.ownOut = true;
    }

    public TableAppender(Appendable out) {
        super(out);
        this.leftBorder = "\u2551 ";
        this.rightBorder = " \u2551";
        this.columnSeparator = " \u2502 ";
    }

    public TableAppender(Appendable out, String separator) {
        super(out);
        int length = separator.length();
        this.leftBorder = separator.substring(CharSequences.skipLeadingWhitespaces(separator, 0, length));
        this.rightBorder = separator.substring(0, CharSequences.skipTrailingWhitespaces(separator, 0, length));
        this.columnSeparator = separator;
    }

    public TableAppender(Appendable out, String leftBorder, String separator, String rightBorder) {
        super(out);
        ArgumentChecks.ensureNonNull("leftBorder", leftBorder);
        ArgumentChecks.ensureNonNull("separator", separator);
        ArgumentChecks.ensureNonNull("rightBorder", rightBorder);
        this.leftBorder = leftBorder;
        this.rightBorder = rightBorder;
        this.columnSeparator = separator;
    }

    private void writeBorder(int horizontalBorder, int verticalBorder, char horizontalChar) throws IOException {
        String border;
        int boxCount = 0;
        char[][] box = new char[BOX.length][];
        for (char[] row : BOX) {
            if (row[9] != horizontalChar) continue;
            box[boxCount++] = row;
        }
        switch (horizontalBorder) {
            case -1: {
                border = this.leftBorder;
                break;
            }
            case 1: {
                border = this.rightBorder;
                break;
            }
            case 0: {
                border = this.columnSeparator;
                break;
            }
            default: {
                throw new AssertionError(horizontalBorder);
            }
        }
        assert (verticalBorder >= -1 && verticalBorder <= 1) : verticalBorder;
        int index = horizontalBorder + 1 + (verticalBorder + 1) * 3;
        int borderLength = border.length();
        int i = 0;
        while (i < borderLength) {
            int c = border.codePointAt(i);
            i += Character.charCount(c);
            if (Character.isWhitespace(c)) {
                c = horizontalChar;
            } else {
                for (int j = 0; j < boxCount; ++j) {
                    if (box[j][10] != c) continue;
                    c = box[j][index];
                    break;
                }
            }
            this.appendCodePoint(c);
        }
    }

    public boolean isMultiLinesCells() {
        return this.multiLinesCells;
    }

    public void setMultiLinesCells(boolean multiLines) {
        this.multiLinesCells = multiLines;
    }

    public byte getCellAlignment() {
        return this.alignment;
    }

    public void setCellAlignment(byte alignment) {
        if (alignment < -1 || alignment > 1) {
            throw new IllegalArgumentException(Errors.format((short)45, "alignment", alignment));
        }
        this.alignment = alignment;
    }

    public String getLineSeparator() {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.lineSeparator();
        }
        return this.lineSeparator;
    }

    public int getRowCount() {
        int count = this.currentRow;
        if (this.currentColumn != 0) {
            ++count;
        }
        return count;
    }

    public int getColumnCount() {
        return this.maximalColumnWidths.length;
    }

    @Override
    public TableAppender append(char c) {
        int cp = this.toCodePoint(c);
        if (!this.multiLinesCells) {
            if (cp == 9) {
                this.nextColumn();
                this.skipLF = false;
                return this;
            }
            if (Characters.isLineOrParagraphSeparator(cp)) {
                if (cp == 10) {
                    if (!this.skipLF) {
                        this.nextLine();
                    }
                    this.skipLF = false;
                } else {
                    this.nextLine();
                    this.skipLF = true;
                }
                return this;
            }
        }
        this.buffer.appendCodePoint(cp);
        this.skipLF = false;
        return this;
    }

    @Override
    public TableAppender append(CharSequence sequence) {
        if (sequence == null) {
            sequence = "null";
        }
        return this.append(sequence, 0, sequence.length());
    }

    @Override
    public TableAppender append(CharSequence sequence, int start, int end) {
        ArgumentChecks.ensureValidIndexRange(sequence.length(), start, end);
        if (this.lineSeparator == null) {
            this.lineSeparator = this.lineSeparator(sequence, start, end);
        }
        try {
            start = this.appendSurrogate(sequence, start, end);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (start != end) {
            if (this.skipLF && sequence.charAt(start) == '\n') {
                ++start;
            }
            if (!this.multiLinesCells) {
                int cp = 0;
                int upper = start;
                while (upper != end) {
                    if ((cp = this.toCodePoint(sequence.charAt(upper++))) < 0 || cp != 9 && !Characters.isLineOrParagraphSeparator(cp)) continue;
                    this.buffer.append(sequence, start, upper - Character.charCount(cp));
                    switch (cp) {
                        case 13: {
                            if (upper >= end || sequence.charAt(upper) == '\n') {
                                // empty if block
                            }
                        }
                        default: {
                            this.nextLine();
                            break;
                        }
                        case 9: {
                            this.nextColumn();
                        }
                    }
                    start = ++upper;
                }
                this.skipLF = cp == 13;
            } else {
                assert (!this.isHighSurrogate());
                boolean bl = this.skipLF = this.toCodePoint(sequence.charAt(end - 1)) == 13;
            }
            if (this.isHighSurrogate()) {
                --end;
            }
            this.buffer.append(sequence, start, end);
        }
        return this;
    }

    public void appendHorizontalSeparator() {
        if (this.currentColumn != 0 || this.buffer.length() != 0) {
            this.nextLine();
        }
        this.nextLine('\u2500');
    }

    public void nextColumn() {
        this.nextColumn(' ');
    }

    public void nextColumn(char fill) {
        String cellText = this.buffer.toString();
        this.cells.add(new Cell(cellText, this.alignment, fill));
        if (this.currentColumn >= this.maximalColumnWidths.length) {
            this.maximalColumnWidths = Arrays.copyOf(this.maximalColumnWidths, this.currentColumn + 1);
        }
        int width = 0;
        int lineStart = 0;
        int length = cellText.length();
        while (lineStart < length) {
            int nextLine;
            int i = nextLine = CharSequences.indexOfLineStart(cellText, 1, lineStart);
            while (--i >= lineStart) {
                int lg;
                if (Character.isISOControl(cellText.charAt(i)) || (lg = X364.lengthOfPlain(cellText, lineStart, i + 1)) <= width) continue;
                width = lg;
            }
            lineStart = nextLine;
        }
        if (width > this.maximalColumnWidths[this.currentColumn]) {
            this.maximalColumnWidths[this.currentColumn] = width;
        }
        ++this.currentColumn;
        this.buffer.setLength(0);
    }

    public void nextLine() {
        this.nextLine(' ');
    }

    public void nextLine(char fill) {
        if (this.buffer.length() != 0) {
            this.nextColumn(fill);
        }
        assert (this.buffer.length() == 0);
        this.cells.add(fill != ' ' ? new Cell(null, this.alignment, fill) : null);
        this.currentColumn = 0;
        ++this.currentRow;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.length() != 0) {
            this.nextLine();
            assert (this.buffer.length() == 0);
        }
        if (!this.ownOut) {
            this.writeTable();
        }
        this.cells.clear();
        this.currentRow = 0;
        this.currentColumn = 0;
        if (!(this.out instanceof TableAppender)) {
            IO.flush(this.out);
        }
    }

    @Override
    public String toString() {
        if (this.ownOut) {
            ((StringBuilder)this.out).setLength(0);
            try {
                this.writeTable();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return super.toString();
    }

    private void writeTable() throws IOException {
        String columnSeparator = this.columnSeparator;
        Object[] currentLine = new Cell[this.maximalColumnWidths.length];
        int cellCount = this.cells.size();
        for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
            Cell cell;
            Cell lineFill = null;
            int currentCount = 0;
            while ((cell = this.cells.get(cellIndex)) != null) {
                if (cell.text == null) {
                    lineFill = new Cell("", cell.alignment, cell.fill);
                    break;
                }
                currentLine[currentCount++] = cell;
                if (++cellIndex < cellCount) continue;
            }
            Arrays.fill(currentLine, currentCount, currentLine.length, lineFill);
            while (!TableAppender.isEmpty(currentLine)) {
                for (int j = 0; j < currentLine.length; ++j) {
                    int cellPadding;
                    boolean isFirstColumn = j == 0;
                    boolean isLastColumn = j + 1 == currentLine.length;
                    Object cell2 = currentLine[j];
                    int cellWidth = this.maximalColumnWidths[j];
                    int n = cellPadding = isLastColumn && this.rightBorder.isEmpty() ? 0 : cellWidth;
                    if (cell2 == null) {
                        if (isFirstColumn) {
                            this.out.append(this.leftBorder);
                        }
                        TableAppender.repeat(this.out, ' ', cellPadding);
                        this.out.append(isLastColumn ? this.rightBorder : columnSeparator);
                        continue;
                    }
                    String cellText = ((Cell)cell2).text;
                    int textLength = cellText.length();
                    Cell remaining = null;
                    int endOfFirstLine = 0;
                    while (endOfFirstLine < textLength) {
                        int c = cellText.codePointAt(endOfFirstLine);
                        int next = endOfFirstLine + Character.charCount(c);
                        if (Characters.isLineOrParagraphSeparator(c)) {
                            if (c != 13 || next >= textLength || cellText.charAt(next) == '\n') {
                                // empty if block
                            }
                            for (int i = ++next; i < textLength; i += Character.charCount(c)) {
                                c = cellText.codePointAt(i);
                                if (Character.isWhitespace(c)) continue;
                                remaining = ((Cell)cell2).substring(next);
                                break;
                            }
                            cellText = cellText.substring(0, endOfFirstLine);
                            break;
                        }
                        endOfFirstLine = next;
                    }
                    currentLine[j] = remaining;
                    textLength = X364.lengthOfPlain(cellText, 0, cellText.length());
                    if (currentCount == 0) {
                        assert (textLength == 0);
                        int verticalBorder = cellIndex == 0 ? -1 : (cellIndex >= cellCount - 1 ? 1 : 0);
                        if (isFirstColumn) {
                            this.writeBorder(-1, verticalBorder, ((Cell)cell2).fill);
                        }
                        TableAppender.repeat(this.out, ((Cell)cell2).fill, Character.isWhitespace(((Cell)cell2).fill) ? cellPadding : cellWidth);
                        this.writeBorder(isLastColumn ? 1 : 0, verticalBorder, ((Cell)cell2).fill);
                        continue;
                    }
                    if (isFirstColumn) {
                        this.out.append(this.leftBorder);
                    }
                    Appendable tabExpander = cellText.indexOf(9) >= 0 ? new LineAppender(this.out, Integer.MAX_VALUE, true) : this.out;
                    switch (((Cell)cell2).alignment) {
                        default: {
                            throw new AssertionError(((Cell)cell2).alignment);
                        }
                        case -1: {
                            tabExpander.append(cellText);
                            TableAppender.repeat(tabExpander, ((Cell)cell2).fill, cellPadding - textLength);
                            break;
                        }
                        case 1: {
                            TableAppender.repeat(tabExpander, ((Cell)cell2).fill, cellWidth - textLength);
                            tabExpander.append(cellText);
                            break;
                        }
                        case 0: {
                            int leftPadding = (cellWidth - textLength) / 2;
                            TableAppender.repeat(tabExpander, ((Cell)cell2).fill, leftPadding);
                            tabExpander.append(cellText);
                            TableAppender.repeat(tabExpander, ((Cell)cell2).fill, cellPadding - leftPadding - textLength);
                            break;
                        }
                    }
                    this.out.append(isLastColumn ? this.rightBorder : columnSeparator);
                }
                if (this.lineSeparator == null) {
                    this.lineSeparator = System.lineSeparator();
                }
                this.out.append(this.lineSeparator);
            }
        }
    }

    private static boolean isEmpty(Object[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    private static void repeat(Appendable out, char car, int count) throws IOException {
        if (out instanceof StringBuilder) {
            if (count > 0) {
                StringBuilders.repeat((StringBuilder)out, car, count);
            }
        } else {
            while (--count >= 0) {
                out.append(car);
            }
        }
    }

    private static final class Cell {
        final String text;
        byte alignment;
        final char fill;

        Cell(String text, byte alignment, char fill) {
            this.text = text;
            this.alignment = alignment;
            this.fill = fill;
        }

        Cell substring(int lower) {
            return new Cell(this.text.substring(lower), this.alignment, this.fill);
        }

        public String toString() {
            return this.text;
        }
    }
}

