/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.FormatField;
import org.apache.sis.measure.FormattedCharacterIterator;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public class AngleFormat
extends Format
implements Localized {
    private static final long serialVersionUID = 820524050016391537L;
    private static final char NORTH = 'N';
    private static final char SOUTH = 'S';
    private static final char EAST = 'E';
    private static final char WEST = 'W';
    private static final int PREFIX_FIELD = -1;
    static final int DEGREES_FIELD = 0;
    static final int MINUTES_FIELD = 1;
    static final int SECONDS_FIELD = 2;
    private static final int FRACTION_FIELD = 3;
    static final int HEMISPHERE_FIELD = 4;
    private static final int OPTIONAL_FIELD = 4;
    private static final int[] SYMBOLS = new int[]{68, 77, 83, 35, 63};
    private final Locale locale;
    private byte degreesFieldWidth;
    private byte minutesFieldWidth;
    private byte secondsFieldWidth;
    private byte fractionFieldWidth;
    private byte minimumFractionDigits;
    private byte maximumTotalWidth;
    private byte optionalFields;
    private String prefix;
    private String degreesSuffix;
    private String minutesSuffix;
    private String secondsSuffix;
    private RoundingMode roundingMode;
    private boolean isFallbackAllowed = true;
    private boolean useDecimalSeparator;
    private transient boolean showLeadingFields;
    private transient NumberFormat numberFormat;
    private transient FieldPosition dummyFieldPosition;
    private transient FormattedCharacterIterator characterIterator;

    private NumberFormat numberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat("#0", DecimalFormatSymbols.getInstance(this.locale));
        }
        return this.numberFormat;
    }

    private FieldPosition dummyFieldPosition() {
        if (this.dummyFieldPosition == null) {
            this.dummyFieldPosition = new FieldPosition(0);
        }
        return this.dummyFieldPosition;
    }

    public static AngleFormat getInstance() {
        return new AngleFormat();
    }

    public static AngleFormat getInstance(Locale locale) {
        return new AngleFormat(locale);
    }

    public AngleFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT));
    }

    public AngleFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.degreesFieldWidth = 1;
        this.minutesFieldWidth = (byte)2;
        this.secondsFieldWidth = (byte)2;
        this.fractionFieldWidth = (byte)16;
        this.optionalFields = (byte)7;
        this.degreesSuffix = "\u00b0";
        this.minutesSuffix = "\u2032";
        this.secondsSuffix = "\u2033";
        this.useDecimalSeparator = true;
    }

    public AngleFormat(String pattern) throws IllegalArgumentException {
        this(pattern, Locale.getDefault(Locale.Category.FORMAT));
    }

    public AngleFormat(String pattern, Locale locale) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", pattern);
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.applyPattern(pattern, SYMBOLS, 46);
    }

    public void applyPattern(String pattern) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", pattern);
        this.degreesFieldWidth = 0;
        this.minutesFieldWidth = 0;
        this.secondsFieldWidth = 0;
        this.fractionFieldWidth = 0;
        this.minimumFractionDigits = 0;
        this.maximumTotalWidth = 0;
        this.optionalFields = 0;
        this.prefix = null;
        this.degreesSuffix = null;
        this.minutesSuffix = null;
        this.secondsSuffix = null;
        this.useDecimalSeparator = false;
        this.applyPattern(pattern, SYMBOLS, 46);
    }

    private void applyPattern(String pattern, int[] symbols, int decimalSeparator) {
        this.degreesFieldWidth = 1;
        this.useDecimalSeparator = true;
        int expectedField = -1;
        int endPreviousField = 0;
        boolean parseFinished = false;
        int length = pattern.length();
        int i = 0;
        while (i < length) {
            boolean isIntegerField;
            int c = pattern.codePointAt(i);
            int charCount = Character.charCount(c);
            int upperCaseC = Character.toUpperCase(c);
            int field = AngleFormat.fieldForSymbol(symbols, upperCaseC);
            if (field < 0) {
                i += charCount;
                continue;
            }
            boolean bl = isIntegerField = c == upperCaseC && field != 3;
            if (isIntegerField) {
                ++expectedField;
            }
            if (parseFinished || field != expectedField && field != 3) {
                throw AngleFormat.illegalPattern(pattern);
            }
            if (isIntegerField) {
                String previousSuffix = null;
                if (endPreviousField < i) {
                    int endPreviousSuffix = i;
                    if (pattern.codePointBefore(endPreviousSuffix) == symbols[4]) {
                        if (--endPreviousSuffix == endPreviousField) {
                            throw AngleFormat.illegalPattern(pattern);
                        }
                        this.optionalFields = (byte)(this.optionalFields | 1 << field - 1);
                    }
                    previousSuffix = pattern.substring(endPreviousField, endPreviousSuffix);
                }
                int width = 1;
                while ((i += charCount) < length && pattern.codePointAt(i) == c) {
                    ++width;
                }
                byte wb = AngleFormat.toByte(width);
                switch (field) {
                    case 0: {
                        this.prefix = previousSuffix;
                        this.degreesFieldWidth = wb;
                        break;
                    }
                    case 1: {
                        this.degreesSuffix = previousSuffix;
                        this.minutesFieldWidth = wb;
                        break;
                    }
                    case 2: {
                        this.minutesSuffix = previousSuffix;
                        this.secondsFieldWidth = wb;
                        break;
                    }
                    default: {
                        throw new AssertionError(field);
                    }
                }
            } else {
                if (i == endPreviousField) {
                    this.useDecimalSeparator = false;
                } else {
                    int b = pattern.codePointAt(endPreviousField);
                    if (b != decimalSeparator || endPreviousField + Character.charCount(b) != i) {
                        throw AngleFormat.illegalPattern(pattern);
                    }
                }
                int width = 1;
                while ((i += charCount) < length) {
                    int fc = pattern.codePointAt(i);
                    if (fc != c) {
                        if (fc != symbols[3]) break;
                        this.minimumFractionDigits = AngleFormat.toByte(width);
                        c = fc;
                        charCount = Character.charCount(c);
                    }
                    ++width;
                }
                this.fractionFieldWidth = AngleFormat.toByte(width);
                if (c != symbols[3]) {
                    this.minimumFractionDigits = this.fractionFieldWidth;
                } else if (!this.useDecimalSeparator) {
                    throw new IllegalArgumentException(Errors.format((short)124));
                }
                parseFinished = true;
            }
            endPreviousField = i;
        }
        if (endPreviousField < length) {
            int endPreviousSuffix = length;
            if (pattern.codePointBefore(endPreviousSuffix) == symbols[4]) {
                if (--endPreviousSuffix == endPreviousField) {
                    throw AngleFormat.illegalPattern(pattern);
                }
                this.optionalFields = (byte)(this.optionalFields | 1 << expectedField);
            }
            String suffix = pattern.substring(endPreviousField, endPreviousSuffix);
            switch (expectedField) {
                case 0: {
                    this.degreesSuffix = suffix;
                    break;
                }
                case 1: {
                    this.minutesSuffix = suffix;
                    break;
                }
                case 2: {
                    this.secondsSuffix = suffix;
                    break;
                }
                default: {
                    throw AngleFormat.illegalPattern(pattern);
                }
            }
        }
    }

    private static int fieldForSymbol(int[] symbols, int c) {
        for (int field = 0; field <= 3; ++field) {
            if (c != symbols[field]) continue;
            return field;
        }
        return -1;
    }

    private static IllegalArgumentException illegalPattern(String pattern) {
        return new IllegalArgumentException(Errors.format((short)52, Angle.class, pattern));
    }

    public String toPattern() {
        return this.toPattern(SYMBOLS, 46);
    }

    private String toPattern(int[] symbols, int decimalSeparator) {
        int symbol = 0;
        boolean previousWasOptional = false;
        StringBuilder buffer = new StringBuilder();
        for (int field = 0; field <= 3; ++field) {
            int width;
            String previousSuffix;
            switch (field) {
                case 0: {
                    previousSuffix = this.prefix;
                    width = this.degreesFieldWidth;
                    break;
                }
                case 1: {
                    previousSuffix = this.degreesSuffix;
                    width = this.minutesFieldWidth;
                    break;
                }
                case 2: {
                    previousSuffix = this.minutesSuffix;
                    width = this.secondsFieldWidth;
                    break;
                }
                default: {
                    previousSuffix = this.secondsSuffix;
                    width = 0;
                }
            }
            if (width == 0 && (width = this.fractionFieldWidth) > 0) {
                if (this.useDecimalSeparator) {
                    buffer.appendCodePoint(decimalSeparator);
                }
                int optional = width - this.minimumFractionDigits;
                symbol = Character.toLowerCase(symbol);
                do {
                    if (width == optional) {
                        symbol = symbols[3];
                    }
                    buffer.appendCodePoint(symbol);
                } while (--width > 0);
            }
            if (previousSuffix != null) {
                buffer.append(previousSuffix);
            }
            if (previousWasOptional) {
                buffer.appendCodePoint(symbols[4]);
            }
            if (width <= 0) break;
            symbol = symbols[field];
            do {
                buffer.appendCodePoint(symbol);
            } while (--width > 0);
            previousWasOptional = (this.optionalFields & 1 << field) != 0;
        }
        return buffer.toString();
    }

    private static byte toByte(int n) {
        return (byte)Math.min(n, 127);
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode != null ? this.roundingMode : RoundingMode.HALF_EVEN;
    }

    public void setRoundingMode(RoundingMode mode) {
        ArgumentChecks.ensureNonNull("mode", (Object)mode);
        if (mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_DOWN) {
            throw new IllegalArgumentException(Errors.format((short)170, (Object)mode));
        }
        this.roundingMode = mode;
    }

    private double round(double sign, double value) {
        if (this.roundingMode != null) {
            switch (this.roundingMode) {
                case UP: {
                    return Math.ceil(value);
                }
                case DOWN: {
                    return Math.floor(value);
                }
                case CEILING: {
                    return Math.abs(Math.ceil(Math.copySign(value, sign)));
                }
                case FLOOR: {
                    return Math.abs(Math.floor(Math.copySign(value, sign)));
                }
            }
        }
        return Math.rint(value);
    }

    public double getPrecision() {
        double precision = MathFunctions.pow10(-this.fractionFieldWidth);
        if (this.secondsFieldWidth != 0) {
            precision /= 3600.0;
        } else if (this.minutesFieldWidth != 0) {
            precision /= 60.0;
        }
        return precision;
    }

    public void setPrecision(double resolution, boolean allowFieldChanges) {
        int significandFractionDigits;
        ArgumentChecks.ensureFinite("resolution", resolution);
        resolution = Math.abs(resolution);
        if (resolution == 0.0) {
            resolution = 1.0E-16;
        }
        if (allowFieldChanges ? resolution >= 0.1 : this.minutesFieldWidth == 0) {
            significandFractionDigits = 14;
            if (allowFieldChanges) {
                this.minutesFieldWidth = 0;
                this.secondsFieldWidth = 0;
                this.optionalFields = (byte)6;
            }
        } else {
            resolution = Math.nextUp(resolution * 60.0);
            if (allowFieldChanges ? resolution >= 0.1 : this.secondsFieldWidth == 0) {
                significandFractionDigits = 12;
                if (allowFieldChanges) {
                    if (this.minutesFieldWidth == 0) {
                        this.minutesFieldWidth = (byte)2;
                    }
                    this.secondsFieldWidth = 0;
                    this.optionalFields = (byte)4;
                }
            } else {
                resolution = Math.nextUp(resolution * 60.0);
                significandFractionDigits = 10;
                if (allowFieldChanges) {
                    if (this.minutesFieldWidth == 0) {
                        this.minutesFieldWidth = (byte)2;
                    }
                    if (this.secondsFieldWidth == 0) {
                        this.secondsFieldWidth = (byte)2;
                    }
                    this.optionalFields = 0;
                }
            }
        }
        int p = Math.max(0, DecimalFunctions.fractionDigitsForDelta(resolution, false));
        this.fractionFieldWidth = (byte)p;
        this.minimumFractionDigits = (byte)Math.min(significandFractionDigits, p);
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumFractionDigits(int count) {
        ArgumentChecks.ensurePositive("count", count);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = 0;
        this.minimumFractionDigits = AngleFormat.toByte(count);
        if (this.minimumFractionDigits > this.fractionFieldWidth) {
            this.fractionFieldWidth = this.minimumFractionDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.fractionFieldWidth;
    }

    public void setMaximumFractionDigits(int count) {
        ArgumentChecks.ensurePositive("count", count);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = 0;
        this.fractionFieldWidth = AngleFormat.toByte(count);
        if (this.fractionFieldWidth < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.fractionFieldWidth;
        }
    }

    public void setMaximumWidth(int width) {
        ArgumentChecks.ensureStrictlyPositive("width", width);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = AngleFormat.toByte(width);
        for (int field = -1; field <= 2; ++field) {
            String suffix;
            int previousWidth = width;
            switch (field) {
                case -1: {
                    suffix = this.prefix;
                    break;
                }
                case 0: {
                    width -= this.degreesFieldWidth;
                    suffix = this.degreesSuffix;
                    break;
                }
                case 1: {
                    width -= this.minutesFieldWidth;
                    suffix = this.minutesSuffix;
                    break;
                }
                case 2: {
                    width -= this.secondsFieldWidth;
                    suffix = this.secondsSuffix;
                    break;
                }
                default: {
                    throw new AssertionError(field);
                }
            }
            if (suffix != null) {
                width -= suffix.length();
            }
            if (width >= 0) continue;
            switch (field) {
                default: {
                    width += this.degreesFieldWidth - 1;
                    this.degreesFieldWidth = 1;
                }
                case 1: {
                    this.minutesSuffix = null;
                    this.minutesFieldWidth = 0;
                }
                case 2: 
            }
            this.secondsSuffix = null;
            this.secondsFieldWidth = 0;
            if (field < 1) break;
            width = previousWidth;
            break;
        }
        if (--width < this.fractionFieldWidth) {
            this.fractionFieldWidth = AngleFormat.toByte(Math.max(width, 0));
            if (this.fractionFieldWidth < this.minimumFractionDigits) {
                this.minimumFractionDigits = this.fractionFieldWidth;
            }
        }
    }

    private static int getField(FieldPosition position) {
        if (position != null) {
            Format.Field field = position.getFieldAttribute();
            if (field instanceof Field) {
                return ((Field)field).field;
            }
            return position.getField();
        }
        return -1;
    }

    public final String format(double angle) {
        return this.format(angle, new StringBuffer(), (FieldPosition)null).toString();
    }

    public StringBuffer format(double angle, StringBuffer toAppendTo, FieldPosition pos) {
        boolean hasMore;
        int offset = toAppendTo.length();
        int fieldPos = AngleFormat.getField(pos);
        if (!Double.isFinite(angle)) {
            toAppendTo = this.numberFormat().format(angle, toAppendTo, this.dummyFieldPosition());
            if (fieldPos >= 0 && fieldPos <= 2) {
                pos.setBeginIndex(offset);
                pos.setEndIndex(toAppendTo.length());
            }
            return toAppendTo;
        }
        double degrees2 = angle;
        double minutes = Double.NaN;
        double seconds = Double.NaN;
        int maximumFractionDigits = this.fractionFieldWidth;
        if (this.minutesFieldWidth == 0) {
            double p = MathFunctions.pow10(maximumFractionDigits);
            degrees2 = this.round(angle, degrees2 * p) / p;
        } else {
            double d = degrees2;
            degrees2 = MathFunctions.truncate(degrees2);
            minutes = Math.abs(d - degrees2) * 60.0;
            int n = DecimalFunctions.fractionDigitsForDelta(Math.ulp(angle) * (double)(this.secondsFieldWidth == 0 ? 60 : 3600), false);
            maximumFractionDigits = Math.max(this.minimumFractionDigits, Math.min(maximumFractionDigits, n - 1));
            double p = MathFunctions.pow10(maximumFractionDigits);
            if (this.secondsFieldWidth != 0) {
                double d2 = minutes;
                minutes = MathFunctions.truncate(minutes);
                seconds = (d2 - minutes) * 60.0;
                if ((seconds = this.round(angle, seconds * p) / p) >= 60.0) {
                    seconds = 0.0;
                    minutes += 1.0;
                }
            } else {
                minutes = this.round(angle, minutes * p) / p;
            }
            if (minutes >= 60.0) {
                minutes = 0.0;
                degrees2 += Math.signum(angle);
            }
        }
        byte effectiveOptionalFields = this.optionalFields;
        if (this.showLeadingFields) {
            effectiveOptionalFields = (byte)(effectiveOptionalFields & 0xFFFFFFFE);
            if (minutes == 0.0 && ((effectiveOptionalFields & 4) == 0 || seconds != 0.0)) {
                effectiveOptionalFields = (byte)(effectiveOptionalFields & 0xFFFFFFFD);
            }
        }
        int field = -1;
        if (this.prefix != null) {
            toAppendTo.append(this.prefix);
        }
        NumberFormat numberFormat = this.numberFormat();
        do {
            String suffix;
            int width;
            double value;
            switch (++field) {
                case 0: {
                    value = degrees2;
                    width = this.degreesFieldWidth;
                    suffix = this.degreesSuffix;
                    hasMore = this.minutesFieldWidth != 0;
                    break;
                }
                case 1: {
                    value = minutes;
                    width = this.minutesFieldWidth;
                    suffix = this.minutesSuffix;
                    hasMore = this.secondsFieldWidth != 0;
                    break;
                }
                case 2: {
                    value = seconds;
                    width = this.secondsFieldWidth;
                    suffix = this.secondsSuffix;
                    hasMore = false;
                    break;
                }
                default: {
                    throw new AssertionError(field);
                }
            }
            if (value == 0.0 && (effectiveOptionalFields & 1 << field) != 0) {
                switch (field) {
                    case 0: {
                        minutes = Math.copySign(minutes, degrees2);
                        break;
                    }
                    case 1: {
                        seconds = Math.copySign(seconds, minutes);
                    }
                }
                continue;
            }
            if (hasMore) {
                numberFormat.setMinimumIntegerDigits(width);
                numberFormat.setMaximumFractionDigits(0);
            } else if (this.useDecimalSeparator) {
                numberFormat.setMinimumIntegerDigits(width);
                if (this.maximumTotalWidth != 0) {
                    int available = this.maximumTotalWidth - toAppendTo.codePointCount(offset, toAppendTo.length());
                    available -= width + 1;
                    if (suffix != null) {
                        width -= suffix.length();
                    }
                    for (double scale = MathFunctions.pow10(width); value >= scale && --available > 0; scale *= 10.0) {
                    }
                    if (available < maximumFractionDigits) {
                        maximumFractionDigits = Math.max(available, 0);
                    }
                }
                numberFormat.setMinimumFractionDigits(this.minimumFractionDigits);
                numberFormat.setMaximumFractionDigits(maximumFractionDigits);
            } else {
                value *= MathFunctions.pow10(this.fractionFieldWidth);
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setMinimumIntegerDigits(width + this.fractionFieldWidth);
            }
            int startPosition = toAppendTo.length();
            if (this.characterIterator != null) {
                FormattedCharacterIterator it = this.characterIterator;
                it.append(numberFormat.formatToCharacterIterator(value), toAppendTo);
                if (suffix != null) {
                    toAppendTo.append(suffix);
                }
                Number userObject = hasMore ? (Number)Math.toIntExact(Math.round(value)) : (Number)Float.valueOf((float)value);
                it.addFieldLimit(Field.forCode(field), userObject, startPosition);
            } else {
                toAppendTo = numberFormat.format(value, toAppendTo, this.dummyFieldPosition());
                if (suffix != null) {
                    toAppendTo.append(suffix);
                }
            }
            if (field != fieldPos) continue;
            pos.setBeginIndex(startPosition);
            pos.setEndIndex(toAppendTo.length());
        } while (hasMore);
        return toAppendTo;
    }

    @Override
    public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition pos) throws IllegalArgumentException {
        if (value instanceof Latitude) {
            return this.format(((Latitude)value).degrees(), toAppendTo, pos, 'N', 'S');
        }
        if (value instanceof Longitude) {
            return this.format(((Longitude)value).degrees(), toAppendTo, pos, 'E', 'W');
        }
        if (value instanceof Angle) {
            return this.format(((Angle)value).degrees(), toAppendTo, pos);
        }
        ArgumentChecks.ensureNonNull("value", value);
        throw new IllegalArgumentException(Errors.format((short)43, "value", Angle.class, value.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double angle, StringBuffer toAppendTo, FieldPosition pos, char positiveSuffix, char negativeSuffix) {
        try {
            this.showLeadingFields = true;
            toAppendTo = this.format(Math.abs(angle), toAppendTo, pos);
        }
        finally {
            this.showLeadingFields = false;
        }
        int startPosition = toAppendTo.length();
        char suffix = MathFunctions.isNegative(angle) ? negativeSuffix : positiveSuffix;
        toAppendTo.append(suffix);
        if (AngleFormat.getField(pos) == 4) {
            pos.setBeginIndex(startPosition);
            pos.setEndIndex(toAppendTo.length());
        }
        if (this.characterIterator != null) {
            this.characterIterator.addFieldLimit(Field.HEMISPHERE, Character.valueOf(suffix), startPosition);
        }
        return toAppendTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object value) {
        StringBuffer buffer = new StringBuffer();
        FormattedCharacterIterator it = new FormattedCharacterIterator(buffer);
        try {
            this.characterIterator = it;
            this.format(value, buffer, null);
        }
        finally {
            this.characterIterator = null;
        }
        return it;
    }

    private int skipSuffix(String source, ParsePosition pos, int expectedField) {
        int field = expectedField;
        int start = pos.getIndex();
        int length = source.length();
        assert (field >= -1 && field <= 2) : field;
        do {
            String toSkip;
            int index = start;
            switch (field) {
                case -1: {
                    toSkip = this.prefix;
                    break;
                }
                case 0: {
                    toSkip = this.degreesSuffix;
                    break;
                }
                case 1: {
                    toSkip = this.minutesSuffix;
                    break;
                }
                case 2: {
                    toSkip = this.secondsSuffix;
                    break;
                }
                default: {
                    throw new AssertionError(field);
                }
            }
            if (toSkip != null) {
                int c;
                do {
                    if (source.startsWith(toSkip, index)) {
                        pos.setIndex(index + toSkip.length());
                        return field;
                    }
                    if (index >= length) break;
                    c = source.codePointAt(index);
                    index += Character.charCount(c);
                } while (Character.isSpaceChar(c));
            }
            if (++field <= 2) continue;
            field = -1;
        } while (field != expectedField);
        if (this.isFallbackAllowed) {
            int c;
            do {
                if (start >= length) {
                    return Integer.MIN_VALUE;
                }
                c = source.codePointAt(start);
                start += Character.charCount(c);
            } while (Character.isSpaceChar(c));
            switch (c) {
                case 176: {
                    pos.setIndex(start);
                    return 0;
                }
                case 39: 
                case 8242: {
                    pos.setIndex(start);
                    return 1;
                }
                case 34: 
                case 8243: {
                    pos.setIndex(start);
                    return 2;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    private static int skipSpaces(String source, int index, int length) {
        int c;
        while (index < length && Character.isSpaceChar(c = source.codePointAt(index))) {
            index += Character.charCount(c);
        }
        return index;
    }

    public Angle parse(String source, ParsePosition pos) {
        return this.parse(source, pos, false);
    }

    private Angle parse(String source, ParsePosition pos, boolean spaceAsSeparator) {
        int c;
        double minutes = Double.NaN;
        double seconds = Double.NaN;
        int length = source.length();
        NumberFormat numberFormat = this.numberFormat();
        int indexStart = pos.getIndex();
        int index = this.skipSuffix(source, pos, -1);
        if (index >= 0 && index <= 2) {
            pos.setErrorIndex(indexStart);
            pos.setIndex(indexStart);
            return null;
        }
        index = AngleFormat.skipSpaces(source, pos.getIndex(), length);
        pos.setIndex(index);
        Number fieldObject = numberFormat.parse(source, pos);
        if (fieldObject == null) {
            pos.setIndex(indexStart);
            if (pos.getErrorIndex() < indexStart) {
                pos.setErrorIndex(index);
            }
            return null;
        }
        double degrees2 = fieldObject.doubleValue();
        int indexEndField = pos.getIndex();
        boolean missingDegrees = true;
        block0 : switch (this.skipSuffix(source, pos, 0)) {
            case -1: {
                pos.setIndex(indexEndField);
                break;
            }
            case 2: {
                seconds = degrees2;
                degrees2 = Double.NaN;
                break;
            }
            default: {
                if (!spaceAsSeparator || !this.isFallbackAllowed || this.minutesFieldWidth == 0) break;
            }
            case 0: {
                int indexStartField = pos.getIndex();
                index = AngleFormat.skipSpaces(source, indexStartField, length);
                if (!spaceAsSeparator && index != indexStartField) break;
                pos.setIndex(index);
                fieldObject = numberFormat.parse(source, pos);
                if (fieldObject == null) {
                    pos.setIndex(indexStartField);
                    break;
                }
                indexEndField = pos.getIndex();
                minutes = fieldObject.doubleValue();
                switch (this.skipSuffix(source, pos, this.minutesFieldWidth != 0 ? 1 : -1)) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        seconds = minutes;
                        minutes = Double.NaN;
                        break block0;
                    }
                    default: {
                        if (spaceAsSeparator && this.isFallbackAllowed && this.minutesFieldWidth != 0) break;
                    }
                    case 0: {
                        pos.setIndex(indexStartField);
                        minutes = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        pos.setIndex(indexEndField);
                        break block0;
                    }
                }
                missingDegrees = false;
            }
            case 1: {
                if (missingDegrees) {
                    minutes = degrees2;
                    degrees2 = Double.NaN;
                }
                int indexStartField = pos.getIndex();
                index = AngleFormat.skipSpaces(source, indexStartField, length);
                if (!spaceAsSeparator && index != indexStartField) break;
                pos.setIndex(index);
                fieldObject = numberFormat.parse(source, pos);
                if (fieldObject == null) {
                    pos.setIndex(indexStartField);
                    break;
                }
                indexEndField = pos.getIndex();
                seconds = fieldObject.doubleValue();
                switch (this.skipSuffix(source, pos, this.secondsFieldWidth != 0 ? 1 : -1)) {
                    case 2: {
                        break block0;
                    }
                    default: {
                        if (this.isFallbackAllowed && this.secondsFieldWidth != 0) break block0;
                    }
                    case 0: 
                    case 1: {
                        pos.setIndex(indexStartField);
                        seconds = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        pos.setIndex(indexEndField);
                        break block0;
                    }
                }
            }
        }
        if (MathFunctions.isNegative(minutes)) {
            seconds = -seconds;
        }
        if (MathFunctions.isNegative(degrees2)) {
            minutes = -minutes;
            seconds = -seconds;
        }
        if (!this.useDecimalSeparator) {
            double facteur = MathFunctions.pow10(this.fractionFieldWidth);
            if (this.secondsFieldWidth != 0) {
                if (this.minutesSuffix == null && Double.isNaN(seconds)) {
                    if (this.degreesSuffix == null && Double.isNaN(minutes)) {
                        degrees2 /= facteur;
                    } else {
                        minutes /= facteur;
                    }
                } else {
                    seconds /= facteur;
                }
            } else if (Double.isNaN(seconds)) {
                if (this.minutesFieldWidth != 0) {
                    if (this.degreesSuffix == null && Double.isNaN(minutes)) {
                        degrees2 /= facteur;
                    } else {
                        minutes /= facteur;
                    }
                } else if (Double.isNaN(minutes)) {
                    degrees2 /= facteur;
                }
            }
        }
        if (this.minutesSuffix == null && this.secondsFieldWidth != 0 && Double.isNaN(seconds)) {
            double facteur = MathFunctions.pow10(this.secondsFieldWidth);
            if (this.degreesSuffix == null && this.minutesFieldWidth != 0 && Double.isNaN(minutes)) {
                seconds = degrees2;
                minutes = MathFunctions.truncate(degrees2 / facteur);
                seconds -= minutes * facteur;
                facteur = MathFunctions.pow10(this.minutesFieldWidth);
                degrees2 = MathFunctions.truncate(minutes / facteur);
                minutes -= degrees2 * facteur;
            } else {
                seconds = minutes;
                minutes = MathFunctions.truncate(minutes / facteur);
                seconds -= minutes * facteur;
            }
        } else if (this.degreesSuffix == null && this.minutesFieldWidth != 0 && Double.isNaN(minutes)) {
            double facteur = MathFunctions.pow10(this.minutesFieldWidth);
            minutes = degrees2;
            degrees2 = MathFunctions.truncate(degrees2 / facteur);
            minutes -= degrees2 * facteur;
        }
        pos.setErrorIndex(-1);
        if (Double.isNaN(degrees2)) {
            degrees2 = 0.0;
        }
        if (!Double.isNaN(minutes)) {
            degrees2 += minutes / 60.0;
        }
        if (!Double.isNaN(seconds)) {
            degrees2 += seconds / 3600.0;
        }
        for (int index2 = pos.getIndex(); index2 < length; index2 += Character.charCount(c)) {
            c = source.codePointAt(index2);
            switch (Character.toUpperCase(c)) {
                case 78: {
                    pos.setIndex(index2);
                    return new Latitude(degrees2);
                }
                case 83: {
                    pos.setIndex(index2);
                    return new Latitude(-degrees2);
                }
                case 69: {
                    pos.setIndex(index2);
                    return new Longitude(degrees2);
                }
                case 87: {
                    pos.setIndex(index2);
                    return new Longitude(-degrees2);
                }
            }
            if (Character.isSpaceChar(c)) continue;
            break;
        }
        return new Angle(degrees2);
    }

    public Angle parse(String source) throws ParseException {
        int length;
        ParsePosition pos = new ParsePosition(0);
        Angle angle = this.parse(source, pos, true);
        int offset = pos.getIndex();
        if (AngleFormat.skipSpaces(source, offset, length = source.length()) < length) {
            throw new LocalizedParseException(this.locale, Angle.class, source, pos);
        }
        return angle;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.parse(source);
    }

    public boolean isFallbackAllowed() {
        return this.isFallbackAllowed;
    }

    public void setFallbackAllowed(boolean allowed) {
        this.isFallbackAllowed = allowed;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public AngleFormat clone() {
        AngleFormat clone = (AngleFormat)super.clone();
        clone.numberFormat = null;
        clone.dummyFieldPosition = null;
        return clone;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.degreesFieldWidth, this.minutesFieldWidth, this.secondsFieldWidth, this.fractionFieldWidth, this.minimumFractionDigits, this.useDecimalSeparator, this.isFallbackAllowed, this.optionalFields, this.roundingMode, this.locale, this.prefix, this.degreesSuffix, this.minutesSuffix, this.secondsSuffix}) ^ 0xB2E45171;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            AngleFormat cast = (AngleFormat)object;
            return this.degreesFieldWidth == cast.degreesFieldWidth && this.minutesFieldWidth == cast.minutesFieldWidth && this.secondsFieldWidth == cast.secondsFieldWidth && this.fractionFieldWidth == cast.fractionFieldWidth && this.minimumFractionDigits == cast.minimumFractionDigits && this.useDecimalSeparator == cast.useDecimalSeparator && this.isFallbackAllowed == cast.isFallbackAllowed && this.optionalFields == cast.optionalFields && this.roundingMode == cast.roundingMode && Objects.equals(this.locale, cast.locale) && Objects.equals(this.prefix, cast.prefix) && Objects.equals(this.degreesSuffix, cast.degreesSuffix) && Objects.equals(this.minutesSuffix, cast.minutesSuffix) && Objects.equals(this.secondsSuffix, cast.secondsSuffix);
        }
        return false;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.toPattern());
    }

    public static final class Field
    extends FormatField {
        private static final long serialVersionUID = -5015489890305908251L;
        public static final Field DEGREES = new Field("DEGREES", 0);
        public static final Field MINUTES = new Field("MINUTES", 1);
        public static final Field SECONDS = new Field("SECONDS", 2);
        public static final Field HEMISPHERE = new Field("HEMISPHERE", 4);

        private Field(String name, int fieldID) {
            super(name, fieldID);
        }

        static Field forCode(int field) {
            switch (field) {
                case 0: {
                    return DEGREES;
                }
                case 1: {
                    return MINUTES;
                }
                case 2: {
                    return SECONDS;
                }
                case 4: {
                    return HEMISPHERE;
                }
            }
            throw new AssertionError(field);
        }
    }
}

