/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.AngularVelocity;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.PowerOf10;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.Salinity;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScaleRateOfChange;
import org.apache.sis.measure.SexagesimalConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Units
extends Static {
    public static final Unit<Length> NANOMETRE;
    public static final Unit<Length> MILLIMETRE;
    public static final Unit<Length> CENTIMETRE;
    public static final Unit<Length> METRE;
    public static final Unit<Length> KILOMETRE;
    public static final Unit<Length> NAUTICAL_MILE;
    public static final Unit<Length> STATUTE_MILE;
    public static final Unit<Length> US_SURVEY_FOOT;
    public static final Unit<Length> CLARKE_FOOT;
    public static final Unit<Length> FOOT;
    public static final Unit<Length> INCH;
    public static final Unit<Length> POINT;
    public static final Unit<Area> SQUARE_METRE;
    public static final Unit<Area> HECTARE;
    public static final Unit<Volume> CUBIC_METRE;
    public static final Unit<Volume> LITRE;
    public static final Unit<SolidAngle> STERADIAN;
    public static final Unit<Angle> MICRORADIAN;
    public static final Unit<Angle> RADIAN;
    public static final Unit<Angle> DEGREE;
    public static final Unit<Angle> ARC_MINUTE;
    public static final Unit<Angle> ARC_SECOND;
    public static final Unit<Angle> GRAD;
    public static final Unit<Time> MILLISECOND;
    public static final Unit<Time> SECOND;
    public static final Unit<Time> MINUTE;
    public static final Unit<Time> HOUR;
    public static final Unit<Time> DAY;
    public static final Unit<Time> WEEK;
    public static final Unit<Time> TROPICAL_YEAR;
    public static final Unit<Frequency> HERTZ;
    public static final Unit<AngularVelocity> RADIANS_PER_SECOND;
    public static final Unit<Speed> METRES_PER_SECOND;
    public static final Unit<Speed> KILOMETRES_PER_HOUR;
    public static final Unit<Acceleration> METRES_PER_SECOND_SQUARED;
    public static final Unit<Acceleration> GAL;
    public static final Unit<Pressure> PASCAL;
    public static final Unit<Pressure> HECTOPASCAL;
    public static final Unit<Pressure> DECIBAR;
    public static final Unit<Pressure> BAR;
    public static final Unit<Pressure> ATMOSPHERE;
    public static final Unit<Force> NEWTON;
    public static final Unit<Energy> JOULE;
    public static final Unit<Power> WATT;
    public static final Unit<ElectricPotential> VOLT;
    public static final Unit<ElectricCurrent> AMPERE;
    public static final Unit<ElectricCharge> COULOMB;
    public static final Unit<ElectricCapacitance> FARAD;
    public static final Unit<ElectricResistance> OHM;
    public static final Unit<ElectricConductance> SIEMENS;
    public static final Unit<MagneticFlux> WEBER;
    public static final Unit<MagneticFluxDensity> TESLA;
    public static final Unit<ElectricInductance> HENRY;
    public static final Unit<Temperature> KELVIN;
    public static final Unit<Temperature> CELSIUS;
    public static final Unit<Temperature> FAHRENHEIT;
    public static final Unit<LuminousIntensity> CANDELA;
    public static final Unit<LuminousFlux> LUMEN;
    public static final Unit<Illuminance> LUX;
    public static final Unit<Mass> GRAM;
    public static final Unit<Mass> KILOGRAM;
    public static final Unit<AmountOfSubstance> MOLE;
    public static final Unit<Dimensionless> UNITY;
    public static final Unit<Dimensionless> PERCENT;
    public static final Unit<Dimensionless> PPM;
    public static final Unit<Dimensionless> DECIBEL;
    public static final Unit<Salinity> PSU;
    static final Unit<Dimensionless> SIGMA;
    public static final Unit<Dimensionless> PIXEL;
    static final boolean initialized;

    private static <Q extends Quantity<Q>> SystemUnit<Q> add(Class<Q> quantity, ScalarFactory<Q> factory, UnitDimension dimension, String symbol, byte scope, short epsg) {
        return UnitRegistry.init(new SystemUnit<Q>(quantity, dimension, symbol, scope, epsg, factory));
    }

    private static <Q extends Quantity<Q>> ConventionalUnit<Q> add(AbstractUnit<Q> target, UnitConverter toTarget, String symbol, byte scope, short epsg) {
        ConventionalUnit<Q> unit = UnitRegistry.init(new ConventionalUnit<Q>(target, toTarget, symbol, scope, epsg));
        ConventionalUnit<Q>[] related = target.related();
        if (!(related == null || unit.scope == 2 && toTarget.isLinear())) {
            int i = 0;
            while (related[i] != null) {
                ++i;
            }
            related[i] = unit;
        }
        return unit;
    }

    static SystemUnit<?> get(Dimension dim) {
        return (SystemUnit)UnitRegistry.get(dim);
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> get(Class<Q> type) {
        return (SystemUnit)UnitRegistry.get(type);
    }

    static Unit<?> get(String symbol) {
        return (Unit)UnitRegistry.get(symbol);
    }

    private Units() {
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(RADIAN);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(METRE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(PASCAL);
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(SECOND);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.getSystemUnit().equals(UNITY);
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((short)100, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((short)103, unit));
        }
        return unit;
    }

    public static Unit<Time> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format((short)107, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format((short)105, unit));
        }
        return unit;
    }

    public static <Q extends Quantity<Q>> Unit<Q> multiply(Unit<Q> unit, double numerator, double denominator) {
        return unit.transform(LinearConverter.scale(numerator, denominator));
    }

    public static <Q extends Quantity<Q>> double toStandardUnit(Unit<Q> unit) {
        return AbstractConverter.scale(unit == null ? null : unit.getConverterTo(unit.getSystemUnit()));
    }

    public static UnitConverter converter(Number scale, Number offset) {
        return LinearConverter.create(scale, offset);
    }

    public static Number[] coefficients(UnitConverter converter) {
        if (converter != null) {
            if (converter instanceof AbstractConverter) {
                return ((AbstractConverter)converter).coefficients();
            }
            if (converter.isIdentity()) {
                return new Number[0];
            }
            if (converter.isLinear()) {
                double offset = converter.convert(0.0);
                double scale = converter.convert(1.0) - offset;
                Number[] c = new Number[scale != 1.0 ? 2 : (offset != 0.0 ? 1 : 0)];
                switch (c.length) {
                    case 2: {
                        c[1] = scale;
                    }
                    case 1: {
                        c[0] = offset;
                    }
                }
                return c;
            }
        }
        return null;
    }

    public static double derivative(UnitConverter converter, double value) {
        return AbstractConverter.derivative(converter, value);
    }

    public static Unit<?> valueOf(String uom) throws MeasurementParseException {
        return uom != null ? UnitFormat.INSTANCE.parse(uom) : null;
    }

    public static Unit<?> valueOfEPSG(int code) {
        switch (code) {
            case 9102: 
            case 9122: {
                return DEGREE;
            }
            case 9001: {
                return METRE;
            }
            case 9107: 
            case 9108: {
                return SexagesimalConverter.DMS_SCALED;
            }
            case 9110: {
                return SexagesimalConverter.DMS;
            }
            case 9111: {
                return SexagesimalConverter.DM;
            }
            case 9201: 
            case 9203: {
                return UNITY;
            }
        }
        return code > 0 && code <= Short.MAX_VALUE ? (Unit)UnitRegistry.get((short)code) : null;
    }

    public static Integer getEpsgCode(Unit<?> unit, boolean inAxis) {
        if (unit != null) {
            if (!(unit instanceof AbstractUnit) && !((unit = Units.get(unit.getSymbol())) instanceof AbstractUnit)) {
                return null;
            }
            int code = ((AbstractUnit)unit).epsg;
            if (code != 0) {
                if (inAxis && code == 9102) {
                    code = 9122;
                }
                return code;
            }
        }
        return null;
    }

    static {
        UnitDimension length = new UnitDimension('L');
        UnitDimension mass = new UnitDimension('M');
        UnitDimension time = new UnitDimension('T');
        UnitDimension current = new UnitDimension('I');
        UnitDimension temperature = new UnitDimension('\u0398');
        UnitDimension amount = new UnitDimension('N');
        UnitDimension luminous = new UnitDimension('J');
        UnitDimension frequency = time.pow(-1);
        UnitDimension area = length.pow(2);
        UnitDimension speed = length.divide(time);
        UnitDimension acceleration = speed.divide(time);
        UnitDimension force = mass.multiply(speed).divide(time);
        UnitDimension energy = force.multiply(length);
        UnitDimension power = energy.divide(time);
        UnitDimension charge = current.multiply(time);
        UnitDimension potential = power.divide(current);
        UnitDimension magneticFlux = potential.multiply(time);
        UnitDimension pressure = force.divide(area);
        UnitDimension dimensionless = UnitDimension.NONE;
        SystemUnit<Length> m4 = Units.add(Length.class, Scalar.Length::new, length, "m", (byte)3, (short)9001);
        SystemUnit<Area> m22 = Units.add(Area.class, Scalar.Area::new, area, "m\u00b2", (byte)3, (short)0);
        SystemUnit<Volume> m32 = Units.add(Volume.class, Scalar.Volume::new, length.pow(3), "m\u00b3", (byte)3, (short)0);
        SystemUnit<Time> s2 = Units.add(Time.class, Scalar.Time::new, time, "s", (byte)3, (short)1040);
        SystemUnit<Temperature> K2 = Units.add(Temperature.class, Scalar.Temperature.FACTORY, temperature, "\u212a", (byte)3, (short)0);
        SystemUnit<Speed> mps = Units.add(Speed.class, Scalar.Speed::new, speed, "m\u2215s", (byte)3, (short)1026);
        SystemUnit<Acceleration> mps2 = Units.add(Acceleration.class, Scalar.Acceleration::new, acceleration, "m\u2215s\u00b2", (byte)3, (short)0);
        SystemUnit<Pressure> Pa = Units.add(Pressure.class, Scalar.Pressure::new, pressure, "Pa", (byte)3, (short)0);
        SystemUnit<Angle> rad = Units.add(Angle.class, Scalar.Angle::new, dimensionless, "rad", (byte)3, (short)9101);
        SystemUnit<Dimensionless> one = Units.add(Dimensionless.class, Scalar.Dimensionless::new, dimensionless, "", (byte)2, (short)9201);
        SystemUnit<Mass> kg2 = Units.add(Mass.class, Scalar.Mass::new, mass, "kg", (byte)2, (short)0);
        LinearConverter nano = Prefixes.converter('n');
        LinearConverter micro = Prefixes.converter('\u00b5');
        LinearConverter milli = Prefixes.converter('m');
        LinearConverter centi = Prefixes.converter('c');
        LinearConverter hecto = Prefixes.converter('h');
        LinearConverter kilo = Prefixes.converter('k');
        LinearConverter ten4 = LinearConverter.scale(10000.0, 1.0);
        rad.related(4);
        RADIAN = rad;
        GRAD = Units.add(rad, LinearConverter.scale(0.15707963267948966, 10.0), "grad", (byte)32, (short)9105);
        DEGREE = Units.add(rad, LinearConverter.scale(0.15707963267948966, 9.0), "\u00b0", (byte)4, (short)9102);
        ARC_MINUTE = Units.add(rad, LinearConverter.scale(0.15707963267948966, 540.0), "\u2032", (byte)4, (short)9103);
        ARC_SECOND = Units.add(rad, LinearConverter.scale(0.15707963267948966, 32400.0), "\u2033", (byte)4, (short)9104);
        MICRORADIAN = Units.add(rad, micro, "\u00b5rad", (byte)2, (short)9109);
        m4.related(7);
        METRE = m4;
        NANOMETRE = Units.add(m4, nano, "nm", (byte)2, (short)0);
        MILLIMETRE = Units.add(m4, milli, "mm", (byte)2, (short)1025);
        CENTIMETRE = Units.add(m4, centi, "cm", (byte)2, (short)1033);
        KILOMETRE = Units.add(m4, kilo, "km", (byte)2, (short)9036);
        NAUTICAL_MILE = Units.add(m4, LinearConverter.scale(1852.0, 1.0), "M", (byte)32, (short)9030);
        STATUTE_MILE = Units.add(m4, LinearConverter.scale(1609344.0, 1000.0), "mi", (byte)16, (short)9093);
        US_SURVEY_FOOT = Units.add(m4, LinearConverter.scale(1200.0, 3937.0), "ftUS", (byte)32, (short)9003);
        CLARKE_FOOT = Units.add(m4, LinearConverter.scale(3.047972654E9, 1.0E10), "ftCla", (byte)32, (short)9005);
        FOOT = Units.add(m4, LinearConverter.scale(3048.0, 10000.0), "ft", (byte)16, (short)9002);
        INCH = Units.add(m4, LinearConverter.scale(254.0, 10000.0), "in", (byte)16, (short)0);
        POINT = Units.add(m4, LinearConverter.scale(996264.0, 7.2E7), "pt", (byte)32, (short)0);
        s2.related(5);
        SECOND = s2;
        MILLISECOND = Units.add(s2, milli, "ms", (byte)2, (short)0);
        MINUTE = Units.add(s2, LinearConverter.scale(60.0, 1.0), "min", (byte)4, (short)0);
        HOUR = Units.add(s2, LinearConverter.scale(3600.0, 1.0), "h", (byte)4, (short)0);
        DAY = Units.add(s2, LinearConverter.scale(86400.0, 1.0), "d", (byte)4, (short)0);
        WEEK = Units.add(s2, LinearConverter.scale(604800.0, 1.0), "wk", (byte)32, (short)0);
        TROPICAL_YEAR = Units.add(s2, LinearConverter.scale(3.1556925445E10, 1000.0), "a", (byte)32, (short)1029);
        SystemUnit<ScaleRateOfChange> unityPerSecond = new SystemUnit<ScaleRateOfChange>(ScaleRateOfChange.class, frequency, null, 32, 1036, null);
        unityPerSecond.related(1);
        mps.related(1);
        mps2.related(1);
        METRES_PER_SECOND = mps;
        METRES_PER_SECOND_SQUARED = mps2;
        KILOMETRES_PER_HOUR = Units.add(mps, LinearConverter.scale(10.0, 36.0), "km\u2215h", (byte)4, (short)0);
        RADIANS_PER_SECOND = Units.add(AngularVelocity.class, null, frequency, "rad\u2215s", (byte)2, (short)1035);
        GAL = Units.add(mps2, centi, "Gal", (byte)13, (short)0);
        Units.add(unityPerSecond, LinearConverter.scale(1.0, 3.1556925445E16), "ppm\u2215a", (byte)32, (short)1030);
        Pa.related(3);
        PASCAL = Pa;
        HECTOPASCAL = Units.add(Pa, hecto, "hPa", (byte)2, (short)0);
        DECIBAR = Units.add(Pa, ten4, "dbar", (byte)32, (short)0);
        BAR = Units.add(Pa, LinearConverter.scale(100000.0, 1.0), "bar", (byte)32, (short)0);
        ATMOSPHERE = Units.add(Pa, LinearConverter.scale(101325.0, 1.0), "atm", (byte)32, (short)0);
        K2.related(2);
        KELVIN = K2;
        CELSIUS = Units.add(K2, LinearConverter.offset(27315.0, 100.0), "\u00b0C", (byte)2, (short)0);
        FAHRENHEIT = Units.add(K2, new LinearConverter(100.0, 45967.0, 180.0), "\u00b0F", (byte)32, (short)0);
        SQUARE_METRE = m22;
        CUBIC_METRE = m32;
        KILOGRAM = kg2;
        HECTARE = Units.add(m22, ten4, "ha", (byte)4, (short)0);
        LITRE = Units.add(m32, milli, "L", (byte)5, (short)0);
        GRAM = Units.add(kg2, milli, "g", (byte)5, (short)0);
        HERTZ = Units.add(Frequency.class, Scalar.Frequency::new, frequency, "Hz", (byte)3, (short)0);
        NEWTON = Units.add(Force.class, Scalar.Force::new, force, "N", (byte)3, (short)0);
        JOULE = Units.add(Energy.class, Scalar.Energy::new, energy, "J", (byte)3, (short)0);
        WATT = Units.add(Power.class, Scalar.Power::new, power, "W", (byte)3, (short)0);
        AMPERE = Units.add(ElectricCurrent.class, null, current, "A", (byte)3, (short)0);
        COULOMB = Units.add(ElectricCharge.class, null, charge, "C", (byte)3, (short)0);
        VOLT = Units.add(ElectricPotential.class, null, potential, "V", (byte)3, (short)0);
        FARAD = Units.add(ElectricCapacitance.class, null, charge.divide(potential), "F", (byte)3, (short)0);
        SIEMENS = Units.add(ElectricConductance.class, null, current.divide(potential), "S", (byte)3, (short)0);
        OHM = Units.add(ElectricResistance.class, null, potential.divide(current), "\u03a9", (byte)3, (short)0);
        WEBER = Units.add(MagneticFlux.class, null, magneticFlux, "Wb", (byte)3, (short)0);
        TESLA = Units.add(MagneticFluxDensity.class, null, magneticFlux.divide(area), "T", (byte)3, (short)0);
        HENRY = Units.add(ElectricInductance.class, null, magneticFlux.divide(current), "H", (byte)3, (short)0);
        LUX = Units.add(Illuminance.class, null, luminous.divide(area), "lx", (byte)3, (short)0);
        LUMEN = Units.add(LuminousFlux.class, null, luminous, "lm", (byte)3, (short)0);
        CANDELA = Units.add(LuminousIntensity.class, null, luminous, "cd", (byte)3, (short)0);
        MOLE = Units.add(AmountOfSubstance.class, null, amount, "mol", (byte)3, (short)0);
        STERADIAN = Units.add(SolidAngle.class, null, dimensionless, "sr", (byte)3, (short)0);
        SIGMA = Units.add(Dimensionless.class, Scalar.Dimensionless::new, dimensionless, "sigma", (byte)32, (short)0);
        PIXEL = Units.add(Dimensionless.class, Scalar.Dimensionless::new, dimensionless, "px", (byte)32, (short)0);
        SystemUnit<Salinity> sal = Units.add(Salinity.class, null, dimensionless, null, (byte)32, (short)0);
        PSU = Units.add(sal, milli, "psu", (byte)32, (short)0);
        PERCENT = Units.add(one, centi, "%", (byte)32, (short)0);
        PPM = Units.add(one, micro, "ppm", (byte)32, (short)9202);
        ConventionalUnit<Dimensionless> bel = Units.add(one, PowerOf10.belToOne(), "B", (byte)5, (short)0);
        DECIBEL = Units.add(bel, Prefixes.converter('d'), "dB", (byte)4, (short)0);
        UNITY = UnitRegistry.init(one);
        UnitRegistry.alias(UNITY, Short.valueOf((short)9203));
        UnitRegistry.alias(DEGREE, Short.valueOf((short)9122));
        UnitRegistry.alias(ARC_MINUTE, "'");
        UnitRegistry.alias(ARC_SECOND, "\"");
        UnitRegistry.alias(KELVIN, "K");
        UnitRegistry.alias(CELSIUS, "\u2103");
        UnitRegistry.alias(CELSIUS, "Cel");
        UnitRegistry.alias(FAHRENHEIT, "\u2109");
        UnitRegistry.alias(GRAD, "gon");
        UnitRegistry.alias(GAL, "cm\u2215s\u00b2");
        UnitRegistry.alias(HECTARE, "hm\u00b2");
        UnitRegistry.alias(LITRE, "l");
        UnitRegistry.alias(LITRE, "\u2113");
        UnitRegistry.alias(PSU, "PSU");
        UnitRegistry.alias(UNITY, "1");
        initialized = true;
    }
}

