/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.TreeNodeChildren;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

class TreeNode
implements TreeTable.Node {
    private static final Collection<TreeTable.Node> LEAF = Set.of();
    final TreeTableView table;
    private final TreeNode parent;
    final Object metadata;
    final Class<?> baseType;
    private transient CharSequence name;
    private transient Collection<TreeTable.Node> children;
    transient Object cachedValue;

    TreeNode(TreeTableView table, Object metadata, Class<?> baseType) {
        this.table = table;
        this.parent = null;
        this.metadata = metadata;
        this.baseType = baseType;
    }

    private TreeNode(TreeNode parent, Object metadata, Class<?> baseType) {
        this.table = parent.table;
        this.parent = parent;
        this.metadata = metadata;
        this.baseType = baseType;
        if (!this.isMetadata(baseType)) {
            this.children = LEAF;
        }
    }

    final boolean isMetadata(Class<?> type) {
        return this.table.standard.isMetadata(type);
    }

    private CacheKey key() {
        return new CacheKey(this.metadata.getClass(), this.baseType);
    }

    String getIdentifier() {
        Class type = this.table.standard.getInterface(this.key());
        String id = Types.getStandardName(type);
        return id != null ? id : Classes.getShortName(type);
    }

    Integer getIndex() {
        return null;
    }

    CharSequence getName() {
        return CharSequences.camelCaseToSentence(Classes.getShortName(this.table.standard.getInterface(this.key()))).toString();
    }

    CharSequence getRemarks() {
        return null;
    }

    void appendIdentifier(StringBuilder buffer) {
        buffer.append(Classes.getShortClassName(this.metadata));
    }

    @Override
    public Object getUserObject() {
        return this.metadata;
    }

    void setUserObject(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.unmodifiableCellValue(TableColumn.VALUE));
    }

    boolean isWritable() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((TreeNode)other).metadata == this.metadata && ((TreeNode)other).baseType == this.baseType;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.metadata) ^ Objects.hashCode(this.baseType);
    }

    @Override
    public final TreeTable.Node getParent() {
        return this.parent;
    }

    @Override
    public final boolean isLeaf() {
        return this.children == LEAF;
    }

    @Override
    public final Collection<TreeTable.Node> getChildren() {
        if (!this.isLeaf()) {
            Object value = this.cachedValue;
            if (value == null && (value = this.getUserObject()) == null) {
                this.children = null;
                return LEAF;
            }
            this.cachedValue = null;
            if (this.children == null || ((TreeNodeChildren)this.children).metadata != value) {
                PropertyAccessor accessor = this.table.standard.getAccessor(new CacheKey(value.getClass(), this.baseType), true);
                this.children = new TreeNodeChildren(this, value, accessor);
            }
        }
        return this.children;
    }

    @Override
    public final TreeTable.Node newChild() throws UnsupportedOperationException {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException(Errors.format((short)99, this));
        }
        return new NewChild();
    }

    private TreeNodeChildren getCompactChildren() {
        Collection<TreeTable.Node> children;
        if (this.table.valuePolicy == ValueExistencePolicy.COMPACT && (children = this.getChildren()) instanceof TreeNodeChildren) {
            return (TreeNodeChildren)children;
        }
        return null;
    }

    @Override
    public final <V> V getValue(TableColumn<V> column) {
        Object value = null;
        ArgumentChecks.ensureNonNull("column", column);
        if (column == TableColumn.IDENTIFIER) {
            value = this.getIdentifier();
        } else if (column == TableColumn.INDEX) {
            value = this.getIndex();
        } else if (column == TableColumn.NAME) {
            if (this.name == null) {
                this.name = this.getName();
            }
            value = this.name;
        } else if (column == TableColumn.TYPE) {
            TreeNodeChildren children = this.getCompactChildren();
            if (children == null || (value = children.getParentType()) == null) {
                value = this.baseType;
            }
        } else if (column == TableColumn.VALUE) {
            if (this.isLeaf()) {
                value = this.cachedValue;
                this.cachedValue = null;
                if (value == null) {
                    value = this.getUserObject();
                }
            } else {
                TreeNodeChildren children = this.getCompactChildren();
                if (children != null) {
                    value = children.getParentTitle();
                }
            }
        } else if (column == TableColumn.REMARKS) {
            value = this.getRemarks();
        }
        return column.getElementType().cast(value);
    }

    @Override
    public final <V> void setValue(TableColumn<V> column, V value) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull("column", column);
        if (column == TableColumn.VALUE) {
            ArgumentChecks.ensureNonNull("value", value);
            this.cachedValue = null;
            TreeNodeChildren children = this.getCompactChildren();
            if (children == null || !children.setParentTitle(value)) {
                this.setUserObject(value);
            }
        } else {
            if (TreeTableView.COLUMNS.contains(column)) {
                throw new UnsupportedOperationException(this.unmodifiableCellValue(column));
            }
            throw new IllegalArgumentException(Errors.format((short)45, "column", column));
        }
    }

    private String unmodifiableCellValue(TableColumn<?> column) {
        return Errors.format((short)151, this.getValue(TableColumn.NAME), column.getHeader());
    }

    @Override
    public final boolean isEditable(TableColumn<?> column) {
        ArgumentChecks.ensureNonNull("column", column);
        return column == TableColumn.VALUE && this.isWritable();
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder(60);
        this.appendStringTo(buffer);
        return buffer.toString();
    }

    final void appendStringTo(StringBuilder buffer) {
        this.appendIdentifier(buffer.append("Node["));
        buffer.append(" : ").append(Classes.getShortName(this.baseType)).append(']');
    }

    private final class NewChild
    implements TreeTable.Node {
        private int indexInData = -1;
        private TreeNode delegate;

        private NewChild() {
        }

        private TreeNode delegate() throws IllegalStateException {
            if (this.delegate != null) {
                return this.delegate;
            }
            throw new IllegalStateException(Errors.format((short)90, (this.indexInData < 0 ? TableColumn.IDENTIFIER : TableColumn.VALUE).getHeader()));
        }

        private TreeNodeChildren getSiblings() {
            return (TreeNodeChildren)TreeNode.this.getChildren();
        }

        @Override
        public <V> void setValue(TableColumn<V> column, V value) {
            if (this.delegate == null) {
                if (column == TableColumn.IDENTIFIER) {
                    ArgumentChecks.ensureNonNull("value", value);
                    this.indexInData = this.getSiblings().accessor.indexOf((String)value, true);
                    return;
                }
                if (column == TableColumn.VALUE) {
                    ArgumentChecks.ensureNonNull("value", value);
                    if (this.indexInData < 0) {
                        throw new IllegalStateException(Errors.format((short)90, TableColumn.IDENTIFIER.getHeader()));
                    }
                    TreeNodeChildren siblings = this.getSiblings();
                    int indexInList = siblings.isCollectionOrMap(this.indexInData) ? CollectionsExt.size(siblings.valueAt(this.indexInData)) : -1;
                    if (!siblings.add(this.indexInData, value)) {
                        throw new IllegalArgumentException(Errors.format((short)27, value));
                    }
                    this.delegate = siblings.childAt(this.indexInData, indexInList);
                    return;
                }
            }
            this.delegate().setValue(column, value);
        }

        @Override
        public TreeTable.Node getParent() {
            return TreeNode.this;
        }

        @Override
        public boolean isLeaf() {
            return this.delegate().isLeaf();
        }

        @Override
        public Collection<TreeTable.Node> getChildren() {
            return this.delegate().getChildren();
        }

        @Override
        public TreeTable.Node newChild() {
            return this.delegate().newChild();
        }

        @Override
        public <V> V getValue(TableColumn<V> column) {
            return this.delegate().getValue(column);
        }

        @Override
        public boolean isEditable(TableColumn<?> column) {
            return this.delegate().isEditable(column);
        }

        @Override
        public Object getUserObject() {
            return this.delegate().getUserObject();
        }
    }

    static final class CollectionElement
    extends Element {
        final int indexInList;

        CollectionElement(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData, int indexInList) {
            super(parent, metadata, accessor, indexInData);
            this.indexInList = indexInList;
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('[').append(this.indexInList).append(']');
        }

        @Override
        Integer getIndex() {
            return this.indexInList;
        }

        @Override
        CharSequence getName() {
            CharSequence name = super.getName();
            int size = CollectionsExt.size(super.getUserObject());
            if (size >= 2) {
                name = Vocabulary.formatInternational((short)148, name, this.indexInList + 1, size);
            }
            return name;
        }

        @Override
        public Object getUserObject() {
            Object collection = super.getUserObject();
            Set values = collection instanceof Collection ? (Set)collection : ((Map)collection).entrySet();
            if (this.indexInList == 0 && this.table.valuePolicy.substituteByNullElement(values)) {
                return null;
            }
            try {
                if (values instanceof List) {
                    return ((List)((Object)values)).get(this.indexInList);
                }
                Iterator it = values.iterator();
                for (int i = 0; i < this.indexInList; ++i) {
                    it.next();
                }
                return it.next();
            }
            catch (IndexOutOfBoundsException | NullPointerException | NoSuchElementException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        void setUserObject(Object value) {
            Collection values = (Collection)super.getUserObject();
            if (!(values instanceof List)) {
                throw new UnsupportedOperationException(Errors.format((short)162, "setValue"));
            }
            Class targetType = values instanceof CheckedContainer ? ((CheckedContainer)((Object)values)).getElementType() : this.baseType;
            value = ObjectConverters.convert(value, targetType);
            try {
                ((List)values).set(this.indexInList, value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((CollectionElement)other).indexInList == this.indexInList;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.indexInList;
        }
    }

    static class Element
    extends TreeNode {
        private final PropertyAccessor accessor;
        private final int indexInData;
        final Function<TreeNode, TreeTable.Node> decorator;

        Element(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData) {
            super(parent, metadata, accessor.type(indexInData, TypeValuePolicy.ELEMENT_TYPE));
            this.accessor = accessor;
            this.indexInData = indexInData;
            this.decorator = SpecialCases.isLocaleAndCharset(accessor, indexInData) ? LocaleAndCharset::new : null;
        }

        @Override
        final String getIdentifier() {
            return this.accessor.name(this.indexInData, KeyNamePolicy.UML_IDENTIFIER);
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('.').append(this.accessor.name(this.indexInData, KeyNamePolicy.JAVABEANS_PROPERTY));
        }

        @Override
        CharSequence getName() {
            Class<?> type;
            Object value;
            String identifier = this.getIdentifier();
            if (identifier.equalsIgnoreCase(Classes.getShortName(this.baseType)) && (value = this.getUserObject()) != null && (type = this.standardSubType(Classes.getLeafInterfaces(value.getClass(), this.baseType))) != null && type != Void.TYPE) {
                identifier = Classes.getShortName(type);
            }
            identifier = SpecialCases.rename(identifier);
            return CharSequences.camelCaseToSentence(identifier).toString();
        }

        private Class<?> standardSubType(Class<?>[] subtypes) {
            Class<?> type = null;
            for (Class<?> c : subtypes) {
                if (!this.baseType.isAssignableFrom(c)) continue;
                if (!this.isMetadata(c)) {
                    c = this.standardSubType(c.getInterfaces());
                }
                if (type == null) {
                    type = c;
                    continue;
                }
                if (type == c) continue;
                return Void.TYPE;
            }
            return type;
        }

        @Override
        final CharSequence getRemarks() {
            return this.accessor.remarks(this.indexInData, this.metadata);
        }

        @Override
        public Object getUserObject() {
            return this.accessor.get(this.indexInData, this.metadata);
        }

        @Override
        void setUserObject(Object value) {
            this.accessor.set(this.indexInData, this.metadata, value, 0);
        }

        @Override
        final boolean isWritable() {
            return this.accessor.isWritable(this.indexInData);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((Element)other).indexInData == this.indexInData;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 31 * this.indexInData;
        }
    }
}

