/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.Individual;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Individual_Type", propOrder={"positionName"})
@XmlRootElement(name="CI_Individual")
public class DefaultIndividual
extends AbstractParty
implements Individual {
    private static final long serialVersionUID = -5116802681895278739L;
    private InternationalString positionName;

    public DefaultIndividual() {
    }

    public DefaultIndividual(CharSequence name, CharSequence positionName, Contact contactInfo) {
        super(name, contactInfo);
        this.positionName = Types.toInternationalString(positionName);
    }

    public DefaultIndividual(Individual object) {
        super(object);
        if (object != null) {
            this.positionName = object.getPositionName();
        }
    }

    public static DefaultIndividual castOrCopy(Individual object) {
        if (object == null || object instanceof DefaultIndividual) {
            return (DefaultIndividual)object;
        }
        return new DefaultIndividual(object);
    }

    @Override
    @XmlElement(name="positionName")
    public InternationalString getPositionName() {
        return this.positionName;
    }

    public void setPositionName(InternationalString newValue) {
        this.checkWritePermission(this.positionName);
        this.positionName = newValue;
    }
}

