/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.MD_Releasability;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.constraint.DefaultSecurityConstraints;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Releasability;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Constraints_Type", propOrder={"useLimitations", "constraintApplicationScope", "graphic", "reference", "releasability", "responsibleParty"})
@XmlRootElement(name="MD_Constraints")
@XmlSeeAlso(value={DefaultLegalConstraints.class, DefaultSecurityConstraints.class})
public class DefaultConstraints
extends ISOMetadata
implements Constraints {
    private static final long serialVersionUID = -5622398793237824161L;
    private Collection<InternationalString> useLimitations;
    private Scope constraintApplicationScope;
    private Collection<BrowseGraphic> graphics;
    private Collection<Citation> references;
    private Releasability releasability;
    private Collection<Responsibility> responsibleParties;

    public DefaultConstraints() {
    }

    public DefaultConstraints(CharSequence useLimitation) {
        this.useLimitations = this.singleton(Types.toInternationalString(useLimitation), InternationalString.class);
    }

    public DefaultConstraints(Constraints object) {
        super(object);
        if (object != null) {
            this.useLimitations = this.copyCollection(object.getUseLimitations(), InternationalString.class);
            this.constraintApplicationScope = object.getConstraintApplicationScope();
            this.graphics = this.copyCollection(object.getGraphics(), BrowseGraphic.class);
            this.references = this.copyCollection(object.getReferences(), Citation.class);
            this.releasability = object.getReleasability();
            this.responsibleParties = this.copyCollection(object.getResponsibleParties(), Responsibility.class);
        }
    }

    public static DefaultConstraints castOrCopy(Constraints object) {
        if (object instanceof LegalConstraints) {
            return DefaultLegalConstraints.castOrCopy((LegalConstraints)object);
        }
        if (object instanceof SecurityConstraints) {
            return DefaultSecurityConstraints.castOrCopy((SecurityConstraints)object);
        }
        if (object == null || object instanceof DefaultConstraints) {
            return (DefaultConstraints)object;
        }
        return new DefaultConstraints(object);
    }

    @XmlElement(name="useLimitation")
    public Collection<InternationalString> getUseLimitations() {
        this.useLimitations = this.nonNullCollection(this.useLimitations, InternationalString.class);
        return this.useLimitations;
    }

    public void setUseLimitations(Collection<? extends InternationalString> newValues) {
        this.useLimitations = this.writeCollection(newValues, this.useLimitations, InternationalString.class);
    }

    @Override
    @XmlElement(name="constraintApplicationScope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    public Scope getConstraintApplicationScope() {
        return this.constraintApplicationScope;
    }

    public void setConstraintApplicationScope(Scope newValue) {
        this.checkWritePermission(this.constraintApplicationScope);
        this.constraintApplicationScope = newValue;
    }

    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> newValues) {
        this.graphics = this.writeCollection(newValues, this.graphics, BrowseGraphic.class);
    }

    public Collection<Citation> getReferences() {
        this.references = this.nonNullCollection(this.references, Citation.class);
        return this.references;
    }

    public void setReferences(Collection<? extends Citation> newValues) {
        this.references = this.writeCollection(newValues, this.references, Citation.class);
    }

    @Override
    @XmlElement(name="releasability")
    @XmlJavaTypeAdapter(value=MD_Releasability.Since2014.class)
    public Releasability getReleasability() {
        return this.releasability;
    }

    public void setReleasability(Releasability newValue) {
        this.checkWritePermission(this.releasability);
        this.releasability = newValue;
    }

    public Collection<Responsibility> getResponsibleParties() {
        this.responsibleParties = this.nonNullCollection(this.responsibleParties, Responsibility.class);
        return this.responsibleParties;
    }

    public void setResponsibleParties(Collection<? extends Responsibility> newValues) {
        this.responsibleParties = this.writeCollection(newValues, this.responsibleParties, Responsibility.class);
    }

    @XmlElement(name="graphic")
    private Collection<BrowseGraphic> getGraphic() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getGraphics() : null;
    }

    @XmlElement(name="reference")
    private Collection<Citation> getReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getReferences() : null;
    }

    @XmlElement(name="responsibleParty")
    private Collection<Responsibility> getResponsibleParty() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResponsibleParties() : null;
    }
}

