/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gmi.MI_CoverageDescription;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.AttributeGroup;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@XmlType(name="MD_CoverageDescription_Type", propOrder={"attributeDescription", "processingLevelCode", "attributeGroup", "contentType", "dimensions", "rangeElementDescriptions"})
@XmlRootElement(name="MD_CoverageDescription")
@XmlSeeAlso(value={DefaultImageDescription.class, MI_CoverageDescription.class})
public class DefaultCoverageDescription
extends AbstractContentInformation
implements CoverageDescription {
    private static final long serialVersionUID = 2161065580202989466L;
    private RecordType attributeDescription;
    private Identifier processingLevelCode;
    private Collection<AttributeGroup> attributeGroups;
    private Collection<RangeElementDescription> rangeElementDescriptions;

    public DefaultCoverageDescription() {
    }

    public DefaultCoverageDescription(CoverageDescription object) {
        super(object);
        if (object != null) {
            this.attributeDescription = object.getAttributeDescription();
            this.processingLevelCode = object.getProcessingLevelCode();
            this.attributeGroups = this.copyCollection(object.getAttributeGroups(), AttributeGroup.class);
            this.rangeElementDescriptions = this.copyCollection(object.getRangeElementDescriptions(), RangeElementDescription.class);
        }
    }

    public static DefaultCoverageDescription castOrCopy(CoverageDescription object) {
        if (object instanceof ImageDescription) {
            return DefaultImageDescription.castOrCopy((ImageDescription)object);
        }
        if (object == null || object instanceof DefaultCoverageDescription) {
            return (DefaultCoverageDescription)object;
        }
        return new DefaultCoverageDescription(object);
    }

    @Override
    @XmlElement(name="attributeDescription", required=true)
    public RecordType getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(RecordType newValue) {
        this.checkWritePermission(this.attributeDescription);
        this.attributeDescription = newValue;
    }

    @Override
    @XmlElement(name="processingLevelCode")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    public Identifier getProcessingLevelCode() {
        return this.processingLevelCode;
    }

    public void setProcessingLevelCode(Identifier newValue) {
        this.checkWritePermission(this.processingLevelCode);
        this.processingLevelCode = newValue;
    }

    public Collection<AttributeGroup> getAttributeGroups() {
        this.attributeGroups = this.nonNullCollection(this.attributeGroups, AttributeGroup.class);
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<? extends AttributeGroup> newValues) {
        this.attributeGroups = this.writeCollection(newValues, this.attributeGroups, AttributeGroup.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="contentType", namespace="http://www.isotc211.org/2005/gmd")
    public CoverageContentType getContentType() {
        Collection<AttributeGroup> groups;
        CoverageContentType type = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (groups = this.getAttributeGroups()) != null) {
            block0: for (AttributeGroup g2 : groups) {
                Collection<CoverageContentType> contentTypes = g2.getContentTypes();
                if (contentTypes == null) continue;
                for (CoverageContentType t2 : contentTypes) {
                    if (type == null) {
                        type = t2;
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(CoverageContentType.class, DefaultCoverageDescription.class, "getContentType");
                    continue block0;
                }
            }
        }
        return type;
    }

    @Deprecated(since="1.0")
    public void setContentType(CoverageContentType newValue) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.attributeGroups));
        Set<CoverageContentType> newValues = CollectionsExt.singletonOrEmpty(newValue);
        Collection<AttributeGroup> groups = this.attributeGroups;
        if (groups != null) {
            for (AttributeGroup group : groups) {
                if (!(group instanceof DefaultAttributeGroup)) continue;
                ((DefaultAttributeGroup)group).setContentTypes(newValues);
                return;
            }
        }
        DefaultAttributeGroup group = new DefaultAttributeGroup();
        group.setContentTypes(newValues);
        if (groups != null) {
            groups.add(group);
        } else {
            groups = Collections.singleton(group);
        }
        this.setAttributeGroups(groups);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="dimension", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<RangeDimension> getDimensions() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<RangeDimension, AttributeGroup>(this.getAttributeGroups()){

            @Override
            protected AttributeGroup wrap(RangeDimension value) {
                DefaultAttributeGroup container = new DefaultAttributeGroup();
                container.setAttributes(CollectionsExt.singletonOrEmpty(value));
                return container;
            }

            @Override
            protected RangeDimension unwrap(AttributeGroup container) {
                return 1.getSingleton(container.getAttributes(), RangeDimension.class, this, DefaultCoverageDescription.class, "getDimensions");
            }

            @Override
            protected boolean update(AttributeGroup container, RangeDimension value) {
                if (container instanceof DefaultAttributeGroup) {
                    ((DefaultAttributeGroup)container).setAttributes(CollectionsExt.singletonOrEmpty(value));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setDimensions(Collection<? extends RangeDimension> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.attributeGroups));
        ((LegacyPropertyAdapter)this.getDimensions()).setValues(newValues);
    }

    @XmlElement(name="rangeElementDescription")
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> newValues) {
        this.rangeElementDescriptions = this.writeCollection(newValues, this.rangeElementDescriptions, RangeElementDescription.class);
    }

    @XmlElement(name="attributeGroup")
    private Collection<AttributeGroup> getAttributeGroup() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAttributeGroups() : null;
    }
}

