/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.gco.GO_Integer;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.gco.GO_Record;
import org.apache.sis.internal.jaxb.gco.GO_RecordType;
import org.apache.sis.internal.jaxb.metadata.MI_RangeElementDescription;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultRangeDimension;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.content.SampleDimension;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_SampleDimension_Type", propOrder={"maxValue", "minValue", "units", "scaleFactor", "offset", "meanValue", "numberOfValues", "standardDeviation", "otherPropertyType", "otherProperty", "bitsPerValue", "rangeElementDescriptions"})
@XmlRootElement(name="MD_SampleDimension")
@XmlSeeAlso(value={DefaultBand.class, DefaultRangeDimension.class})
public class DefaultSampleDimension
extends DefaultRangeDimension
implements SampleDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private Integer numberOfValues;
    private Double minValue;
    private Double maxValue;
    private Double meanValue;
    private Double standardDeviation;
    private Unit<?> units;
    private Double scaleFactor;
    private Double offset;
    private TransferFunctionType transferFunctionType;
    private Integer bitsPerValue;
    private Collection<RangeElementDescription> rangeElementDescriptions;
    private Double nominalSpatialResolution;
    private RecordType otherPropertyType;
    private Record otherProperty;

    public DefaultSampleDimension() {
    }

    public DefaultSampleDimension(SampleDimension object) {
        super(object);
        if (object != null) {
            this.minValue = object.getMinValue();
            this.maxValue = object.getMaxValue();
            this.meanValue = object.getMeanValue();
            this.numberOfValues = object.getNumberOfValues();
            this.standardDeviation = object.getStandardDeviation();
            this.units = object.getUnits();
            this.scaleFactor = object.getScaleFactor();
            this.offset = object.getOffset();
            this.transferFunctionType = object.getTransferFunctionType();
            this.bitsPerValue = object.getBitsPerValue();
            this.nominalSpatialResolution = object.getNominalSpatialResolution();
            this.otherPropertyType = object.getOtherPropertyType();
            this.otherProperty = object.getOtherProperty();
        }
    }

    public static DefaultSampleDimension castOrCopy(SampleDimension object) {
        if (object instanceof Band) {
            return DefaultBand.castOrCopy((Band)object);
        }
        if (object == null || object instanceof DefaultSampleDimension) {
            return (DefaultSampleDimension)object;
        }
        return new DefaultSampleDimension(object);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="numberOfValues")
    @XmlJavaTypeAdapter(value=GO_Integer.Since2014.class)
    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    public void setNumberOfValues(Integer newValue) {
        this.checkWritePermission(this.numberOfValues);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "numberOfValues", false, newValue)) {
            this.numberOfValues = newValue;
        }
    }

    @Override
    @XmlElement(name="minValue")
    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double newValue) {
        this.checkWritePermission(this.minValue);
        this.minValue = newValue;
    }

    @Override
    @XmlElement(name="maxValue")
    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double newValue) {
        this.checkWritePermission(this.maxValue);
        this.maxValue = newValue;
    }

    @Override
    @XmlElement(name="meanValue")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    public Double getMeanValue() {
        return this.meanValue;
    }

    public void setMeanValue(Double newValue) {
        this.checkWritePermission(this.meanValue);
        this.meanValue = newValue;
    }

    @Override
    @XmlElement(name="standardDeviation")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(Double newValue) {
        this.checkWritePermission(this.standardDeviation);
        this.standardDeviation = newValue;
    }

    @Override
    @XmlElement(name="units")
    public Unit<?> getUnits() {
        return this.units;
    }

    public void setUnits(Unit<?> newValue) {
        this.checkWritePermission(this.units);
        this.units = newValue;
    }

    @Override
    @XmlElement(name="scaleFactor")
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double newValue) {
        this.checkWritePermission(this.scaleFactor);
        this.scaleFactor = newValue;
    }

    @Override
    @XmlElement(name="offset")
    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double newValue) {
        this.checkWritePermission(this.offset);
        this.offset = newValue;
    }

    @Override
    public TransferFunctionType getTransferFunctionType() {
        return this.transferFunctionType;
    }

    public void setTransferFunctionType(TransferFunctionType newValue) {
        this.checkWritePermission(this.transferFunctionType);
        this.transferFunctionType = newValue;
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="bitsPerValue")
    public Integer getBitsPerValue() {
        return this.bitsPerValue;
    }

    public void setBitsPerValue(Integer newValue) {
        this.checkWritePermission(this.bitsPerValue);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "bitsPerValue", true, newValue)) {
            this.bitsPerValue = newValue;
        }
    }

    @XmlElement(name="rangeElementDescription")
    @XmlJavaTypeAdapter(value=MI_RangeElementDescription.Since2014.class)
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> newValues) {
        this.rangeElementDescriptions = this.writeCollection(newValues, this.rangeElementDescriptions, RangeElementDescription.class);
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getNominalSpatialResolution() {
        return this.nominalSpatialResolution;
    }

    public void setNominalSpatialResolution(Double newValue) {
        this.checkWritePermission(this.nominalSpatialResolution);
        if (ImplementationHelper.ensurePositive(DefaultSampleDimension.class, "nominalSpatialResolution", true, newValue)) {
            this.nominalSpatialResolution = newValue;
        }
    }

    @Override
    @XmlElement(name="otherPropertyType")
    @XmlJavaTypeAdapter(value=GO_RecordType.Since2014.class)
    public RecordType getOtherPropertyType() {
        return this.otherPropertyType;
    }

    public void setOtherPropertyType(RecordType newValue) {
        this.checkWritePermission(this.otherPropertyType);
        this.otherPropertyType = newValue;
    }

    @Override
    @XmlElement(name="otherProperty")
    @XmlJavaTypeAdapter(value=GO_Record.Since2014.class)
    public Record getOtherProperty() {
        return this.otherProperty;
    }

    public void setOtherProperty(Record newValue) {
        this.checkWritePermission(this.otherProperty);
        this.otherProperty = newValue;
    }
}

