/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gts.TM_PeriodDuration;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DigitalTransferOptions_Type", propOrder={"unitsOfDistribution", "distributionFormat", "transferSize", "transferFrequency", "onLines", "offLines"})
@XmlRootElement(name="MD_DigitalTransferOptions")
public class DefaultDigitalTransferOptions
extends ISOMetadata
implements DigitalTransferOptions {
    private static final long serialVersionUID = -2901375920581273330L;
    private InternationalString unitsOfDistribution;
    private Double transferSize;
    private Collection<OnlineResource> onLines;
    private Collection<Medium> offLines;
    private PeriodDuration transferFrequency;
    private Collection<Format> distributionFormats;

    public DefaultDigitalTransferOptions() {
    }

    public DefaultDigitalTransferOptions(DigitalTransferOptions object) {
        super(object);
        if (object != null) {
            this.unitsOfDistribution = object.getUnitsOfDistribution();
            this.transferSize = object.getTransferSize();
            this.onLines = this.copyCollection(object.getOnLines(), OnlineResource.class);
            this.offLines = this.copyCollection(object.getOffLines(), Medium.class);
            this.transferFrequency = object.getTransferFrequency();
            this.distributionFormats = this.copyCollection(object.getDistributionFormats(), Format.class);
        }
    }

    public static DefaultDigitalTransferOptions castOrCopy(DigitalTransferOptions object) {
        if (object == null || object instanceof DefaultDigitalTransferOptions) {
            return (DefaultDigitalTransferOptions)object;
        }
        return new DefaultDigitalTransferOptions(object);
    }

    @Override
    @XmlElement(name="unitsOfDistribution")
    public InternationalString getUnitsOfDistribution() {
        return this.unitsOfDistribution;
    }

    public void setUnitsOfDistribution(InternationalString newValue) {
        this.checkWritePermission(this.unitsOfDistribution);
        this.unitsOfDistribution = newValue;
    }

    @Override
    @XmlElement(name="transferSize")
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getTransferSize() {
        return this.transferSize;
    }

    public void setTransferSize(Double newValue) {
        this.checkWritePermission(this.transferSize);
        if (ImplementationHelper.ensurePositive(DefaultDigitalTransferOptions.class, "transferSize", true, newValue)) {
            this.transferSize = newValue;
        }
    }

    @XmlElement(name="onLine")
    public Collection<OnlineResource> getOnLines() {
        this.onLines = this.nonNullCollection(this.onLines, OnlineResource.class);
        return this.onLines;
    }

    public void setOnLines(Collection<? extends OnlineResource> newValues) {
        this.onLines = this.writeCollection(newValues, this.onLines, OnlineResource.class);
    }

    @XmlElement(name="offLine")
    public Collection<Medium> getOffLines() {
        this.offLines = this.nonNullCollection(this.offLines, Medium.class);
        Collection<Medium> c = this.offLines;
        if (c != null && c.size() > 1 && FilterByVersion.LEGACY_METADATA.accept()) {
            c = CollectionsExt.singletonOrEmpty(LegacyPropertyAdapter.getSingleton(c, Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLines"));
        }
        return c;
    }

    public void setOffLines(Collection<? extends Medium> newValues) {
        this.offLines = this.writeCollection(newValues, this.offLines, Medium.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getOffLines"})
    public Medium getOffLine() {
        return LegacyPropertyAdapter.getSingleton(this.getOffLines(), Medium.class, null, DefaultDigitalTransferOptions.class, "getOffLine");
    }

    @Deprecated(since="1.0")
    public void setOffLine(Medium newValue) {
        this.setOffLines(CollectionsExt.singletonOrEmpty(newValue));
    }

    @Override
    @XmlElement(name="transferFrequency")
    @XmlJavaTypeAdapter(value=TM_PeriodDuration.Since2014.class)
    public PeriodDuration getTransferFrequency() {
        return this.transferFrequency;
    }

    public void setTransferFrequency(PeriodDuration newValue) {
        this.checkWritePermission(this.transferFrequency);
        this.transferFrequency = newValue;
    }

    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> newValues) {
        this.distributionFormats = this.writeCollection(newValues, this.distributionFormats, Format.class);
    }

    @XmlElement(name="distributionFormat")
    private Collection<Format> getDistributionFormat() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDistributionFormats() : null;
    }
}

