/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.temporal.TemporalPrimitive;

@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends ISOMetadata
implements TemporalExtent {
    private static final long serialVersionUID = -6149873501105795242L;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent object) {
        super(object);
        if (object != null) {
            this.extent = object.getExtent();
        }
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent object) {
        if (object instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)object);
        }
        if (object == null || object instanceof DefaultTemporalExtent) {
            return (DefaultTemporalExtent)object;
        }
        return new DefaultTemporalExtent(object);
    }

    @Override
    @XmlElement(name="extent", required=true)
    public TemporalPrimitive getExtent() {
        return this.extent;
    }

    public void setExtent(TemporalPrimitive newValue) {
        this.checkWritePermission(this.extent);
        this.extent = newValue;
    }

    static Date getTime(TemporalPrimitive extent, boolean begin) {
        Instant instant;
        if (extent instanceof Instant) {
            instant = (Instant)extent;
        } else if (extent instanceof Period) {
            instant = begin ? ((Period)extent).getBeginning() : ((Period)extent).getEnding();
        } else {
            return null;
        }
        return instant.getDate();
    }

    public Date getStartTime() {
        return DefaultTemporalExtent.getTime(this.extent, true);
    }

    public Date getEndTime() {
        return DefaultTemporalExtent.getTime(this.extent, false);
    }

    public void setBounds(Date startTime, Date endTime) throws UnsupportedOperationException {
        TemporalGeometricPrimitive value = null;
        if (startTime != null || endTime != null) {
            value = endTime == null || endTime.equals(startTime) ? TemporalUtilities.createInstant(startTime) : (startTime == null ? TemporalUtilities.createInstant(endTime) : TemporalUtilities.createPeriod(startTime, endTime));
        }
        this.setExtent(value);
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(this.extent);
        ReferencingServices.getInstance().setBounds(envelope, this);
    }

    public void intersect(TemporalExtent other) {
        this.checkWritePermission(this.extent);
        TemporalPrimitive ot = other.getExtent();
        if (ot != null && !(this.extent instanceof NilObject)) {
            if (this.extent == null || ot instanceof NilObject) {
                this.extent = ot;
            } else {
                Date t0 = DefaultTemporalExtent.getTime(this.extent, true);
                Date t1 = DefaultTemporalExtent.getTime(this.extent, false);
                Date h0 = DefaultTemporalExtent.getTime(ot, true);
                Date h1 = DefaultTemporalExtent.getTime(ot, false);
                boolean changed = false;
                if (h0 != null && (t0 == null || h0.after(t0))) {
                    t0 = h0;
                    changed = true;
                }
                if (h1 != null && (t1 == null || h1.before(t1))) {
                    t1 = h1;
                    changed = true;
                }
                if (changed) {
                    if (t0 != null && t1 != null && t0.after(t1)) {
                        this.extent = NilReason.MISSING.createNilObject(TemporalPrimitive.class);
                    } else {
                        this.setBounds(t0, t1);
                    }
                }
            }
        }
    }
}

