/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;

@XmlType(name="MD_Scope_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0", propOrder={"level", "extents", "levelDescription"})
@XmlRootElement(name="MD_Scope", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
public class DefaultScope
extends ISOMetadata
implements Scope {
    private static final long serialVersionUID = -979575548481874359L;
    private ScopeCode level;
    private Collection<Extent> extents;
    private Collection<ScopeDescription> levelDescription;

    public DefaultScope() {
    }

    public DefaultScope(ScopeCode level) {
        this.level = level;
    }

    public DefaultScope(Scope object) {
        super(object);
        if (object != null) {
            this.level = object.getLevel();
            this.extents = this.copyCollection(object.getExtents(), Extent.class);
            this.levelDescription = this.copyCollection(object.getLevelDescription(), ScopeDescription.class);
        }
    }

    public static DefaultScope castOrCopy(Scope object) {
        if (object == null || object instanceof DefaultScope) {
            return (DefaultScope)object;
        }
        return new DefaultScope(object);
    }

    @Override
    @XmlElement(name="level", required=true)
    public ScopeCode getLevel() {
        return this.level;
    }

    public void setLevel(ScopeCode newValue) {
        this.checkWritePermission(this.level);
        this.level = newValue;
    }

    @XmlElement(name="extent")
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    @XmlElement(name="levelDescription")
    public Collection<ScopeDescription> getLevelDescription() {
        this.levelDescription = this.nonNullCollection(this.levelDescription, ScopeDescription.class);
        return this.levelDescription;
    }

    public void setLevelDescription(Collection<? extends ScopeDescription> newValues) {
        this.levelDescription = this.writeCollection(newValues, this.levelDescription, ScopeDescription.class);
    }
}

