/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.StandaloneQualityReportInformation;

@XmlType(name="DQ_DataQuality_Type", propOrder={"scope", "reports", "standaloneQualityReport", "lineage"})
@XmlRootElement(name="DQ_DataQuality")
public class DefaultDataQuality
extends ISOMetadata
implements DataQuality {
    private static final long serialVersionUID = 5036527927404894540L;
    private Scope scope;
    private Collection<Element> reports;
    @Deprecated(since="1.3")
    private Lineage lineage;
    private StandaloneQualityReportInformation standaloneQualityReport;

    public DefaultDataQuality() {
    }

    public DefaultDataQuality(ScopeCode level) {
        if (level != null) {
            this.scope = new DefaultScope(level);
        }
    }

    public DefaultDataQuality(Scope scope) {
        this.scope = scope;
    }

    public DefaultDataQuality(DataQuality object) {
        super(object);
        if (object != null) {
            this.scope = object.getScope();
            this.reports = this.copyCollection(object.getReports(), Element.class);
            this.standaloneQualityReport = object.getStandaloneQualityReport();
            this.lineage = object.getLineage();
        }
    }

    public static DefaultDataQuality castOrCopy(DataQuality object) {
        if (object == null || object instanceof DefaultDataQuality) {
            return (DefaultDataQuality)object;
        }
        return new DefaultDataQuality(object);
    }

    @Override
    @XmlElement(name="scope", required=true)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission(this.scope);
        this.scope = newValue;
    }

    @XmlElement(name="report", required=true)
    public Collection<Element> getReports() {
        this.reports = this.nonNullCollection(this.reports, Element.class);
        return this.reports;
    }

    public void setReports(Collection<? extends Element> newValues) {
        this.reports = this.writeCollection(newValues, this.reports, Element.class);
    }

    @Override
    @XmlElement(name="standaloneQualityReport")
    public StandaloneQualityReportInformation getStandaloneQualityReport() {
        return this.standaloneQualityReport;
    }

    public void setStandaloneQualityReport(StandaloneQualityReportInformation newValue) {
        this.checkWritePermission(this.standaloneQualityReport);
        this.standaloneQualityReport = newValue;
    }

    @Override
    @Deprecated(since="1.3")
    @XmlElement(name="lineage", namespace="http://www.isotc211.org/2005/gmd")
    public Lineage getLineage() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.lineage : null;
    }

    @Deprecated(since="1.3")
    public void setLineage(Lineage newValue) {
        this.checkWritePermission(this.lineage);
        this.lineage = newValue;
    }
}

