/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.BasicMeasure;
import org.opengis.metadata.quality.Description;
import org.opengis.metadata.quality.Measure;
import org.opengis.metadata.quality.SourceReference;
import org.opengis.metadata.quality.ValueStructure;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@XmlType(name="DQM_Measure_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"measureIdentifier", "name", "aliases", "elementNames", "definition", "description", "valueType", "valueStructure", "examples", "basicMeasure", "sourceReferences", "parameters"})
@XmlRootElement(name="DQM_Measure", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
public class DefaultQualityMeasure
extends ISOMetadata
implements Measure {
    private static final long serialVersionUID = -2004468907779670827L;
    private Identifier measureIdentifier;
    private InternationalString name;
    private Collection<InternationalString> aliases;
    private Collection<TypeName> elementNames;
    private BasicMeasure basicMeasure;
    private InternationalString definition;
    private Description description;
    private Collection<SourceReference> sourceReferences;
    private TypeName valueType;
    private ValueStructure valueStructure;
    private Collection<ParameterDescriptor<?>> parameters;
    private Collection<Description> examples;

    public DefaultQualityMeasure() {
    }

    public DefaultQualityMeasure(Measure object) {
        super(object);
        if (object != null) {
            this.measureIdentifier = object.getMeasureIdentifier();
            this.name = object.getName();
            this.aliases = this.copyCollection(object.getAliases(), InternationalString.class);
            this.elementNames = this.copyCollection(object.getElementNames(), TypeName.class);
            this.definition = object.getDefinition();
            this.description = object.getDescription();
            this.valueType = object.getValueType();
            this.valueStructure = object.getValueStructure();
            this.examples = this.copyCollection(object.getExamples(), Description.class);
            this.basicMeasure = object.getBasicMeasure();
            this.sourceReferences = this.copyCollection(object.getSourceReferences(), SourceReference.class);
            this.parameters = this.copyCollection(object.getParameters(), ParameterDescriptor.class);
        }
    }

    public static DefaultQualityMeasure castOrCopy(Measure object) {
        if (object instanceof DefaultQualityMeasure) {
            return (DefaultQualityMeasure)object;
        }
        return new DefaultQualityMeasure(object);
    }

    @Override
    @XmlElement(name="measureIdentifier", required=true)
    public Identifier getMeasureIdentifier() {
        return this.measureIdentifier;
    }

    public void setMeasureIdentifier(Identifier newValue) {
        this.checkWritePermission(this.measureIdentifier);
        this.measureIdentifier = newValue;
    }

    @Override
    @XmlElement(name="name", required=true)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="alias")
    public Collection<InternationalString> getAliases() {
        this.aliases = this.nonNullCollection(this.aliases, InternationalString.class);
        return this.aliases;
    }

    public void setAliases(Collection<? extends InternationalString> newValues) {
        this.aliases = this.writeCollection(newValues, this.aliases, InternationalString.class);
    }

    @XmlElement(name="elementName", required=true)
    public Collection<TypeName> getElementNames() {
        this.elementNames = this.nonNullCollection(this.elementNames, TypeName.class);
        return this.elementNames;
    }

    public void setElementNames(Collection<? extends TypeName> newValues) {
        this.elementNames = this.writeCollection(newValues, this.elementNames, TypeName.class);
    }

    @Override
    @XmlElement(name="basicMeasure")
    public BasicMeasure getBasicMeasure() {
        return this.basicMeasure;
    }

    public void setBasicMeasure(BasicMeasure newValue) {
        this.checkWritePermission(this.basicMeasure);
        this.basicMeasure = newValue;
    }

    @Override
    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString newValue) {
        this.checkWritePermission(this.definition);
        this.definition = newValue;
    }

    @Override
    @XmlElement(name="description")
    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="sourceReference")
    public Collection<SourceReference> getSourceReferences() {
        this.sourceReferences = this.nonNullCollection(this.sourceReferences, SourceReference.class);
        return this.sourceReferences;
    }

    public void setSourceReferences(Collection<? extends SourceReference> newValues) {
        this.sourceReferences = this.writeCollection(newValues, this.sourceReferences, SourceReference.class);
    }

    @Override
    @XmlElement(name="valueType", required=true)
    public TypeName getValueType() {
        return this.valueType;
    }

    public void setValueType(TypeName newValue) {
        this.checkWritePermission(this.valueType);
        this.valueType = newValue;
    }

    @Override
    @XmlElement(name="valueStructure")
    public ValueStructure getValueStructure() {
        return this.valueStructure;
    }

    public void setValueStructure(ValueStructure newValue) {
        this.checkWritePermission(this.valueStructure);
        this.valueStructure = newValue;
    }

    @XmlElement(name="parameter")
    public Collection<ParameterDescriptor<?>> getParameters() {
        this.parameters = this.nonNullCollection(this.parameters, ParameterDescriptor.class);
        return this.parameters;
    }

    public void setParameters(Collection<? extends ParameterDescriptor<?>> newValues) {
        this.parameters = this.writeCollection(newValues, this.parameters, ParameterDescriptor.class);
    }

    @XmlElement(name="example")
    public Collection<Description> getExamples() {
        this.examples = this.nonNullCollection(this.examples, Description.class);
        return this.examples;
    }

    public void setExamples(Collection<? extends Description> newValues) {
        this.examples = this.writeCollection(newValues, this.examples, Description.class);
    }
}

