/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="DQ_QuantitativeResult_Type", propOrder={"values", "valueType", "valueUnit", "errorStatistic"})
@XmlRootElement(name="DQ_QuantitativeResult")
public class DefaultQuantitativeResult
extends AbstractResult
implements QuantitativeResult {
    private static final long serialVersionUID = -403671810118461829L;
    private List<Record> values;
    private RecordType valueType;
    private Unit<?> valueUnit;
    @Deprecated(since="1.3")
    private InternationalString errorStatistic;

    public DefaultQuantitativeResult() {
    }

    public DefaultQuantitativeResult(QuantitativeResult object) {
        super(object);
        if (object != null) {
            this.valueType = object.getValueType();
            this.valueUnit = object.getValueUnit();
            this.errorStatistic = object.getErrorStatistic();
            this.values = this.copyList(object.getValues(), Record.class);
        }
    }

    public static DefaultQuantitativeResult castOrCopy(QuantitativeResult object) {
        if (object == null || object instanceof DefaultQuantitativeResult) {
            return (DefaultQuantitativeResult)object;
        }
        return new DefaultQuantitativeResult(object);
    }

    @XmlElement(name="value", required=true)
    public List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public void setValues(List<? extends Record> newValues) {
        this.values = this.writeList(newValues, this.values, Record.class);
    }

    @Override
    @XmlElement(name="valueRecordType")
    public RecordType getValueType() {
        RecordType type = this.valueType;
        if (type == null && this.values != null) {
            for (Record value : this.values) {
                if (value == null) continue;
                RecordType t2 = value.getRecordType();
                if (t2 == null) {
                    return null;
                }
                if (type == null) {
                    type = t2;
                    continue;
                }
                if (type == t2) continue;
                return null;
            }
        }
        return type;
    }

    public void setValueType(RecordType newValue) {
        this.checkWritePermission(this.valueType);
        this.valueType = newValue;
    }

    @Override
    @XmlElement(name="valueUnit")
    public Unit<?> getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(Unit<?> newValue) {
        this.checkWritePermission(this.valueUnit);
        this.valueUnit = newValue;
    }

    @Override
    @Deprecated(since="1.3")
    @XmlElement(name="errorStatistic", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getErrorStatistic() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.errorStatistic : null;
    }

    @Deprecated(since="1.3")
    public void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission(this.errorStatistic);
        this.errorStatistic = newValue;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.errorStatistic == null;
    }
}

