/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

@XmlType(name="VerticalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="VerticalCRS")
public class DefaultVerticalCRS
extends AbstractCRS
implements VerticalCRS {
    private static final long serialVersionUID = 3565878468719941800L;
    private VerticalDatum datum;

    public DefaultVerticalCRS(Map<String, ?> properties, VerticalDatum datum, VerticalCS cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultVerticalCRS(VerticalCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
    }

    public static DefaultVerticalCRS castOrCopy(VerticalCRS object) {
        return object == null || object instanceof DefaultVerticalCRS ? (DefaultVerticalCRS)object : new DefaultVerticalCRS(object);
    }

    public Class<? extends VerticalCRS> getInterface() {
        return VerticalCRS.class;
    }

    @Override
    @XmlElement(name="verticalDatum", required=true)
    public VerticalDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="verticalCS", required=true)
    public VerticalCS getCoordinateSystem() {
        return (VerticalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultVerticalCRS forConvention(AxesConvention convention) {
        return (DefaultVerticalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultVerticalCRS(properties, this.datum, (VerticalCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Vert_CS" : (DefaultVerticalCRS.isBaseCRS(formatter) ? "BaseVertCRS" : formatter.shortOrLong("VertCRS", "VerticalCRS"));
    }

    private DefaultVerticalCRS() {
    }

    private void setDatum(VerticalDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalCRS.class, "setDatum", "verticalDatum");
        }
    }

    private void setCoordinateSystem(VerticalCS cs) {
        this.setCoordinateSystem("verticalCS", cs);
    }
}

