/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

@XmlType(name="VerticalCSType")
@XmlRootElement(name="VerticalCS")
public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;

    DefaultVerticalCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        super(properties, axes);
    }

    public DefaultVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, axis);
    }

    protected DefaultVerticalCS(VerticalCS cs) {
        super(cs);
    }

    public static DefaultVerticalCS castOrCopy(VerticalCS object) {
        return object == null || object instanceof DefaultVerticalCS ? (DefaultVerticalCS)object : new DefaultVerticalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirection.UP.equals(AxisDirections.absolute(direction))) {
            return 1;
        }
        if ((unit = unit.getSystemUnit()).equals(Units.METRE) || unit.equals(Units.PASCAL) || unit.equals(Units.SECOND) || unit.equals(Units.UNITY)) {
            return 0;
        }
        return 2;
    }

    public Class<? extends VerticalCS> getInterface() {
        return VerticalCS.class;
    }

    @Override
    public DefaultVerticalCS forConvention(AxesConvention convention) {
        return (DefaultVerticalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return new DefaultVerticalCS(properties, axes);
            }
        }
        throw DefaultVerticalCS.unexpectedDimension(properties, axes, 1);
    }

    private DefaultVerticalCS() {
    }
}

