/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.CoordinateOperation;

final class CoordinateOperationSorter
implements Comparable<CoordinateOperationSorter> {
    private final CoordinateOperation operation;
    private final double area;
    private final double accuracy;

    private CoordinateOperationSorter(CoordinateOperation operation, GeographicBoundingBox areaOfInterest) {
        this.operation = operation;
        this.area = -Extents.area(Extents.intersection(areaOfInterest, Extents.getGeographicBoundingBox(operation.getDomainOfValidity())));
        this.accuracy = CRS.getLinearAccuracy(operation);
    }

    @Override
    public int compareTo(CoordinateOperationSorter other) {
        int c = Double.compare(this.area, other.area);
        if (c == 0) {
            c = Double.compare(this.accuracy, other.accuracy);
        }
        return c;
    }

    static void sort(List<CoordinateOperation> operations, GeographicBoundingBox areaOfInterest) {
        if (operations.size() > 1) {
            int i;
            Object[] s2 = new CoordinateOperationSorter[operations.size()];
            for (i = 0; i < s2.length; ++i) {
                s2[i] = new CoordinateOperationSorter(operations.get(i), areaOfInterest);
            }
            Arrays.sort(s2);
            operations.clear();
            for (i = 0; i < s2.length; ++i) {
                operations.add(((CoordinateOperationSorter)s2[i]).operation);
            }
        }
    }
}

