/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class AuthalicConversion
extends NormalizedProjection {
    private static final long serialVersionUID = 5880625564193782957L;
    private static final double ECCENTRICITY_THRESHOLD = 0.1;
    private final double c2\u03b2;
    private final double c4\u03b2;
    private final double c6\u03b2;
    final double qmPolar;
    final boolean isSpherical;
    private final boolean useIterations;

    AuthalicConversion(Initializer initializer, NormalizedProjection other) {
        super(initializer, other);
        this.isSpherical = this.eccentricitySquared == 0.0;
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        this.c2\u03b2 = Math.fma(e2, 0.6666666666666666, Math.fma(e4, 0.6, e6 * 0.5714285714285714));
        this.c4\u03b2 = Math.fma(e4, -0.5111111111111111, e6 * -1.0680776014109348);
        this.c6\u03b2 = e6 * 0.5368606701940035;
        this.qmPolar = this.qm(1.0);
        this.useIterations = this.eccentricity >= 0.1;
    }

    AuthalicConversion(AuthalicConversion other) {
        super(null, other);
        this.c2\u03b2 = other.c2\u03b2;
        this.c4\u03b2 = other.c4\u03b2;
        this.c6\u03b2 = other.c6\u03b2;
        this.qmPolar = other.qmPolar;
        this.isSpherical = other.isSpherical;
        this.useIterations = other.useIterations;
    }

    final double qm(double sin\u03c6) {
        if (this.isSpherical) {
            return 2.0 * sin\u03c6;
        }
        double \u212fsin\u03c6 = this.eccentricity * sin\u03c6;
        return sin\u03c6 / (1.0 - \u212fsin\u03c6 * \u212fsin\u03c6) + MathFunctions.atanh(\u212fsin\u03c6) / this.eccentricity;
    }

    final double dqm_d\u03c6(double sin\u03c6, double cos\u03c6) {
        double t2 = 1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6);
        return 2.0 * cos\u03c6 / (t2 * t2);
    }

    final double sin\u03b2(double sin\u03c6) {
        if (this.isSpherical) {
            return sin\u03c6;
        }
        return ((sin\u03c6 *= this.eccentricity) / (1.0 - sin\u03c6 * sin\u03c6) + MathFunctions.atanh(sin\u03c6)) / (this.eccentricity * this.qmPolar);
    }

    final double \u03c6(double sin\u03b2) throws ProjectionException {
        double as;
        double sin\u03b22 = sin\u03b2 * sin\u03b2;
        double \u03b2 = Math.asin(sin\u03b2);
        double \u03c6 = Math.fma(Math.fma(Math.fma(sin\u03b22, this.c6\u03b2, this.c4\u03b2), sin\u03b22, this.c2\u03b2), Math.cos(\u03b2) * sin\u03b2, \u03b2);
        if (this.useIterations) {
            double y = this.qmPolar * sin\u03b2;
            for (int i = 0; i < 18; ++i) {
                double sin\u03c6 = Math.sin(\u03c6);
                double cos\u03c6 = Math.cos(\u03c6);
                double \u212fsin\u03c6 = this.eccentricity * sin\u03c6;
                double ome = 1.0 - \u212fsin\u03c6 * \u212fsin\u03c6;
                double \u0394\u03c6 = ome * ome / (2.0 * cos\u03c6) * (y - sin\u03c6 / ome - MathFunctions.atanh(\u212fsin\u03c6) / this.eccentricity);
                \u03c6 += \u0394\u03c6;
                if (!(Math.abs(\u0394\u03c6) <= 3.926676682852614E-10)) continue;
                return \u03c6;
            }
        } else if (!Double.isNaN(\u03c6)) {
            return \u03c6;
        }
        if (Math.abs((as = Math.abs(sin\u03b2)) - 1.0) < 1.5706706731410455E-9) {
            double y = this.qmPolar * sin\u03b2;
            return Math.copySign(1.5707963267948966, y);
        }
        if (!(as < 1.0)) {
            return Double.NaN;
        }
        throw new ProjectionException(Resources.format((short)46));
    }
}

