/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class CassiniSoldner
extends MeridianArcBased {
    private static final long serialVersionUID = 616536461409425434L;
    private static final double VANUA_LATITUDE = -0.28361600344907856;
    private final Variant variant;
    private final double M0;

    public CassiniSoldner(OperationMethod method, Parameters parameters) {
        this(CassiniSoldner.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)CassiniSoldner.variant((OperationMethod)method, (ProjectionVariant[])new Variant[]{Variant.HYPERBOLIC}, (ProjectionVariant)Variant.DEFAULT);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.CassiniSoldner.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.CassiniSoldner.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.CassiniSoldner.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.CassiniSoldner.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, variant);
    }

    CassiniSoldner(Initializer initializer) {
        super(initializer);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.CassiniSoldner.LATITUDE_OF_ORIGIN));
        this.M0 = this.distance(\u03c60, Math.sin(\u03c60), Math.cos(\u03c60));
        if (initializer.variant == Variant.DEFAULT) {
            MatrixSIS denormalize = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            denormalize.convertBefore(1, null, -this.distance(\u03c60, Math.sin(\u03c60), Math.cos(\u03c60)));
            this.variant = null;
        } else {
            this.variant = Math.abs(\u03c60 - -0.28361600344907856) <= 1.5706706731410455E-9 ? Variant.VANUA : (Variant)initializer.variant;
        }
    }

    CassiniSoldner(CassiniSoldner other) {
        super(other);
        this.variant = other.variant;
        this.M0 = other.M0;
    }

    @Override
    final String[] getInternalParameterNames() {
        if (this.variant != null) {
            return new String[]{"M\u2080"};
        }
        return super.getInternalParameterNames();
    }

    @Override
    final double[] getInternalParameterValues() {
        if (this.variant != null) {
            return new double[]{this.M0};
        }
        return super.getInternalParameterValues();
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        CassiniSoldner kernel = this;
        if (this.eccentricity == 0.0 && this.variant == null && this.getClass() == CassiniSoldner.class) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03c62 = sin\u03c6 * sin\u03c6;
        double cos\u03c62 = cos\u03c6 * cos\u03c6;
        double tan\u03c6 = sin\u03c6 / cos\u03c6;
        double T = tan\u03c6 * tan\u03c6;
        double A2 = \u03bb * cos\u03c6;
        double A22 = A2 * A2;
        double A3 = A22 * A2;
        double r\u03bd2 = 1.0 - sin\u03c62 * this.eccentricitySquared;
        double C2 = cos\u03c62 * this.eccentricitySquared / (1.0 - this.eccentricitySquared);
        double Q = T - 8.0 * (C2 + 1.0);
        double S = ((5.0 - T) / 6.0 + C2) * A22;
        double r\u03bd = Math.sqrt(r\u03bd2);
        if (dstPts != null) {
            dstPts[dstOff] = (A2 - T * A3 / 6.0 + Q * T * (A3 * A22) / 120.0) / r\u03bd;
            dstPts[dstOff + 1] = this.distance(\u03c6, sin\u03c6, cos\u03c6) + tan\u03c6 * A22 * (0.5 + S / 4.0) / r\u03bd;
            if (this.variant != null) {
                double X2 = dstPts[dstOff + 1] - this.M0;
                dstPts[dstOff + 1] = X2 - X2 * X2 * X2 / (6.0 * (1.0 - this.eccentricitySquared) / (r\u03bd2 * r\u03bd2));
            }
        }
        if (!derivate) {
            return null;
        }
        if (this.variant != null) {
            throw new ProjectionException(Resources.format((short)2));
        }
        double \u03bb2 = \u03bb * \u03bb;
        double B = \u03bb * sin\u03c6;
        double B2 = B * B;
        double D = cos\u03c62 * this.eccentricitySquared / r\u03bd2;
        double V = A22 * Q / 60.0 - 0.3333333333333333;
        double W = B2 * (Q * A22 / 24.0 - 0.5);
        return new Matrix2(cos\u03c6 / r\u03bd * (W + 1.0), B * (\u03bb2 * V - W + B2 * (\u03bb2 + 8.0 * C2 * A22) / 60.0 + (D * (B2 * V / 2.0 + 1.0) - 1.0) / r\u03bd), B * cos\u03c6 / r\u03bd * (S + 1.0), B2 / r\u03bd * ((S / 4.0 + 0.5) * (D + 1.0 / sin\u03c62) - (S + 1.0 + A22 * C2 / 2.0 + \u03bb2 / 12.0)) + this.dM_d\u03c6(sin\u03c62));
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        if (this.variant != null) {
            if (this.variant != Variant.VANUA) {
                throw new ProjectionException(Errors.format((short)170, "\u03c6\u2080\u226016\u00b015\u2032S"));
            }
            double sin\u03c6 = Math.sin(-0.28361600344907856 + y * 1.0055298331853355);
            double r\u03bd2 = 1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6);
            double \u03c1\u03bd = 6.0 * (1.0 - this.eccentricitySquared) / (r\u03bd2 * r\u03bd2);
            double q = y + y * y * y / \u03c1\u03bd;
            y += q * q * q / \u03c1\u03bd + this.M0;
        }
        double \u03c61 = this.latitude(y);
        double sin\u03c61 = Math.sin(\u03c61);
        double cos\u03c61 = Math.cos(\u03c61);
        double tan\u03c61 = sin\u03c61 / cos\u03c61;
        double r\u03bd2 = 1.0 - this.eccentricitySquared * (sin\u03c61 * sin\u03c61);
        double \u03c11_\u03bd1 = (1.0 - this.eccentricitySquared) / r\u03bd2;
        double D = x * Math.sqrt(r\u03bd2);
        double D2 = D * D;
        double D4 = D2 * D2;
        double T1 = tan\u03c61 * tan\u03c61;
        dstPts[dstOff] = (D - T1 * (D2 * D) / 3.0 + (1.0 + 3.0 * T1) * T1 * (D4 * D) / 15.0) / cos\u03c61;
        dstPts[dstOff + 1] = \u03c61 - tan\u03c61 / \u03c11_\u03bd1 * (D2 / 2.0 - (1.0 + 3.0 * T1) * D4 / 24.0);
    }

    private static enum Variant implements ProjectionVariant
    {
        DEFAULT(null, "9806"),
        HYPERBOLIC(Pattern.compile(".*\\bHyperbolic\\b.*", 2), "9833"),
        VANUA(Variant.HYPERBOLIC.operationName, "9833");

        private final Pattern operationName;
        private final String identifier;

        private Variant(Pattern operationName, String identifier) {
            this.operationName = operationName;
            this.identifier = identifier;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends CassiniSoldner {
        private static final long serialVersionUID = -8131887916538379858L;

        protected Spherical(CassiniSoldner other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double tan\u03c6 = sin\u03c6 / cos\u03c6;
            if (dstPts != null) {
                dstPts[dstOff] = Math.asin(cos\u03c6 * sin\u03bb);
                dstPts[dstOff + 1] = Math.atan2(tan\u03c6, cos\u03bb);
            }
            if (!derivate) {
                return null;
            }
            double cos\u03c62 = cos\u03c6 * cos\u03c6;
            double sin\u03bb2 = sin\u03bb * sin\u03bb;
            double dxden = Math.sqrt(1.0 - sin\u03bb2 * cos\u03c62);
            double dyden = tan\u03c6 * tan\u03c6 + cos\u03bb * cos\u03bb;
            return new Matrix2(cos\u03bb * cos\u03c6 / dxden, -sin\u03bb * sin\u03c6 / dxden, sin\u03bb * tan\u03c6 / dyden, cos\u03bb / cos\u03c62 / dyden);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = Math.atan2(Math.tan(x), Math.cos(y));
            dstPts[dstOff + 1] = Math.asin(Math.sin(y) * Math.cos(x));
        }
    }
}

