/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.MathTransformsOrFactory;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform2D;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -910726602881388979L;
    final int firstAffectedCoordinate;
    final int numTrailingCoordinates;
    final MathTransform subTransform;
    PassThroughTransform inverse;

    protected PassThroughTransform(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        ArgumentChecks.ensurePositive("firstAffectedCoordinate", firstAffectedCoordinate);
        ArgumentChecks.ensurePositive("numTrailingCoordinates", numTrailingCoordinates);
        if (subTransform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)subTransform;
            this.firstAffectedCoordinate = passThrough.firstAffectedCoordinate + firstAffectedCoordinate;
            this.numTrailingCoordinates = passThrough.numTrailingCoordinates + numTrailingCoordinates;
            this.subTransform = passThrough.subTransform;
        } else {
            this.firstAffectedCoordinate = firstAffectedCoordinate;
            this.numTrailingCoordinates = numTrailingCoordinates;
            this.subTransform = subTransform;
        }
    }

    static MathTransform create(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        Matrix matrix = MathTransforms.getMatrix(subTransform);
        if (matrix != null) {
            return PassThroughTransform.newInstance(firstAffectedCoordinate, matrix, numTrailingCoordinates);
        }
        if (subTransform instanceof ConcatenatedTransform) {
            MathTransform transform1 = ((ConcatenatedTransform)subTransform).transform1;
            MathTransform transform2 = ((ConcatenatedTransform)subTransform).transform2;
            matrix = MathTransforms.getMatrix(transform1);
            if (matrix != null && transform2 instanceof PassThroughTransform) {
                transform1 = PassThroughTransform.newInstance(firstAffectedCoordinate, matrix, numTrailingCoordinates);
                transform2 = PassThroughTransform.newInstance(firstAffectedCoordinate, transform2, numTrailingCoordinates);
                return MathTransforms.concatenate(transform1, transform2);
            }
            matrix = MathTransforms.getMatrix(transform2);
            if (matrix != null && transform1 instanceof PassThroughTransform) {
                transform1 = PassThroughTransform.newInstance(firstAffectedCoordinate, transform1, numTrailingCoordinates);
                transform2 = PassThroughTransform.newInstance(firstAffectedCoordinate, matrix, numTrailingCoordinates);
                return MathTransforms.concatenate(transform1, transform2);
            }
        }
        return PassThroughTransform.newInstance(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    private static LinearTransform newInstance(int firstAffectedCoordinate, Matrix subTransform, int numTrailingCoordinates) {
        return MathTransforms.linear(PassThroughTransform.expand(MatrixSIS.castOrCopy(subTransform), firstAffectedCoordinate, numTrailingCoordinates, 1));
    }

    private static PassThroughTransform newInstance(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        int dim = subTransform.getSourceDimensions();
        if (subTransform.getTargetDimensions() == dim && (dim += firstAffectedCoordinate + numTrailingCoordinates) == 2) {
            return new PassThroughTransform2D(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
        }
        return new PassThroughTransform(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    public static MathTransform create(BitSet modifiedCoordinates, MathTransform subTransform, int resultDim, MathTransformFactory factory) throws FactoryException {
        int lower;
        ArgumentChecks.ensurePositive("resultDim", resultDim);
        int subDim = subTransform.getSourceDimensions();
        int actual = modifiedCoordinates.cardinality();
        if (actual != subDim) {
            throw new MismatchedDimensionException(Errors.format((short)81, "modifiedCoordinates", subDim, actual));
        }
        TransformSeparator sep = new TransformSeparator(subTransform, factory);
        MathTransform result = MathTransforms.identity(resultDim);
        int upper = 0;
        int subLower = 0;
        while ((lower = modifiedCoordinates.nextSetBit(upper)) >= 0) {
            MathTransform step;
            upper = modifiedCoordinates.nextClearBit(lower);
            int subUpper = subLower + (upper - lower);
            if (subLower == 0 && subUpper == subDim) {
                step = subTransform;
            } else {
                ArgumentChecks.ensureDimensionsMatch("subTransform", subDim, subDim, subTransform);
                sep.addSourceDimensionRange(subLower, subUpper);
                sep.addTargetDimensionRange(subLower, subUpper);
                step = sep.separate();
            }
            step = sep.factory.passThrough(lower, step, resultDim - upper);
            result = sep.factory.concatenate(result, step);
            sep.clear();
            subLower = subUpper;
        }
        return result;
    }

    @Override
    public final int getSourceDimensions() {
        return this.firstAffectedCoordinate + this.subTransform.getSourceDimensions() + this.numTrailingCoordinates;
    }

    @Override
    public final int getTargetDimensions() {
        return this.firstAffectedCoordinate + this.subTransform.getTargetDimensions() + this.numTrailingCoordinates;
    }

    public final int[] getModifiedCoordinates() {
        return ArraysExt.range(this.firstAffectedCoordinate, this.firstAffectedCoordinate + this.subTransform.getSourceDimensions());
    }

    public final MathTransform getSubTransform() {
        return this.subTransform;
    }

    @Override
    public boolean isIdentity() {
        return this.subTransform.isIdentity();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix derivative = null;
        if (derivate) {
            derivative = this.derivative(new DirectPositionView.Double(srcPts, srcOff, this.getSourceDimensions()));
        }
        if (dstPts != null) {
            this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }

    private static Object newArray(Object array, int length) {
        return Array.newInstance(array.getClass().getComponentType(), length);
    }

    private void transformOverlapping(Object srcPts, int srcOff, Object dstPts, int dstOff, int numPts) throws TransformException {
        if (numPts <= 0) {
            return;
        }
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        int numPassThrough = this.firstAffectedCoordinate + this.numTrailingCoordinates;
        int dimSource = subDimSource + numPassThrough;
        int dimTarget = subDimTarget + numPassThrough;
        Object pasPts = PassThroughTransform.newArray(srcPts, numPassThrough * numPts);
        System.arraycopy(srcPts, srcOff, pasPts, 0, this.firstAffectedCoordinate);
        int pasOff = this.firstAffectedCoordinate;
        int srcCpk = srcOff + pasOff + subDimSource;
        int n = numPts - 1;
        while (--n >= 0) {
            System.arraycopy(srcPts, srcCpk, pasPts, pasOff, numPassThrough);
            pasOff += numPassThrough;
            srcCpk += dimSource;
        }
        System.arraycopy(srcPts, srcCpk, pasPts, pasOff, this.numTrailingCoordinates);
        Object subPts = dstPts;
        int subOff = dstOff;
        int srcCpk2 = srcOff + this.firstAffectedCoordinate;
        int srcInc = dimSource;
        int dstInc = subDimSource;
        IterationStrategy strategy = subDimSource > subDimTarget + numPassThrough ? IterationStrategy.BUFFER_TARGET : (srcPts != dstPts ? IterationStrategy.ASCENDING : IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts));
        switch (strategy) {
            case ASCENDING: {
                break;
            }
            case DESCENDING: {
                srcCpk2 += (numPts - 1) * srcInc;
                srcInc = -srcInc;
                subOff += (numPts - 1) * dstInc;
                dstInc = -dstInc;
                break;
            }
            default: {
                subPts = PassThroughTransform.newArray(subPts, Math.max(subDimSource, subDimTarget) * numPts);
                subOff = 0;
            }
        }
        int n2 = numPts;
        do {
            System.arraycopy(srcPts, srcCpk2, subPts, subOff, subDimSource);
            subOff += dstInc;
            srcCpk2 += srcInc;
        } while (--n2 != 0);
        int n3 = subOff = subPts == dstPts ? dstOff : 0;
        if (subPts instanceof double[]) {
            this.subTransform.transform((double[])subPts, subOff, (double[])subPts, subOff, numPts);
        } else {
            this.subTransform.transform((float[])subPts, subOff, (float[])subPts, subOff, numPts);
        }
        int pasOff2 = numPts * numPassThrough;
        subOff += numPts * subDimTarget;
        dstOff += numPts * dimTarget;
        if (--numPts >= 0) {
            System.arraycopy(pasPts, pasOff2 -= this.numTrailingCoordinates, dstPts, dstOff -= this.numTrailingCoordinates, this.numTrailingCoordinates);
            System.arraycopy(subPts, subOff -= subDimTarget, dstPts, dstOff -= subDimTarget, subDimTarget);
            while (--numPts >= 0) {
                System.arraycopy(pasPts, pasOff2 -= numPassThrough, dstPts, dstOff -= numPassThrough, numPassThrough);
                System.arraycopy(subPts, subOff -= subDimTarget, dstPts, dstOff -= subDimTarget, subDimTarget);
            }
            System.arraycopy(pasPts, pasOff2 - this.firstAffectedCoordinate, dstPts, dstOff - this.firstAffectedCoordinate, this.firstAffectedCoordinate);
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transformOverlapping(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transformOverlapping(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        while (--numPts >= 0) {
            int i;
            for (i = 0; i < this.firstAffectedCoordinate; ++i) {
                dstPts[dstOff++] = (float)srcPts[srcOff++];
            }
            this.subTransform.transform(srcPts, srcOff, dstPts, dstOff, 1);
            srcOff += subDimSource;
            dstOff += subDimTarget;
            for (i = 0; i < this.numTrailingCoordinates; ++i) {
                dstPts[dstOff++] = (float)srcPts[srcOff++];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        while (--numPts >= 0) {
            int i;
            for (i = 0; i < this.firstAffectedCoordinate; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++];
            }
            this.subTransform.transform(srcPts, srcOff, dstPts, dstOff, 1);
            srcOff += subDimSource;
            dstOff += subDimTarget;
            for (i = 0; i < this.numTrailingCoordinates; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        int nSkipped = this.firstAffectedCoordinate + this.numTrailingCoordinates;
        int transDim = this.subTransform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("point", transDim + nSkipped, point);
        GeneralDirectPosition subPoint = new GeneralDirectPosition(transDim);
        for (int i = 0; i < transDim; ++i) {
            subPoint.coordinates[i] = point.getOrdinate(i + this.firstAffectedCoordinate);
        }
        return PassThroughTransform.expand(MatrixSIS.castOrCopy(this.subTransform.derivative(subPoint)), this.firstAffectedCoordinate, this.numTrailingCoordinates, 0);
    }

    private static Matrix expand(MatrixSIS subMatrix, int firstAffectedCoordinate, int numTrailingCoordinates, int affine) {
        int j;
        int j2;
        int nSkipped = firstAffectedCoordinate + numTrailingCoordinates;
        int numSubRow = subMatrix.getNumRow() - affine;
        int numSubCol = subMatrix.getNumCol() - affine;
        int numRow = numSubRow + (nSkipped + affine);
        int numCol = numSubCol + (nSkipped + affine);
        Object[] elements = new Number[numRow * numCol];
        Arrays.fill(elements, (Object)0);
        Integer ONE = 1;
        for (j2 = 0; j2 < firstAffectedCoordinate; ++j2) {
            elements[j2 * numCol + j2] = ONE;
        }
        for (j2 = 0; j2 < numSubRow; ++j2) {
            for (int i = 0; i < numSubCol; ++i) {
                elements[(j2 + firstAffectedCoordinate) * numCol + (i + firstAffectedCoordinate)] = subMatrix.getNumber(j2, i);
            }
        }
        int offset = numSubCol - numSubRow;
        int numRowOut = numSubRow + nSkipped;
        int numColOut = numSubCol + nSkipped;
        for (j = numRowOut - numTrailingCoordinates; j < numRowOut; ++j) {
            elements[j * numCol + (j + offset)] = ONE;
        }
        if (affine != 0) {
            for (j = 0; j < numSubRow; ++j) {
                elements[(j + firstAffectedCoordinate) * numCol + numColOut] = subMatrix.getNumber(j, numSubCol);
            }
            for (int i = 0; i < numSubCol; ++i) {
                elements[numRowOut * numCol + (i + firstAffectedCoordinate)] = subMatrix.getNumber(numSubRow, i);
            }
            elements[numRowOut * numCol + numColOut] = subMatrix.getNumber(numSubRow, numSubCol);
        }
        return Matrices.create(numRow, numCol, (Number[])elements);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedCoordinate, this.subTransform.inverse(), this.numTrailingCoordinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    private Matrix toSubMatrix(boolean applyOtherFirst, Matrix matrix) {
        int numCol;
        int numRow = matrix.getNumRow();
        if (numRow != (numCol = matrix.getNumCol())) {
            return null;
        }
        int subDim = applyOtherFirst ? this.subTransform.getSourceDimensions() : this.subTransform.getTargetDimensions();
        MatrixSIS sub = Matrices.createIdentity(subDim + 1);
        int j = numRow;
        while (--j >= 0) {
            int sj = j - this.firstAffectedCoordinate;
            int i = numCol;
            while (--i >= 0) {
                double element = matrix.getElement(j, i);
                if (sj >= 0 && sj < subDim) {
                    boolean copy;
                    int si;
                    if (i == numCol - 1) {
                        si = subDim;
                        copy = true;
                    } else {
                        si = i - this.firstAffectedCoordinate;
                        boolean bl = copy = si >= 0 && si < subDim;
                    }
                    if (copy) {
                        sub.setElement(sj, si, element);
                        continue;
                    }
                }
                if (element == (double)(i == j ? 1 : 0)) continue;
                return null;
            }
        }
        return sub;
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        Matrix m4;
        MathTransformsOrFactory proxy = MathTransformsOrFactory.wrap(factory);
        if (other instanceof PassThroughTransform) {
            PassThroughTransform opt = (PassThroughTransform)other;
            if (opt.firstAffectedCoordinate == this.firstAffectedCoordinate && opt.numTrailingCoordinates == this.numTrailingCoordinates) {
                MathTransform sub = proxy.concatenate(applyOtherFirst, this.subTransform, opt.subTransform);
                return proxy.passThrough(this.firstAffectedCoordinate, sub, this.numTrailingCoordinates);
            }
        }
        if ((m4 = MathTransforms.getMatrix(other)) != null) {
            int dimension;
            Matrix sub = this.toSubMatrix(applyOtherFirst, m4);
            if (sub != null) {
                MathTransform tr = proxy.linear(sub);
                tr = proxy.concatenate(applyOtherFirst, this.subTransform, tr);
                return proxy.passThrough(this.firstAffectedCoordinate, tr, this.numTrailingCoordinates);
            }
            if (!applyOtherFirst && (dimension = m4.getNumCol() - 1) <= 64) {
                boolean keepSubTransform;
                long retainedDimensions = 0L;
                int numRows = m4.getNumRow();
                block0: for (int i = 0; i < dimension; ++i) {
                    for (int j = 0; j < numRows; ++j) {
                        if (m4.getElement(j, i) == 0.0) continue;
                        retainedDimensions |= 1L << i;
                        continue block0;
                    }
                }
                long fullTransformMask = PassThroughTransform.maskLowBits(dimension);
                long subTransformMask = PassThroughTransform.maskLowBits(this.subTransform.getTargetDimensions()) << this.firstAffectedCoordinate;
                boolean bl = keepSubTransform = (retainedDimensions & subTransformMask) != 0L;
                if (keepSubTransform) {
                    retainedDimensions |= subTransformMask;
                }
                if (retainedDimensions != fullTransformMask) {
                    int dim;
                    int i;
                    int lower;
                    int upper;
                    int change = this.subTransform.getSourceDimensions() - this.subTransform.getTargetDimensions();
                    if (change == 0 && !keepSubTransform) {
                        return other;
                    }
                    MatrixSIS reduced = MatrixSIS.castOrCopy(m4);
                    long columnsToRemove = (retainedDimensions ^ 0xFFFFFFFFFFFFFFFFL) & fullTransformMask;
                    do {
                        lower = Long.numberOfTrailingZeros(columnsToRemove);
                        upper = Long.numberOfTrailingZeros((columnsToRemove | PassThroughTransform.maskLowBits(lower)) ^ 0xFFFFFFFFFFFFFFFFL);
                        reduced = reduced.removeColumns(lower, upper);
                        columnsToRemove &= PassThroughTransform.maskLowBits(upper) ^ 0xFFFFFFFFFFFFFFFFL;
                    } while ((columnsToRemove >>>= upper - lower) != 0L);
                    long leadPassThroughMask = PassThroughTransform.maskLowBits(this.firstAffectedCoordinate);
                    int numKeepAfter = Long.bitCount(retainedDimensions & ((leadPassThroughMask | subTransformMask) ^ 0xFFFFFFFFFFFFFFFFL));
                    int numKeepBefore = Long.bitCount(retainedDimensions & leadPassThroughMask);
                    int[] indices = new int[Long.bitCount(retainedDimensions) + change];
                    for (i = 0; i < indices.length; ++i) {
                        dim = Long.numberOfTrailingZeros(retainedDimensions);
                        if (dim == this.firstAffectedCoordinate) {
                            if (change < 0) {
                                retainedDimensions >>>= -change;
                                retainedDimensions &= leadPassThroughMask ^ 0xFFFFFFFFFFFFFFFFL;
                            } else {
                                retainedDimensions <<= change;
                                retainedDimensions |= PassThroughTransform.maskLowBits(change) << dim;
                            }
                        }
                        retainedDimensions &= 1L << dim ^ 0xFFFFFFFFFFFFFFFFL;
                        indices[i] = dim;
                    }
                    if (!keepSubTransform) {
                        i = indices.length;
                        while (--i >= 0 && (dim = indices[i]) > this.firstAffectedCoordinate) {
                            indices[i] = dim - change;
                        }
                    }
                    MathTransform tr = proxy.linear(Matrices.createDimensionSelect(dimension + change, indices));
                    if (keepSubTransform) {
                        tr = proxy.concatenate(tr, proxy.passThrough(numKeepBefore, this.subTransform, numKeepAfter));
                    }
                    tr = proxy.concatenate(tr, proxy.linear(reduced));
                    return tr;
                }
            }
        }
        return null;
    }

    private static long maskLowBits(int n) {
        return Numerics.bitmask(n) - 1L;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.subTransform.hashCode() + this.firstAffectedCoordinate;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            PassThroughTransform that = (PassThroughTransform)object;
            return this.firstAffectedCoordinate == that.firstAffectedCoordinate && this.numTrailingCoordinates == that.numTrailingCoordinates && Utilities.deepEquals(this.subTransform, that.subTransform, mode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.firstAffectedCoordinate);
        if (this.numTrailingCoordinates != 0) {
            formatter.append(this.numTrailingCoordinates);
        }
        formatter.append(this.subTransform);
        if (this.numTrailingCoordinates != 0) {
            formatter.setInvalidWKT(PassThroughTransform.class, null);
        }
        return "PassThrough_MT";
    }
}

