/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class UnitConversion
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = -7344042406568682405L;
    private final UnitConverter converter;
    private UnitConversion inverse;

    private UnitConversion(UnitConverter converter) {
        this.converter = converter;
    }

    static MathTransform1D create(UnitConverter converter) {
        Number[] coefficients = Units.coefficients(converter);
        if (coefficients != null) {
            Number scale = 1;
            Number offset = 0;
            switch (coefficients.length) {
                case 2: {
                    scale = coefficients[1];
                }
                case 1: {
                    offset = coefficients[0];
                }
                case 0: {
                    return LinearTransform1D.create(scale, offset);
                }
            }
        }
        return new UnitConversion(converter);
    }

    @Override
    public boolean isIdentity() {
        return this.converter.isIdentity();
    }

    @Override
    public double transform(double value) {
        return this.converter.convert(value);
    }

    @Override
    public double derivative(double value) throws TransformException {
        double derivative = Units.derivative(this.converter, value);
        if (Double.isNaN(derivative) && !Double.isNaN(value)) {
            throw new TransformException(Resources.format((short)2));
        }
        return derivative;
    }

    @Override
    public synchronized MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new UnitConversion(this.converter.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        if (other instanceof UnitConversion) {
            UnitConversion that = (UnitConversion)other;
            return UnitConversion.create(applyOtherFirst ? that.converter.concatenate(this.converter) : this.converter.concatenate(that.converter));
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }
}

