/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DimensionalityReduction;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.storage.CoverageSubset;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class CoverageQuery
extends Query
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4296814883807414158L;
    private GridGeometry domain;
    private Function<GridGeometry, DimensionalityReduction> reduction;
    private int[] range;
    private String[] rangeNames;
    private int sourceDomainExpansion;

    @Override
    public void setSelection(Envelope domain) {
        GridGeometry g2 = null;
        if (domain != null) {
            g2 = new GridGeometry(domain);
        }
        this.setSelection(g2);
    }

    public void setSelection(GridGeometry domain) {
        this.domain = domain;
    }

    public GridGeometry getSelection() {
        return this.domain;
    }

    public void setAxisSelection(Function<GridGeometry, DimensionalityReduction> reduction) {
        this.reduction = reduction;
    }

    public Function<GridGeometry, DimensionalityReduction> getAxisSelection() {
        return this.reduction;
    }

    final DimensionalityReduction getAxisSelection(GridCoverageResource source) throws DataStoreException {
        DimensionalityReduction r;
        if (this.reduction != null && !(r = this.reduction.apply(source.getGridGeometry())).isIdentity()) {
            return r;
        }
        return null;
    }

    @Override
    public void setProjection(String ... range) {
        if (range != null) {
            range = (String[])range.clone();
            ArgumentChecks.ensureNonEmpty("range", range);
        }
        this.rangeNames = range;
        this.range = null;
    }

    public void setProjection(int ... range) {
        if (range != null) {
            range = (int[])range.clone();
            ArgumentChecks.ensureNonEmptyBounded("range", true, 0, Integer.MAX_VALUE, range);
        }
        this.range = range;
        this.rangeNames = null;
    }

    public int[] getProjection() {
        return this.range != null ? (int[])this.range.clone() : null;
    }

    final int[] getProjection(GridCoverageResource source) throws DataStoreException {
        int[] sourceRange = this.range;
        if (sourceRange == null && this.rangeNames != null) {
            List<SampleDimension> sd = source.getSampleDimensions();
            int numBands = sd.size();
            sourceRange = new int[this.rangeNames.length];
            for (int i = 0; i < this.rangeNames.length; ++i) {
                int j;
                block4: {
                    String name = this.rangeNames[i];
                    for (j = 0; j < numBands; ++j) {
                        if (!name.equals(sd.get(j).getName().toString())) {
                            continue;
                        }
                        break block4;
                    }
                    InternationalString id = source.getIdentifier().map(GenericName::toInternationalString).orElseGet(() -> Vocabulary.formatInternational((short)208));
                    throw new UnsupportedQueryException(Errors.format((short)120, id, name));
                }
                sourceRange[i] = j;
            }
        }
        return sourceRange;
    }

    public void setSourceDomainExpansion(int margin) {
        ArgumentChecks.ensurePositive("margin", margin);
        this.sourceDomainExpansion = margin;
    }

    public int getSourceDomainExpansion() {
        return this.sourceDomainExpansion;
    }

    protected GridCoverageResource execute(GridCoverageResource source) throws DataStoreException {
        ArgumentChecks.ensureNonNull("source", source);
        return new CoverageSubset(null, source, this);
    }

    public CoverageQuery clone() {
        try {
            return (CoverageQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return 59 * Objects.hashCode(this.domain) + 37 * Arrays.hashCode(this.range) + 31 * this.sourceDomainExpansion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            CoverageQuery other = (CoverageQuery)obj;
            return this.sourceDomainExpansion == other.sourceDomainExpansion && Objects.equals(this.domain, other.domain) && Arrays.equals(this.range, other.range);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append("SELECT ");
        if (this.range != null) {
            sb.append("range[");
            for (int i = 0; i < this.range.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.range[i]);
            }
            sb.append(']');
        } else {
            sb.append('*');
        }
        if (this.domain != null) {
            sb.append(" WHERE domain \u2229 [");
            GeographicBoundingBox box = this.domain.getGeographicExtent().orElse(null);
            if (box != null) {
                AngleFormat f = new AngleFormat("D\u00b0");
                CoverageQuery.append(sb, f, new Latitude(box.getSouthBoundLatitude()), new Latitude(box.getNorthBoundLatitude()));
                CoverageQuery.append(sb, f, new Longitude(box.getWestBoundLongitude()), new Longitude(box.getEastBoundLongitude()));
            } else {
                sb.append('?');
            }
            sb.append(']');
            if (this.sourceDomainExpansion != 0) {
                sb.append(" + margin(").append(this.sourceDomainExpansion).append(')');
            }
        }
        return sb.toString();
    }

    private static void append(StringBuffer sb, AngleFormat f, Angle start, Angle end) {
        double span = Math.abs(end.degrees() - start.degrees()) / 1000.0;
        f.setPrecision(span > 0.0 && span < Double.POSITIVE_INFINITY ? span : 0.0, false);
        f.setRoundingMode(RoundingMode.DOWN);
        f.format(start, sb, null);
        f.setRoundingMode(RoundingMode.UP);
        f.format(end, sb, null);
    }
}

