/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.filter.SortByComparator;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.FeatureSubset;
import org.apache.sis.storage.Query;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;
import org.opengis.feature.PropertyType;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.filter.Literal;
import org.opengis.filter.SortBy;
import org.opengis.filter.SortProperty;
import org.opengis.filter.ValueReference;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;

public class FeatureQuery
extends Query
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5841189659773611160L;
    private static final long UNLIMITED = -1L;
    private NamedExpression[] projection;
    private Filter<? super Feature> selection;
    private long skip;
    private long limit = -1L;
    private SortBy<Feature> sortBy;
    private Quantity<Length> linearResolution;

    @Override
    public void setProjection(String ... properties) {
        NamedExpression[] wrappers = null;
        if (properties != null) {
            FilterFactory<Feature, Object, Object> ff = DefaultFilterFactory.forFeatures();
            wrappers = new NamedExpression[properties.length];
            for (int i = 0; i < wrappers.length; ++i) {
                String p = properties[i];
                ArgumentChecks.ensureNonNullElement("properties", i, p);
                wrappers[i] = new NamedExpression(ff.property(p));
            }
        }
        this.setProjection(wrappers);
    }

    @SafeVarargs
    public final void setProjection(Expression<? super Feature, ?> ... properties) {
        NamedExpression[] wrappers = null;
        if (properties != null) {
            wrappers = new NamedExpression[properties.length];
            for (int i = 0; i < wrappers.length; ++i) {
                Expression<? super Feature, ?> e = properties[i];
                ArgumentChecks.ensureNonNullElement("properties", i, e);
                wrappers[i] = new NamedExpression(e);
            }
        }
        this.setProjection(wrappers);
    }

    public void setProjection(NamedExpression ... properties) {
        if (properties != null) {
            ArgumentChecks.ensureNonEmpty("properties", properties);
            properties = (NamedExpression[])properties.clone();
            LinkedHashMap<Object, Integer> uniques = new LinkedHashMap<Object, Integer>(Containers.hashMapCapacity(properties.length));
            for (int i = 0; i < properties.length; ++i) {
                NamedExpression c = properties[i];
                ArgumentChecks.ensureNonNullElement("properties", i, c);
                Object key = c.alias != null ? c.alias : c.expression;
                Integer p = uniques.putIfAbsent(key, i);
                if (p == null) continue;
                if (key instanceof Expression) {
                    key = FeatureQuery.label((Expression)key);
                }
                throw new IllegalArgumentException(Resources.format((short)54, key, p, i));
            }
        }
        this.projection = properties;
    }

    public NamedExpression[] getProjection() {
        return this.projection != null ? (NamedExpression[])this.projection.clone() : null;
    }

    final NamedExpression[] getStoredProjection() {
        NamedExpression[] stored = this.getProjection();
        if (stored != null) {
            int count = 0;
            for (NamedExpression p : stored) {
                if (p.type != ProjectionType.STORED) continue;
                stored[count++] = p;
            }
            if (count != 0) {
                return ArraysExt.resize(stored, count);
            }
        }
        return null;
    }

    @Override
    public void setSelection(Envelope domain) {
        BinarySpatialOperator<Feature> filter = null;
        if (domain != null) {
            FilterFactory<Feature, Object, Object> ff = DefaultFilterFactory.forFeatures();
            filter = ff.bbox(ff.property("sis:geometry"), domain);
        }
        this.setSelection(filter);
    }

    public void setSelection(Filter<? super Feature> selection) {
        this.selection = selection;
    }

    public Filter<? super Feature> getSelection() {
        return this.selection;
    }

    public void setOffset(long skip) {
        ArgumentChecks.ensurePositive("skip", skip);
        this.skip = skip;
    }

    public long getOffset() {
        return this.skip;
    }

    public void setUnlimited() {
        this.limit = -1L;
    }

    public void setLimit(long limit) {
        ArgumentChecks.ensurePositive("limit", limit);
        this.limit = limit;
    }

    public OptionalLong getLimit() {
        return this.limit >= 0L ? OptionalLong.of(this.limit) : OptionalLong.empty();
    }

    @SafeVarargs
    public final void setSortBy(SortProperty<Feature> ... properties) {
        SortByComparator<Feature> sortBy = null;
        if (properties != null) {
            sortBy = SortByComparator.create(properties);
        }
        this.setSortBy(sortBy);
    }

    public void setSortBy(SortBy<Feature> sortBy) {
        this.sortBy = sortBy;
    }

    public SortBy<Feature> getSortBy() {
        return this.sortBy;
    }

    public void setLinearResolution(Quantity<Length> linearResolution) {
        this.linearResolution = linearResolution;
    }

    public Quantity<Length> getLinearResolution() {
        return this.linearResolution;
    }

    private static String label(Expression<?, ?> expression) {
        String text;
        if (expression instanceof Literal) {
            text = String.valueOf(((Literal)expression).getValue());
        } else if (expression instanceof ValueReference) {
            text = ((ValueReference)expression).getXPath();
        } else {
            return expression.getFunctionName().toString();
        }
        return CharSequences.shortSentence(text, 40).toString();
    }

    protected FeatureSet execute(FeatureSet source) throws DataStoreException {
        ArgumentChecks.ensureNonNull("source", source);
        FeatureQuery query = this.clone();
        if (query.selection != null) {
            Optimization optimization = new Optimization();
            optimization.setFeatureType(source.getType());
            query.selection = optimization.apply(query.selection);
        }
        return new FeatureSubset(source, query);
    }

    final FeatureType expectedType(FeatureType valueType) {
        if (this.projection == null) {
            return valueType;
        }
        int unnamedNumber = 0;
        HashSet<String> names = null;
        FeatureTypeBuilder ftb = new FeatureTypeBuilder().setName(valueType.getName());
        for (int column = 0; column < this.projection.length; ++column) {
            PropertyTypeBuilder resultType;
            NamedExpression item = this.projection[column];
            Expression<Feature, ?> expression = item.expression;
            FeatureExpression<? super Feature, ? super Feature> fex = FeatureExpression.castOrCopy(expression);
            if (fex == null || (resultType = fex.expectedType(valueType, ftb)) == null) {
                throw new InvalidFilterValueException(Resources.format((short)60, expression.getFunctionName().toInternationalString(), column));
            }
            GenericName name = item.alias;
            if (name == null) {
                if (names == null) {
                    names = new HashSet<String>(Containers.hashMapCapacity(this.projection.length));
                    for (NamedExpression p : this.projection) {
                        if (p.alias == null) continue;
                        names.add(p.alias.toString());
                    }
                }
                CharSequence text = null;
                if (expression instanceof ValueReference) {
                    GenericName current = resultType.getName();
                    if (current != null && names.add(current.toString())) continue;
                    String xpath = ((ValueReference)expression).getXPath().trim();
                    if (!(xpath = xpath.substring(xpath.lastIndexOf(47) + 1)).isEmpty() && !names.contains(xpath)) {
                        text = xpath;
                    }
                }
                if (text == null) {
                    while (!names.add((text = Vocabulary.formatInternational((short)266, (Object)(++unnamedNumber))).toString())) {
                    }
                }
                name = Names.createLocalName(null, null, text);
            }
            if (item.type == ProjectionType.COMPUTING && resultType instanceof AttributeTypeBuilder) {
                AttributeTypeBuilder ab = (AttributeTypeBuilder)resultType;
                PropertyType storedType = ab.build();
                if (!ftb.properties().remove(resultType)) continue;
                Map<String, GenericName> properties = Map.of("name", name);
                ftb.addProperty(FeatureOperations.expression(properties, expression, storedType));
                continue;
            }
            resultType.setName(name);
        }
        return ftb.build();
    }

    public FeatureQuery clone() {
        try {
            return (FeatureQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return 97 * Arrays.hashCode(this.projection) + 31 * Objects.hashCode(this.selection) + 7 * Objects.hashCode(this.sortBy) + Long.hashCode(this.limit ^ this.skip) + 3 * Objects.hashCode(this.linearResolution);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            FeatureQuery other = (FeatureQuery)obj;
            return this.skip == other.skip && this.limit == other.limit && Objects.equals(this.selection, other.selection) && Arrays.equals(this.projection, other.projection) && Objects.equals(this.sortBy, other.sortBy) && Objects.equals(this.linearResolution, other.linearResolution);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("SELECT ");
        if (this.projection != null) {
            for (int i = 0; i < this.projection.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                this.projection[i].appendTo(sb);
            }
        } else {
            sb.append('*');
        }
        if (this.selection != null) {
            sb.append(" WHERE ").append(this.selection);
        }
        if (this.sortBy != null) {
            String separator = " ORDER BY ";
            for (SortProperty<Feature> p : this.sortBy.getSortProperties()) {
                sb.append(separator);
                separator = ", ";
                sb.append(p.getValueReference().getXPath()).append(' ').append(p.getSortOrder());
            }
        }
        if (this.linearResolution != null) {
            sb.append(" RESOLUTION ").append(this.linearResolution);
        }
        if (this.limit != -1L) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.skip != 0L) {
            sb.append(" OFFSET ").append(this.skip);
        }
        return sb.toString();
    }

    public static class NamedExpression
    implements Serializable {
        private static final long serialVersionUID = 4547204390645035145L;
        public final Expression<? super Feature, ?> expression;
        public final GenericName alias;
        public final ProjectionType type;

        public NamedExpression(Expression<? super Feature, ?> expression) {
            this(expression, (GenericName)null);
        }

        public NamedExpression(Expression<? super Feature, ?> expression, GenericName alias) {
            this(expression, alias, ProjectionType.STORED);
        }

        public NamedExpression(Expression<? super Feature, ?> expression, String alias) {
            ArgumentChecks.ensureNonNull("expression", expression);
            this.expression = expression;
            this.alias = alias != null ? Names.createLocalName(null, null, alias) : null;
            this.type = ProjectionType.STORED;
        }

        public NamedExpression(Expression<? super Feature, ?> expression, GenericName alias, ProjectionType type) {
            ArgumentChecks.ensureNonNull("expression", expression);
            ArgumentChecks.ensureNonNull("type", (Object)type);
            this.expression = expression;
            this.alias = alias;
            this.type = type;
        }

        public int hashCode() {
            return 37 * this.expression.hashCode() + Objects.hashCode(this.alias) + this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                NamedExpression other = (NamedExpression)obj;
                return this.expression.equals(other.expression) && Objects.equals(this.alias, other.alias) && this.type == other.type;
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("SELECT ");
            this.appendTo(buffer);
            return buffer.toString();
        }

        final void appendTo(StringBuilder buffer) {
            if (this.expression instanceof Literal) {
                buffer.append('\u2018').append(((Literal)this.expression).getValue()).append('\u2019');
            } else if (this.expression instanceof ValueReference) {
                buffer.append('\u201c').append(((ValueReference)this.expression).getXPath()).append('\u201d');
            } else {
                buffer.append("=\u201c").append(this.expression.getFunctionName()).append("\u201d()");
            }
            if (this.type != ProjectionType.STORED) {
                buffer.append(' ').append((Object)this.type);
            }
            if (this.alias != null) {
                buffer.append(" AS \u201c").append(this.alias).append('\u201d');
            }
        }
    }

    public static enum ProjectionType {
        STORED,
        COMPUTING;

    }
}

