/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.TypeNames;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public final class Names
extends Static {
    private static final MemberName[] SEQUENCE_NUMBERS = new MemberName[16];

    private Names() {
    }

    private static NameSpace createNameSpace(NameFactory factory, CharSequence namespace, String separator) {
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        return factory.createNameSpace(factory.createLocalName(null, namespace), separator == null ? null : Map.of("separator.head", separator));
    }

    public static GenericName parseGenericName(CharSequence namespace, String separator, CharSequence scopedName) {
        ArgumentChecks.ensureNonNull("localPart", scopedName);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.parseGenericName(Names.createNameSpace(factory, namespace, separator), scopedName);
    }

    public static GenericName createGenericName(CharSequence namespace, String separator, CharSequence ... parsedNames) {
        ArgumentChecks.ensureNonNull("parsedNames", parsedNames);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createGenericName(Names.createNameSpace(factory, namespace, separator), parsedNames);
    }

    public static ScopedName createScopedName(GenericName scope, String separator, CharSequence name) {
        return new DefaultScopedName(scope, separator, name);
    }

    public static LocalName createLocalName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createLocalName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static TypeName createTypeName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createTypeName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static TypeName createTypeName(Class<?> valueClass) {
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        return factory.toTypeName(valueClass);
    }

    static MemberName createMemberName(GenericName namespace, CharSequence localPart, Class<?> valueClass) {
        DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        return factory.createMemberName(factory.createNameSpace(namespace, null), localPart, factory.toTypeName(valueClass));
    }

    public static MemberName createMemberName(CharSequence namespace, String separator, CharSequence localPart, Class<?> valueClass) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        return factory.createMemberName(Names.createNameSpace(factory, namespace, separator), localPart, factory.toTypeName(valueClass));
    }

    public static MemberName createMemberName(CharSequence namespace, String separator, CharSequence localPart, TypeName attributeType) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        ArgumentChecks.ensureNonNull("attributeType", attributeType);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createMemberName(Names.createNameSpace(factory, namespace, separator), localPart, attributeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static MemberName createMemberName(CharSequence namespace, String separator, int localPart) {
        MemberName[] memberNameArray;
        if (":".equals(separator)) {
            separator = null;
        }
        boolean cached = namespace == null && separator == null && localPart >= 0 && localPart < SEQUENCE_NUMBERS.length;
        MemberName name = null;
        if (cached) {
            memberNameArray = SEQUENCE_NUMBERS;
            // MONITORENTER : SEQUENCE_NUMBERS
            name = SEQUENCE_NUMBERS[localPart];
            // MONITOREXIT : memberNameArray
        }
        if (name != null) return name;
        name = Names.createMemberName(namespace, separator, (CharSequence)Integer.toString(localPart), Integer.class);
        if (!cached) return name;
        memberNameArray = SEQUENCE_NUMBERS;
        // MONITORENTER : SEQUENCE_NUMBERS
        Names.SEQUENCE_NUMBERS[localPart] = name;
        // MONITOREXIT : memberNameArray
        return name;
    }

    public static Class<?> toClass(TypeName type) throws UnknownNameException {
        Class<?> c;
        if (type == null) {
            return null;
        }
        Type t2 = type.toJavaType().orElse(null);
        if (t2 instanceof Class) {
            return (Class)t2;
        }
        try {
            c = TypeNames.toClass(TypeNames.namespace(type.scope()), type.toString());
        }
        catch (ClassNotFoundException e) {
            throw new UnknownNameException(TypeNames.unknown(type), e);
        }
        if (c == Void.TYPE) {
            throw new UnknownNameException(TypeNames.unknown(type));
        }
        return c;
    }

    public static String toExpandedString(GenericName name) {
        if (name == null) {
            return null;
        }
        String localPart = name.toString();
        NameSpace scope = name.scope();
        if (scope == null || scope.isGlobal()) {
            return localPart;
        }
        String ns = scope.name().toString();
        return new StringBuilder(ns.length() + localPart.length() + 2).append('{').append(ns).append('}').append(localPart).toString();
    }
}

