/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.geotoolkit.geometry.jts.awt.AbstractJTSGeometryJ2D;
import org.geotoolkit.geometry.jts.awt.JTSEmptyIterator;
import org.geotoolkit.geometry.jts.awt.JTSGeomCollectionIterator;
import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.geotoolkit.geometry.jts.awt.JTSLineIterator;
import org.geotoolkit.geometry.jts.awt.JTSMultiLineStringJ2D;
import org.geotoolkit.geometry.jts.awt.JTSPointIterator;
import org.geotoolkit.geometry.jts.awt.JTSPolygonIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;

public class JTSGeometryJ2D
extends AbstractJTSGeometryJ2D<Geometry> {
    protected JTSGeometryIterator<? extends Geometry> iterator = null;

    public JTSGeometryJ2D(Geometry geom) {
        super(geom);
    }

    public JTSGeometryJ2D(Geometry geom, MathTransform trs) {
        super(geom, trs);
    }

    @Override
    public void setGeometry(Geometry g2) {
        super.setGeometry(g2);
        if (!(this.iterator == null || this.geometry == null || this.geometry.isEmpty() && this.iterator instanceof JTSEmptyIterator)) {
            if (this.geometry instanceof Point && this.iterator instanceof JTSPointIterator) {
                ((JTSPointIterator)this.iterator).setGeometry((Point)this.geometry);
            } else if (this.geometry instanceof Polygon && this.iterator instanceof JTSPolygonIterator) {
                ((JTSPolygonIterator)this.iterator).setGeometry((Polygon)this.geometry);
            } else if (this.geometry instanceof LineString && this.iterator instanceof JTSLineIterator) {
                ((JTSLineIterator)this.iterator).setGeometry((LineString)this.geometry);
            } else if (this.geometry instanceof GeometryCollection && this.iterator instanceof JTSGeomCollectionIterator) {
                ((JTSGeomCollectionIterator)this.iterator).setGeometry((GeometryCollection)this.geometry);
            } else {
                this.iterator = null;
            }
        }
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        MathTransform concat = at == null ? this.transform : MathTransforms.concatenate(this.transform, (MathTransform)new AffineTransform2D(at));
        if (this.iterator == null) {
            if (this.geometry.isEmpty()) {
                this.iterator = JTSEmptyIterator.INSTANCE;
            } else if (this.geometry instanceof Point) {
                this.iterator = new JTSPointIterator((Point)this.geometry, concat);
            } else if (this.geometry instanceof Polygon) {
                this.iterator = new JTSPolygonIterator((Polygon)this.geometry, concat);
            } else if (this.geometry instanceof LineString) {
                this.iterator = new JTSLineIterator((LineString)this.geometry, concat);
            } else if (this.geometry instanceof GeometryCollection) {
                this.iterator = new JTSGeomCollectionIterator((GeometryCollection)this.geometry, concat);
            }
        } else {
            this.iterator.setTransform(concat);
        }
        return this.iterator;
    }

    @Override
    public AbstractJTSGeometryJ2D clone() {
        return new JTSGeometryJ2D(this.geometry, this.transform);
    }

    public static AbstractJTSGeometryJ2D best(Class clazz, MathTransform trs) {
        if (Point.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        if (MultiPoint.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        if (LineString.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        if (MultiLineString.class.isAssignableFrom(clazz)) {
            return new JTSMultiLineStringJ2D(null, trs);
        }
        if (Polygon.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        if (MultiPolygon.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new JTSGeometryJ2D(null, trs);
        }
        throw new IllegalArgumentException("Unexpected geometry class : " + clazz);
    }
}

