/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import org.geotoolkit.geometry.jts.transform.CoordinateSequenceMathTransformer;
import org.geotoolkit.geometry.jts.transform.CoordinateSequenceTransformer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.opengis.referencing.operation.TransformException;

public class CoordinateSequenceWrapTransformer
implements CoordinateSequenceTransformer {
    private final CoordinateSequenceFactory csf;
    private final double[] worldspan;
    private final double[] wrapdistance;
    private final double[] translation;
    private final boolean wrapOnX;
    private boolean wrap = false;

    public CoordinateSequenceWrapTransformer(double[] worldspan) {
        this(null, worldspan);
    }

    public CoordinateSequenceWrapTransformer(CoordinateSequenceFactory csf, double[] worldspan) {
        this.csf = csf == null ? CoordinateSequenceMathTransformer.DEFAULT_CS_FACTORY : csf;
        this.worldspan = worldspan;
        this.wrapdistance = new double[]{worldspan[0] / 2.0, worldspan[1] / 2.0};
        this.translation = (double[])worldspan.clone();
        this.wrapOnX = this.wrapdistance[0] != 0.0;
    }

    @Override
    public CoordinateSequence transform(CoordinateSequence sequence, int minpoints) throws TransformException {
        int size = sequence.size();
        Coordinate[] tcs = new Coordinate[size];
        boolean directionChecked = false;
        Coordinate previous = null;
        Coordinate current = null;
        for (int i = 0; i < size; ++i) {
            current = sequence.getCoordinate(i);
            if (previous != null) {
                double distance = Math.abs(this.wrapOnX ? current.x - previous.x : current.y - previous.y);
                if (this.wrapOnX && distance >= this.wrapdistance[0] && distance < this.worldspan[0]) {
                    boolean bl = this.wrap = !this.wrap;
                    if (!directionChecked) {
                        directionChecked = true;
                        test = Math.abs(current.x + this.translation[0] - previous.x);
                        if (test > distance) {
                            this.translation[0] = -this.translation[0];
                            this.translation[1] = -this.translation[1];
                        }
                    }
                } else if (!this.wrapOnX && distance >= this.wrapdistance[1] && distance < this.worldspan[1]) {
                    boolean bl = this.wrap = !this.wrap;
                    if (!directionChecked) {
                        directionChecked = true;
                        test = Math.abs(current.y + this.translation[1] - previous.y);
                        if (test > distance) {
                            this.translation[0] = -this.translation[0];
                            this.translation[1] = -this.translation[1];
                        }
                    }
                }
            }
            previous = current;
            tcs[i] = this.wrap ? new Coordinate(current.x + this.translation[0], current.y + this.translation[1], current.z) : current;
        }
        return this.csf.create(tcs);
    }
}

