/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;
import org.geotoolkit.geometry.math.Vector3d;
import org.geotoolkit.geometry.math.Vectors;
import org.locationtech.jts.geom.Coordinate;

public class Geometries {
    private static final double TOLERANCE = 0.0;

    public static double[] calculateNormal(Coordinate a, Coordinate b, Coordinate c) {
        double[] ab = new double[]{b.x - a.x, b.y - a.y, b.z - a.z};
        double[] ac = new double[]{c.x - a.x, c.y - a.y, c.z - a.z};
        double[] res = Geometries.cross(ab, ac);
        Vectors.normalize(res, res);
        return res;
    }

    public static float[] calculateNormal(float[] a, float[] b, float[] c) {
        float[] ab = Vectors.subtract(b, a);
        float[] ac = Vectors.subtract(c, a);
        float[] res = Geometries.cross(ab, ac);
        Vectors.normalize(res, res);
        return res;
    }

    public static double[] calculateNormal(double[] a, double[] b, double[] c) {
        double[] ab = Vectors.subtract(b, a);
        double[] ac = Vectors.subtract(c, a);
        double[] res = Vectors.cross(ab, ac);
        Vectors.normalize(res, res);
        return res;
    }

    public static double[] calculateNormalD(float[] a, float[] b, float[] c) {
        double[] ab = Geometries.subtract(b, a);
        double[] ac = Geometries.subtract(c, a);
        double[] res = Geometries.cross(ab, ac);
        Geometries.normalize(res);
        return res;
    }

    public static Vector calculateNormal(Tuple a, Tuple b, Tuple c) {
        Vector ab = Vectors.createDouble(a.getDimension());
        ab.add(b);
        ab.subtract(a);
        Vector ac = Vectors.createDouble(a.getDimension());
        ac.add(c);
        ac.subtract(a);
        Vector res = ab.cross(ac);
        res.normalize();
        return res;
    }

    public static double[] subtract(float[] A2, float[] B) {
        return new double[]{A2[0] - B[0], A2[1] - B[1], A2[2] - B[2]};
    }

    public static double[] cross(double[] vector, double[] other) {
        double newX = vector[1] * other[2] - vector[2] * other[1];
        double newY = vector[2] * other[0] - vector[0] * other[2];
        double newZ = vector[0] * other[1] - vector[1] * other[0];
        return new double[]{newX, newY, newZ};
    }

    public static float[] cross(float[] vector, float[] other) {
        float newX = vector[1] * other[2] - vector[2] * other[1];
        float newY = vector[2] * other[0] - vector[0] * other[2];
        float newZ = vector[0] * other[1] - vector[1] * other[0];
        return new float[]{newX, newY, newZ};
    }

    public static void normalize(float[] vector) {
        float nlength = 1.0f / (float)Geometries.length(vector);
        vector[0] = vector[0] * nlength;
        vector[1] = vector[1] * nlength;
        vector[2] = vector[2] * nlength;
    }

    public static void normalize(double[] vector) {
        double nlength = 1.0 / Geometries.length(vector);
        vector[0] = vector[0] * nlength;
        vector[1] = vector[1] * nlength;
        vector[2] = vector[2] * nlength;
    }

    public static double length(float[] vector) {
        double length = vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2];
        return Math.sqrt(length);
    }

    public static double length(double[] vector) {
        double length = vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2];
        return Math.sqrt(length);
    }

    public static boolean isOnLine(Tuple a, Tuple b, Tuple p) {
        if (Geometries.lineSide(a, b, p) != 0.0) {
            return false;
        }
        double[] ab = new double[]{b.get(0) - a.get(0), b.get(1) - a.get(1)};
        double[] dArray = new double[]{p.get(0) - a.get(0), p.get(1) - a.get(1)};
        double[] ac = dArray;
        double e = Geometries.dot2D(ac, ab);
        if (e <= 0.0) {
            return false;
        }
        double f = Geometries.dot2D(ab, ab);
        return !(e >= f);
    }

    public static boolean isOnLine(float[] a, float[] b, float[] p) {
        if (Geometries.lineSide(a, b, p) != 0.0) {
            return false;
        }
        double[] ab = Geometries.subtract(b, a);
        double[] ac = Geometries.subtract(p, a);
        double e = Geometries.dot2D(ac, ab);
        if (e <= 0.0) {
            return false;
        }
        double f = Geometries.dot2D(ab, ab);
        return !(e >= f);
    }

    public static double lineSide(Tuple a, Tuple b, Tuple c) {
        return (b.get(0) - a.get(0)) * (c.get(1) - a.get(1)) - (c.get(0) - a.get(0)) * (b.get(1) - a.get(1));
    }

    public static double lineSide(float[] a, float[] b, float[] c) {
        return (b[0] - a[0]) * (c[1] - a[1]) - (c[0] - a[0]) * (b[1] - a[1]);
    }

    public static boolean inTriangle2D(Tuple a, Tuple b, Tuple c, Tuple p) {
        double[] bary = Geometries.getBarycentricValue2D(a, b, c, p);
        return bary[1] >= 0.0 && bary[2] >= 0.0 && bary[1] + bary[2] <= 1.0;
    }

    public static boolean inTriangle2D(float[] a, float[] b, float[] c, float[] p) {
        double[] bary = Geometries.getBarycentricValue(a, b, c, p);
        return bary[1] >= 0.0 && bary[2] >= 0.0 && bary[1] + bary[2] <= 1.0;
    }

    public static boolean isCounterClockwise(Tuple a, Tuple b, Tuple c) {
        return Geometries.lineSide(a, b, c) > 0.0;
    }

    public static boolean isCounterClockwise(float[] a, float[] b, float[] c) {
        return Geometries.lineSide(a, b, c) > 0.0;
    }

    public static double[] getBarycentricValue2D(Tuple a, Tuple b, Tuple c, Tuple p) {
        double[] v0 = new double[]{b.get(0) - a.get(0), b.get(1) - a.get(1)};
        double[] v1 = new double[]{c.get(0) - a.get(0), c.get(1) - a.get(1)};
        double[] v2 = new double[]{p.get(0) - a.get(0), p.get(1) - a.get(1)};
        double d00 = Geometries.dot2D(v0, v0);
        double d01 = Geometries.dot2D(v0, v1);
        double d11 = Geometries.dot2D(v1, v1);
        double d20 = Geometries.dot2D(v2, v0);
        double d21 = Geometries.dot2D(v2, v1);
        double denom = d00 * d11 - d01 * d01;
        double v = (d11 * d20 - d01 * d21) / denom;
        double w = (d00 * d21 - d01 * d20) / denom;
        double u = 1.0 - v - w;
        return new double[]{u, v, w};
    }

    public static double[] getBarycentricValue(float[] a, float[] b, float[] c, float[] p) {
        double[] v0 = Geometries.subtract(b, a);
        double[] v1 = Geometries.subtract(c, a);
        double[] v2 = Geometries.subtract(p, a);
        double d00 = Geometries.dot2D(v0, v0);
        double d01 = Geometries.dot2D(v0, v1);
        double d11 = Geometries.dot2D(v1, v1);
        double d20 = Geometries.dot2D(v2, v0);
        double d21 = Geometries.dot2D(v2, v1);
        double denom = d00 * d11 - d01 * d01;
        double v = (d11 * d20 - d01 * d21) / denom;
        double w = (d00 * d21 - d01 * d20) / denom;
        double u = 1.0 - v - w;
        return new double[]{u, v, w};
    }

    public static boolean inCircle(Tuple a, Tuple b, Tuple c, Tuple d) {
        return Geometries.inCircle(a.toArrayFloat(), b.toArrayFloat(), c.toArrayFloat(), d.toArrayFloat());
    }

    public static boolean inCircle(float[] a, float[] b, float[] c, float[] d) {
        double a2 = a[0] * a[0] + a[1] * a[1];
        double b2 = b[0] * b[0] + b[1] * b[1];
        double c2 = c[0] * c[0] + c[1] * c[1];
        double d2 = d[0] * d[0] + d[1] * d[1];
        double det44 = 0.0;
        det44 += d2 * Geometries.det33(a[0], a[1], 1.0, b[0], b[1], 1.0, c[0], c[1], 1.0);
        det44 -= (double)d[0] * Geometries.det33(a2, a[1], 1.0, b2, b[1], 1.0, c2, c[1], 1.0);
        det44 += (double)d[1] * Geometries.det33(a2, a[0], 1.0, b2, b[0], 1.0, c2, c[0], 1.0);
        return (det44 -= 1.0 * Geometries.det33(a2, a[0], a[1], b2, b[0], b[1], c2, c[0], c[1])) < 0.0;
    }

    private static double det33(double ... m4) {
        double det33 = 0.0;
        det33 += m4[0] * (m4[4] * m4[8] - m4[5] * m4[7]);
        det33 -= m4[1] * (m4[3] * m4[8] - m4[5] * m4[6]);
        return det33 += m4[2] * (m4[3] * m4[7] - m4[4] * m4[6]);
    }

    public static double dot2D(float[] vector, float[] other) {
        double dot = 0.0;
        for (int i = 0; i < 2; ++i) {
            dot += (double)vector[i] * (double)other[i];
        }
        return dot;
    }

    public static double dot2D(double[] vector, double[] other) {
        double dot = 0.0;
        for (int i = 0; i < 2; ++i) {
            dot += vector[i] * other[i];
        }
        return dot;
    }

    public static double distance(Tuple a, Vector planNormal, double planD) {
        return planNormal.dot(a) - planD;
    }

    public static double distance(Vector3d a, Vector3d planNormal, double planD) {
        return planNormal.dot(a) - planD;
    }

    public static double distanceSquare(float[] segmentStart, float[] segmentEnd, float[] point) {
        double[] ab = Geometries.subtract(segmentEnd, segmentStart);
        double[] ac = Geometries.subtract(point, segmentStart);
        double[] bc = Geometries.subtract(point, segmentEnd);
        double e = Geometries.dot2D(ac, ab);
        if (e <= 0.0) {
            return Geometries.dot2D(ac, ac);
        }
        double f = Geometries.dot2D(ab, ab);
        if (e >= f) {
            return Geometries.dot2D(bc, bc);
        }
        return Geometries.dot2D(ac, ac) - e * e / f;
    }

    public static float[] calculateNormal(float[] a, float[] b, float[] c, float[] buffer) {
        float[] ab = Vectors.subtract(b, a);
        float[] ac = Vectors.subtract(c, a);
        buffer = Vectors.cross(ab, ac, buffer);
        return Vectors.normalize(buffer, buffer);
    }

    public static double[] calculateCircleCenter(double[] a, double[] b, double[] c) {
        double[] center;
        double as = (b[1] - a[1]) / (b[0] - a[0]);
        double bs = (c[1] - b[1]) / (c[0] - b[0]);
        center = new double[]{(as * bs * (a[1] - c[1]) + bs * (a[0] + b[0]) - as * (b[0] + c[0])) / (2.0 * (bs - as)), -1.0 * (center[0] - (a[0] + b[0]) / 2.0) / as + (a[1] + b[1]) / 2.0};
        return center;
    }

    public static double[] calculatePointSymmetry(double[] c, double[] p) {
        double[] r = new double[c.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = 2.0 * c[i] - p[i];
        }
        return r;
    }

    public static boolean isOnLine(Coordinate a, Coordinate b, Coordinate p) {
        return Geometries.lineSide(a, b, p) == 0.0;
    }

    public static boolean isCounterClockwise(Coordinate a, Coordinate b, Coordinate c) {
        return Geometries.lineSide(a, b, c) > 0.0;
    }

    public static double lineSide(Coordinate a, Coordinate b, Coordinate c) {
        return (b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y);
    }

    public static boolean inCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate d) {
        double a2 = a.x * a.x + a.y * a.y;
        double b2 = b.x * b.x + b.y * b.y;
        double c2 = c.x * c.x + c.y * c.y;
        double d2 = d.x * d.x + d.y * d.y;
        double det44 = 0.0;
        det44 += d2 * Geometries.det33(a.x, a.y, 1.0, b.x, b.y, 1.0, c.x, c.y, 1.0);
        det44 -= d.x * Geometries.det33(a2, a.y, 1.0, b2, b.y, 1.0, c2, c.y, 1.0);
        det44 += d.y * Geometries.det33(a2, a.x, 1.0, b2, b.x, 1.0, c2, c.x, 1.0);
        return (det44 -= 1.0 * Geometries.det33(a2, a.x, a.y, b2, b.x, b.y, c2, c.x, c.y)) < 0.0;
    }

    public static boolean inTriangle(double[] a, double[] b, double[] c, double[] p) {
        double[] bary = Geometries.getBarycentricValue(a, b, c, p);
        return bary[1] >= 0.0 && bary[2] >= 0.0 && bary[1] + bary[2] <= 1.0;
    }

    public static double[] getBarycentricValue(double[] a, double[] b, double[] c, double[] p) {
        double[] v0 = Vectors.subtract(b, a);
        double[] v1 = Vectors.subtract(c, a);
        double[] v2 = Vectors.subtract(p, a);
        double d00 = Vectors.dot(v0, v0);
        double d01 = Vectors.dot(v0, v1);
        double d11 = Vectors.dot(v1, v1);
        double d20 = Vectors.dot(v2, v0);
        double d21 = Vectors.dot(v2, v1);
        double denom = d00 * d11 - d01 * d01;
        double v = (d11 * d20 - d01 * d21) / denom;
        double w = (d00 * d21 - d01 * d20) / denom;
        double u = 1.0 - v - w;
        return new double[]{u, v, w};
    }

    public static double calculatePlanD(double[] normal, double[] pointOnPlan) {
        return Vectors.dot(normal, pointOnPlan);
    }

    public static double[] projectPointOnPlan(double[] point, double[] planNormal, double planD) {
        double[] va = Vectors.subtract(point, Vectors.scale(planNormal, planD));
        double d = Vectors.dot(planNormal, va);
        return Vectors.subtract(va, Vectors.scale(planNormal, d));
    }

    public static boolean isClockWise(List<Coordinate> coordinates) {
        double area = Geometries.calculateArea(coordinates);
        return area > 0.0;
    }

    public static double calculateArea(List<Coordinate> coordinates) {
        double area = 0.0;
        int numPoints = coordinates.size();
        for (int i = 0; i < numPoints - 1; ++i) {
            Coordinate start = coordinates.get(i);
            Coordinate end = coordinates.get(i + 1);
            area += (start.x + end.x) * (start.y - end.y);
        }
        return area / 2.0;
    }

    public static MatrixSIS centeredScaled(GeneralEnvelope source, GeneralEnvelope target, double scale) {
        double[] sourceCenter = source.getMedian().getCoordinate();
        double[] targetCenter = target.getMedian().getCoordinate();
        Vectors.scale(sourceCenter, scale, sourceCenter);
        double[] trs = Vectors.subtract(targetCenter, sourceCenter);
        Matrix4 mt = new Matrix4();
        for (int i = 0; i < trs.length; ++i) {
            mt.setElement(i, i, scale);
            mt.setElement(i, trs.length, trs[i]);
        }
        return mt;
    }

    public static MatrixSIS scaled(GeneralEnvelope source, GeneralEnvelope target) {
        int dim = source.getDimension();
        double scale = target.getSpan(0) / source.getSpan(0);
        for (int i = 1; i < dim; ++i) {
            scale = Math.min(target.getSpan(i) / source.getSpan(i), scale);
        }
        return Geometries.centeredScaled(source, target, scale);
    }

    public static byte[] pad(byte[] data, boolean isJson, int previousDataLength, int padding) {
        if (data == null) {
            return null;
        }
        int remaining = (previousDataLength + data.length) % padding;
        if (remaining == 0) {
            return data;
        }
        byte[] array = new byte[data.length + (padding - remaining)];
        Arrays.fill(array, isJson ? (byte)32 : 0);
        System.arraycopy(data, 0, array, 0, data.length);
        return array;
    }
}

