/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;

public class Tuple3i
implements Tuple {
    public int x;
    public int y;
    public int z;

    public Tuple3i() {
    }

    public Tuple3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = (int)value;
                break;
            }
            case 1: {
                this.y = (int)value;
                break;
            }
            case 2: {
                this.z = (int)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = (int)values[0];
        this.y = (int)values[1];
        this.z = (int)values[2];
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{this.x, this.y, this.z};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

