/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;

public class Vector1d
implements Vector {
    public double x;

    public Vector1d() {
    }

    public Vector1d(double x) {
        this.x = x;
    }

    public Vector1d(double[] array) {
        this.x = array[0];
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = values[0];
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x);
    }

    @Override
    public double lengthSquare() {
        return this.x * this.x;
    }

    @Override
    public void normalize() {
        double s2 = 1.0 / this.length();
        this.x *= s2;
    }

    @Override
    public void add(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x += other.get(0);
    }

    @Override
    public void subtract(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x -= other.get(0);
    }

    @Override
    public void scale(double scale) {
        this.x *= scale;
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{(int)this.x};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{(float)this.x};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = (int)this.x;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = (float)this.x;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

