/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;

public class Vector1f
implements Vector {
    public float x;

    public Vector1f() {
    }

    public Vector1f(float x) {
        this.x = x;
    }

    public Vector1f(float[] array) {
        this.x = array[0];
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = (float)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = (float)values[0];
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x);
    }

    @Override
    public double lengthSquare() {
        return this.x * this.x;
    }

    @Override
    public void normalize() {
        double s2 = 1.0 / this.length();
        this.x = (float)((double)this.x * s2);
    }

    @Override
    public void add(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x + other.get(0));
    }

    @Override
    public void subtract(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x - other.get(0));
    }

    @Override
    public void scale(double scale) {
        this.x = (float)((double)this.x * scale);
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{(int)this.x};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{this.x};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = (int)this.x;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = this.x;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

