/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Coordinates {
    public String getValue();

    default public Stream<String> brutCoordinates() {
        String value = this.getValue();
        if (value == null || (value = value.trim()).isEmpty()) {
            return Stream.empty();
        }
        String ts = this.getTs() == null ? " " : this.getTs();
        final StringTokenizer tokenizer = new StringTokenizer(value, ts);
        Spliterator<String> spliterator = new Spliterator<String>(){

            @Override
            public boolean tryAdvance(Consumer<? super String> action) {
                boolean moreAvailable = tokenizer.hasMoreElements();
                if (moreAvailable) {
                    action.accept(tokenizer.nextToken());
                }
                return moreAvailable;
            }

            @Override
            public Spliterator<String> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return tokenizer.countTokens();
            }

            @Override
            public int characteristics() {
                return 1104;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    default public DoubleStream values() {
        return this.points().flatMapToDouble(array -> DoubleStream.of(array));
    }

    default public Stream<double[]> points() {
        String cs = this.getCs() == null ? "," : this.getCs();
        return this.brutCoordinates().map(str -> {
            int lastIdx;
            ArrayList<String> parts = new ArrayList<String>(3);
            int startIdx = 0;
            do {
                if ((lastIdx = str.indexOf(cs, startIdx)) <= 0) continue;
                parts.add(str.substring(startIdx, lastIdx));
                startIdx = lastIdx + cs.length();
            } while (lastIdx >= 0);
            parts.add(str.substring(startIdx));
            double[] result = new double[parts.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Double.parseDouble((String)parts.get(i));
            }
            return result;
        });
    }

    default public List<Double> getValues() {
        return this.values().boxed().collect(Collectors.toList());
    }

    public String getCs();

    public String getTs();

    public String getDecimal();
}

