/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.v311.CoordinatesType;
import org.geotoolkit.gml.xml.v311.DirectPositionType;
import org.geotoolkit.gml.xml.v311.EnvelopeWithTimePeriodType;
import org.geotoolkit.util.Utilities;
import org.opengis.filter.Expression;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.ScopedName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnvelopeType", propOrder={"lowerCorner", "upperCorner", "pos", "coordinates"})
@XmlSeeAlso(value={EnvelopeWithTimePeriodType.class})
@XmlRootElement(name="Envelope")
public class EnvelopeType
implements org.opengis.geometry.Envelope,
Envelope,
Expression {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.gml.xml.v311");
    @XmlAttribute(namespace="http://www.opengis.net/gml")
    @Deprecated
    private String id;
    private DirectPositionType lowerCorner;
    private DirectPositionType upperCorner;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;
    @Deprecated
    private List<DirectPositionType> pos;
    @Deprecated
    private CoordinatesType coordinates;

    protected EnvelopeType() {
    }

    @Deprecated
    public EnvelopeType(String id, DirectPositionType lowerCorner, DirectPositionType upperCorner, String srsName) {
        this(lowerCorner, upperCorner, srsName);
    }

    public EnvelopeType(DirectPositionType lowerCorner, DirectPositionType upperCorner, String srsName) {
        this.lowerCorner = lowerCorner;
        this.upperCorner = upperCorner;
        this.srsName = srsName;
    }

    @Deprecated
    public EnvelopeType(List<DirectPositionType> pos, String srsName) {
        this.srsName = srsName;
        this.pos = pos;
        this.srsDimension = null;
    }

    public EnvelopeType(org.opengis.geometry.Envelope env) {
        this.pos = new ArrayList<DirectPositionType>();
        if (env != null) {
            this.pos.add(new DirectPositionType(env.getLowerCorner(), false));
            this.pos.add(new DirectPositionType(env.getUpperCorner(), false));
            CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
            if (crs != null) {
                try {
                    if (crs instanceof CompoundCRS) {
                        StringBuilder sb = new StringBuilder();
                        CompoundCRS compCrs = (CompoundCRS)crs;
                        sb.append("urn:ogc:def:crs,");
                        for (CoordinateReferenceSystem child : compCrs.getComponents()) {
                            String childSrs = IdentifiedObjects.lookupURN(child, null);
                            if (childSrs != null) {
                                if (childSrs.startsWith("urn:ogc:def:")) {
                                    childSrs = childSrs.substring(12);
                                }
                                sb.append(childSrs).append(',');
                                continue;
                            }
                            sb.append("crs:EPSG::unknow,");
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        this.srsName = sb.toString();
                    } else {
                        this.srsName = IdentifiedObjects.lookupURN(crs, null);
                        if (this.srsName == null) {
                            this.srsName = "urn:ogc:def:crs:EPSG::unknow";
                        }
                    }
                    this.srsDimension = crs.getCoordinateSystem().getDimension();
                }
                catch (FactoryException ex) {
                    LOGGER.log(Level.SEVERE, "Factory exception xhile creating GML envelope from opengis one", ex);
                }
            }
        }
    }

    @Override
    public DirectPositionType getLowerCorner() {
        return this.lowerCorner;
    }

    public void setLowerCorner(DirectPositionType value) {
        this.lowerCorner = value;
    }

    @Override
    public DirectPositionType getUpperCorner() {
        return this.upperCorner;
    }

    public void setUpperCorner(DirectPositionType value) {
        this.upperCorner = value;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        this.axisLabels = axisLabels;
    }

    public void setAxisLabels(String axisLabel) {
        if (axisLabel != null) {
            if (this.axisLabels == null) {
                this.axisLabels = new ArrayList<String>();
            }
            this.axisLabels.add(axisLabel);
        }
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public boolean isCompleteEnvelope2D() {
        return this.getLowerCorner() != null && this.getUpperCorner() != null && this.getLowerCorner().getValue().size() == 2 && this.getUpperCorner().getValue().size() == 2;
    }

    @Deprecated
    public List<DirectPositionType> getPos() {
        if (this.pos == null) {
            this.pos = new ArrayList<DirectPositionType>();
        }
        return this.pos;
    }

    @Override
    @Deprecated
    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    @Deprecated
    public void setCoordinates(CoordinatesType value) {
        this.coordinates = value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EnvelopeType) {
            EnvelopeType that = (EnvelopeType)object;
            return Utilities.listNullEquals(this.axisLabels, that.axisLabels) && Objects.equals(this.coordinates, that.coordinates) && Objects.equals(this.id, that.id) && Objects.equals(this.lowerCorner, that.lowerCorner) && Utilities.listNullEquals(this.pos, that.pos) && Objects.equals(this.srsDimension, that.srsDimension) && Utilities.listNullEquals(this.uomLabels, that.uomLabels) && Objects.equals(this.srsName, that.srsName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 79 * hash + (this.lowerCorner != null ? this.lowerCorner.hashCode() : 0);
        hash = 79 * hash + (this.upperCorner != null ? this.upperCorner.hashCode() : 0);
        hash = 79 * hash + (this.pos != null ? this.pos.hashCode() : 0);
        hash = 79 * hash + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        hash = 79 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 79 * hash + (this.srsDimension != null ? this.srsDimension.hashCode() : 0);
        hash = 79 * hash + (this.axisLabels != null ? this.axisLabels.hashCode() : 0);
        hash = 79 * hash + (this.uomLabels != null ? this.uomLabels.hashCode() : 0);
        return hash;
    }

    public String toString() {
        int i;
        StringBuilder s2 = new StringBuilder();
        if (this.id != null) {
            s2.append("id:").append(this.id).append(" ");
        }
        if (this.srsDimension != null) {
            s2.append("srsDimension:").append(this.srsDimension).append(" ");
        }
        if (this.srsName != null) {
            s2.append("srsName:").append(this.srsName).append(" ");
        }
        if (this.lowerCorner != null) {
            s2.append('\n').append("lowerCorner:").append(this.lowerCorner.toString());
        }
        if (this.upperCorner != null) {
            s2.append('\n').append("upperCorner:").append(this.upperCorner.toString());
        }
        if (this.pos != null) {
            i = 0;
            for (DirectPositionType posi : this.pos) {
                s2.append('\n').append("pos").append(i).append(":").append(posi.toString());
                ++i;
            }
            s2.append('\n');
        }
        if (this.coordinates != null) {
            s2.append("coordinates:").append(this.coordinates.toString());
        }
        if (this.axisLabels != null) {
            i = 0;
            for (String axis : this.axisLabels) {
                s2.append('\n').append("axis").append(i).append(":").append(axis);
                ++i;
            }
            s2.append('\n');
        }
        if (this.uomLabels != null) {
            i = 0;
            for (String uom : this.uomLabels) {
                s2.append('\n').append("uom").append(i).append(":").append(uom);
                ++i;
            }
            s2.append('\n');
        }
        return s2.toString();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.forCode(this.srsName);
            }
            catch (NoSuchAuthorityCodeException ex) {
                LOGGER.log(Level.SEVERE, "NoSuchAuthorityCodeException while looking for GML envelope crs:" + this.srsName, ex);
            }
            catch (FactoryException ex) {
                LOGGER.log(Level.SEVERE, "FactoryException while looking for GML envelope crs:" + this.srsName, ex);
            }
        }
        return null;
    }

    @Override
    public int getDimension() {
        CoordinateReferenceSystem crs;
        if (this.srsDimension == null && this.srsName != null && (crs = this.getCoordinateReferenceSystem()) != null) {
            this.srsDimension = crs.getCoordinateSystem().getDimension();
        }
        return this.srsDimension;
    }

    @Override
    public double getMinimum(int i) throws IndexOutOfBoundsException {
        if (this.lowerCorner != null) {
            return this.lowerCorner.getOrdinate(i);
        }
        return -1.0;
    }

    @Override
    public double getMaximum(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner != null) {
            return this.upperCorner.getOrdinate(i);
        }
        return -1.0;
    }

    @Override
    public double getMedian(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner == null || this.lowerCorner == null) {
            return Double.NaN;
        }
        return 0.5 * (this.upperCorner.getOrdinate(i) + this.lowerCorner.getOrdinate(i));
    }

    @Override
    public double getSpan(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner == null || this.lowerCorner == null) {
            return Double.NaN;
        }
        return this.upperCorner.getOrdinate(i) - this.lowerCorner.getOrdinate(i);
    }

    @Override
    public ScopedName getFunctionName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class getResourceClass() {
        return null;
    }

    public List<Expression> getParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object apply(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression toValueType(Class type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

