/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.internal.Threads;

public class ReferenceQueueConsumer<T>
extends Thread {
    public static final ReferenceQueueConsumer<Object> DEFAULT = new ReferenceQueueConsumer("ReferenceQueueConsumer");
    public final ReferenceQueue<T> queue = new ReferenceQueue();

    protected ReferenceQueueConsumer(String name) {
        super(Threads.RESOURCE_DISPOSERS, name);
        this.setPriority(8);
    }

    protected void process(Reference<? extends T> reference) {
        ((Disposable)((Object)reference)).dispose();
    }

    @Override
    public final void run() {
        ReferenceQueue<T> queue;
        Level level = Level.SEVERE;
        while ((queue = this.queue) != null) {
            Reference<T> ref;
            try {
                ref = queue.remove();
                if (ref == null) {
                    ReferenceQueueConsumer.sleep(15000L);
                    break;
                }
            }
            catch (InterruptedException exception) {
                continue;
            }
            try {
                this.process(ref);
            }
            catch (Throwable exception) {
                Logging.unexpectedException(null, this.getClass(), "run", exception);
            }
        }
        Logger.getLogger("org.geotoolkit.internal").log(level, "{0} daemon stopped.", Classes.getShortClassName(this));
    }

    static {
        DEFAULT.start();
    }
}

