/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import org.geotoolkit.geometry.GeometricUtilities;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.internal.jaxb.CurveInterpolationAdapter;
import org.geotoolkit.internal.jaxb.DirectPositionAdapter;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveInterpolation;
import org.opengis.geometry.primitive.CurveSegment;

public class CurveSegmentAdapter
extends XmlAdapter<CurveSegmentAdapter, CurveSegment> {
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CurveInterpolationAdapter.class)
    private CurveInterpolation interpolation = CurveInterpolation.LINEAR;
    @XmlElement(name="pos", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    private List<Position> positions;

    public CurveSegmentAdapter() {
    }

    public CurveSegmentAdapter(CurveSegment lineString) {
        this.positions = GeometricUtilities.getSamplePoints(lineString);
    }

    @Override
    public CurveSegment unmarshal(CurveSegmentAdapter v) throws Exception {
        JTSLineString line = new JTSLineString();
        for (Position p : v.positions) {
            line.getPositions().add(p);
        }
        return line;
    }

    @Override
    public CurveSegmentAdapter marshal(CurveSegment v) throws Exception {
        return new CurveSegmentAdapter(v);
    }
}

