/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPolygon;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPolyhedralSurface;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSRing;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfaceBoundary;
import org.geotoolkit.internal.jaxb.CoordinateReferenceSystemAdapter;
import org.geotoolkit.internal.jaxb.PolygonPatchesListType;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PolyhedralSurfaceType", namespace="http://www.opengis.net/gml")
public class PolyhedralSurfaceType {
    @XmlAttribute(name="srsName")
    @XmlJavaTypeAdapter(value=CoordinateReferenceSystemAdapter.class)
    private CoordinateReferenceSystem coordinateReferenceSystem;
    @XmlElement(name="polygonPatches", namespace="http://www.opengis.net/gml")
    private PolygonPatchesListType patchList;

    public PolyhedralSurfaceType() {
    }

    public PolyhedralSurfaceType(JTSPolyhedralSurface poly) {
        this.coordinateReferenceSystem = poly.getCoordinateReferenceSystem();
        this.patchList = new PolygonPatchesListType(poly.getPatches());
    }

    public List<JTSPolygon> getPatches() {
        ArrayList<JTSPolygon> result = new ArrayList<JTSPolygon>();
        for (SurfaceBoundary surfaceBoundary : this.patchList.getPatches()) {
            result.add(new JTSPolygon(surfaceBoundary));
        }
        return result;
    }

    public void setPatches(List<JTSPolygon> patches) {
        this.patchList.setPolygonPatches(patches);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public JTSPolyhedralSurface getIsoPolyHedralSurface() {
        JTSPolyhedralSurface result = new JTSPolyhedralSurface(this.coordinateReferenceSystem);
        for (JTSSurfaceBoundary s2 : this.patchList.getPatches()) {
            s2.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
            ((JTSRing)s2.getExterior()).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
            for (Primitive primitive : s2.getExterior().getElements()) {
                if (!(primitive instanceof JTSCurve)) continue;
                JTSCurve curve = (JTSCurve)primitive;
                curve.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                for (CurveSegment cv : curve.getSegments()) {
                    if (!(cv instanceof JTSLineString)) continue;
                    JTSLineString line = (JTSLineString)cv;
                    PointArray pa = line.getControlPoints();
                    ArrayList<Position> newPositions = new ArrayList<Position>();
                    for (Position pos : pa) {
                        if (!(pos instanceof GeneralDirectPosition)) continue;
                        ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                        newPositions.add(pos);
                    }
                    line.getControlPoints().clear();
                    line.getControlPoints().addAll(newPositions);
                }
            }
            if (s2.getInteriors() != null) {
                for (Ring ring : s2.getInteriors()) {
                    ((JTSRing)ring).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                    for (Primitive primitive : ring.getElements()) {
                        if (!(primitive instanceof JTSCurve)) continue;
                        JTSCurve curve = (JTSCurve)primitive;
                        curve.setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                        for (CurveSegment cv : curve.getSegments()) {
                            if (!(cv instanceof JTSLineString)) continue;
                            JTSLineString line = (JTSLineString)cv;
                            PointArray pa = line.getControlPoints();
                            ArrayList<Position> newPositions = new ArrayList<Position>();
                            for (Position pos : pa) {
                                if (!(pos instanceof GeneralDirectPosition)) continue;
                                ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.coordinateReferenceSystem);
                                newPositions.add(pos);
                            }
                            line.getControlPoints().clear();
                            line.getControlPoints().addAll(newPositions);
                        }
                    }
                }
            }
            result.getPatches().add(new JTSPolygon(s2));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[polyHedralSurfaceType]\n");
        if (this.coordinateReferenceSystem != null) {
            sb.append("crs:").append(this.coordinateReferenceSystem);
        }
        if (this.patchList != null) {
            sb.append("patchList:").append(this.patchList);
        }
        return sb.toString();
    }
}

