/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.resources.Loggings;

public class DefaultDataSource
implements DataSource {
    public static final Logger LOGGER = Logger.getLogger("org.geotoolkit.sql");
    private static final Set<String> DRIVERS = new HashSet<String>();
    public final String url;

    public DefaultDataSource(String url) {
        ArgumentChecks.ensureNonNull("url", url);
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection log(Connection connection, Class<?> source) throws SQLException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            boolean log;
            DatabaseMetaData metadata = connection.getMetaData();
            String name = metadata.getDriverName();
            Set<String> set = DRIVERS;
            synchronized (set) {
                log = DRIVERS.add(name);
            }
            if (log) {
                LogRecord record = Loggings.format(Level.CONFIG, (short)29, name, metadata.getDriverMajorVersion(), metadata.getDriverMinorVersion());
                record.setLoggerName(LOGGER.getName());
                record.setSourceClassName(source.getName());
                record.setSourceMethodName("getConnection");
                LOGGER.log(record);
            }
        }
        return connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DefaultDataSource.log(DriverManager.getConnection(this.url), DefaultDataSource.class);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DefaultDataSource.log(DriverManager.getConnection(this.url, username, password), DefaultDataSource.class);
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        DriverManager.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException();
    }

    public void shutdown() {
        Dialect dialect = Dialect.forURL(this.url);
        if (dialect != null) {
            try {
                dialect.shutdown(null, this.url, false);
            }
            catch (SQLException e) {
                Logging.unexpectedException(LOGGER, DefaultDataSource.class, "shutdown", e);
            }
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            DefaultDataSource that = (DefaultDataSource)other;
            return Objects.equals(this.url, that.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode() ^ 0x13FF13DB;
    }

    public String toString() {
        return Classes.getShortClassName(this) + "[\"" + this.url + "\"]";
    }

    @Override
    public Logger getParentLogger() {
        return LOGGER;
    }
}

