/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.nio.IOUtilities;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Dialect {
    ANSI(null, null, null),
    DERBY("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:", new String[]{"directory", "memory", "classpath", "jar"}){

        @Override
        public void shutdown(Connection connection, String databaseURL, boolean setReadOnly) throws SQLException {
            super.shutdown(connection, (String)databaseURL, setReadOnly);
            int p = ((String)databaseURL).indexOf(59);
            if (p >= 0) {
                databaseURL = ((String)databaseURL).substring(0, p);
            }
            databaseURL = (String)databaseURL + ";shutdown=true";
            try {
                DriverManager.getConnection((String)databaseURL).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
    ,
    HSQL("org.hsqldb.jdbcDriver", "jdbc:hsqldb:", new String[]{"file", "mem"}){

        @Override
        public int maxRowsPerInsert(DatabaseMetaData metadata) {
            return 1;
        }

        @Override
        public boolean supportsCommitStatement(DatabaseMetaData metadata) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(Connection connection, String databaseURL, boolean setReadOnly) throws SQLException {
            Path path;
            if (connection == null) {
                ArgumentChecks.ensureNonNull("databaseURL", databaseURL);
                connection = DefaultDataSource.log(DriverManager.getConnection(databaseURL), Dialect.class);
            }
            try (Statement stmt = connection.createStatement();){
                stmt.execute(setReadOnly ? "SHUTDOWN COMPACT" : "SHUTDOWN");
            }
            finally {
                connection.close();
            }
            if (setReadOnly && (path = this.getPath(databaseURL)) != null) {
                try {
                    String fileName = path.getFileName().toString();
                    Path propFile = path.resolveSibling(fileName + ".properties");
                    Properties properties = IOUtilities.getPropertiesFromFile(propFile);
                    if (!"true".equals(properties.put("readonly", "true"))) {
                        IOUtilities.storeProperties(properties, propFile, "HSQL database configuration");
                    }
                }
                catch (IOException e) {
                    throw new SQLNonTransientException(e);
                }
            }
        }
    }
    ,
    POSTGRESQL("org.postgresql.Driver", "jdbc:postgresql:", null){

        @Override
        public boolean supportsEnumType(DatabaseMetaData metadata) throws SQLException {
            int version = metadata.getDatabaseMajorVersion();
            return version == 8 ? metadata.getDatabaseMinorVersion() >= 4 : version >= 8;
        }

        @Override
        public boolean needsCreateLanguage(DatabaseMetaData metadata) throws SQLException {
            return metadata.getDatabaseMajorVersion() < 9;
        }
    }
    ,
    ORACLE("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:", null),
    ACCESS(null, null, null);

    private static final Dialect[] SPECIFIC;
    public final String driverClass;
    public final String protocol;
    private final String[] subProtocols;

    private Dialect(String driverClass, String protocol, String[] subProtocols) {
        this.driverClass = driverClass;
        this.protocol = protocol;
        this.subProtocols = subProtocols;
    }

    public static Dialect guess(DatabaseMetaData metadata) throws SQLException {
        String product = metadata.getDatabaseProductName();
        if (product != null) {
            product = product.trim().toUpperCase(Locale.US);
            for (Dialect candidate : SPECIFIC) {
                if (!product.contains(candidate.name())) continue;
                return candidate;
            }
        }
        return ANSI;
    }

    public static Dialect forURL(String databaseURL) {
        if (databaseURL != null) {
            for (Dialect candidate : SPECIFIC) {
                String baseURL = candidate.protocol;
                if (baseURL == null || !databaseURL.regionMatches(true, 0, baseURL, 0, baseURL.length())) continue;
                return candidate;
            }
        }
        return null;
    }

    public final String createURL(Path path) throws SQLException {
        if (this.subProtocols == null) {
            throw new SQLException();
        }
        StringBuilder url = new StringBuilder(this.protocol).append(this.subProtocols[0]).append(':');
        String p = path.toAbsolutePath().toString().replace(File.separatorChar, '/');
        if (!p.startsWith("/")) {
            url.append('/');
        }
        return url.append(p).toString();
    }

    public final Path getPath(String databaseURL) {
        int offset = this.protocol.length();
        if (databaseURL != null && databaseURL.regionMatches(true, 0, this.protocol, 0, offset)) {
            int s2;
            if (this.subProtocols != null && (s2 = databaseURL.indexOf(58, offset)) >= 0) {
                String p = databaseURL.substring(offset, s2);
                for (int i = 0; i < this.subProtocols.length; ++i) {
                    if (!p.equalsIgnoreCase(this.subProtocols[i])) continue;
                    if (i != 0) {
                        return null;
                    }
                    offset = s2 + 1;
                }
            }
            return Paths.get(databaseURL.substring(offset), new String[0]);
        }
        return null;
    }

    public final boolean isDriverRegistered() {
        if (this.driverClass != null) {
            int stop = this.driverClass.lastIndexOf(46) + 1;
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver drv = drivers.nextElement();
                if (!drv.getClass().getName().regionMatches(0, this.driverClass, 0, stop)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsEnumType(DatabaseMetaData metadata) throws SQLException {
        return false;
    }

    public boolean supportsCommitStatement(DatabaseMetaData metadata) throws SQLException {
        return false;
    }

    public int maxRowsPerInsert(DatabaseMetaData metadata) throws SQLException {
        return 100;
    }

    public boolean needsCreateLanguage(DatabaseMetaData metadata) throws SQLException {
        return false;
    }

    public void shutdown(Connection connection, String databaseURL, boolean setReadOnly) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    static {
        SPECIFIC = ArraysExt.remove(Dialect.values(), ANSI.ordinal(), 1);
    }
}

