/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    private final String[] ends;
    private final String desc;
    private final boolean allowFolder;

    public SimpleFileFilter(String name, boolean allowFolder, String[] ends) {
        this.ends = ends;
        this.allowFolder = allowFolder;
        StringBuilder buff = new StringBuilder();
        buff.append(name);
        buff.append(" (");
        buff.append("*.").append(ends[0]);
        for (int i = 1; i < ends.length; ++i) {
            buff.append(",*.").append(ends[i]);
        }
        buff.append(')');
        this.desc = buff.toString();
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public boolean allowFolderSelection() {
        return this.allowFolder;
    }

    @Override
    public boolean accept(File pathname) {
        String nom = pathname.getName();
        if (pathname.isDirectory()) {
            return true;
        }
        int n = this.ends.length;
        for (int i = 0; i < n; ++i) {
            if (!nom.toLowerCase().endsWith(this.ends[i])) continue;
            return true;
        }
        return false;
    }
}

