/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.lang;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.logging.MonolineFormatter;
import org.geotoolkit.internal.SetupService;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.internal.sql.AuthenticatedDataSource;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.lang.Static;

public final class Setup
extends Static {
    private static int state;
    private static DataSource EPSG;

    private Setup() {
    }

    public static synchronized void setEPSG(DataSource source) {
        EPSG = source;
    }

    public static synchronized DataSource getEPSG() {
        if (EPSG == null) {
            try {
                String url;
                Properties properties = Installation.EPSG.getDataSource();
                if (properties != null && (url = properties.getProperty("URL")) != null) {
                    EPSG = new DefaultDataSource(url);
                    String user = properties.getProperty("user");
                    if (user != null) {
                        EPSG = new AuthenticatedDataSource(EPSG, user, properties.getProperty("password"), false);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return EPSG;
    }

    private static String get(Properties properties, String key, String def) {
        return properties != null ? properties.getProperty(key, def) : def;
    }

    public static synchronized void initialize(Properties properties) throws IllegalStateException {
        boolean reinit;
        if (state == 1) {
            return;
        }
        boolean bl = reinit = state == 2;
        if (reinit && !Boolean.parseBoolean(Setup.get(properties, "force", "false"))) {
            throw new IllegalStateException();
        }
        state = 1;
        if (!"server".equalsIgnoreCase(Setup.get(properties, "platform", "desktop"))) {
            MonolineFormatter.install();
        }
        Initializer.setDefault(Setup::getEPSG);
        if (reinit) {
            DefaultFactories.fireClasspathChanged();
        }
        for (SetupService service : ServiceLoader.load(SetupService.class)) {
            service.initialize(properties, reinit);
        }
    }

    public static synchronized void shutdown() {
        if (state != 2) {
            state = 2;
            Initializer.setDefault(null);
            for (SetupService service : ServiceLoader.load(SetupService.class)) {
                service.shutdown();
            }
            Threads.shutdown();
        }
    }
}

