/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.Containers;
import org.geotoolkit.metadata.FactoryMethod;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.util.FactoryException;

public class MetadataFactory {
    private final Object[] factories;
    private final MetadataStandard[] standards;
    private final Map<Class<?>, FactoryMethod> factoryMethods;

    public MetadataFactory() {
        this(MetadataFactory.factories(), MetadataStandard.ISO_19115);
    }

    public MetadataFactory(MetadataStandard ... standards) {
        this(MetadataFactory.factories(), standards);
    }

    public MetadataFactory(Set<?> factories, MetadataStandard ... standards) {
        if (!Containers.isNullOrEmpty(factories)) {
            this.factories = factories.toArray();
            this.factoryMethods = new HashMap();
        } else {
            this.factories = null;
            this.factoryMethods = null;
        }
        this.standards = (MetadataStandard[])standards.clone();
    }

    private static Set<?> factories() {
        LinkedHashSet<ObjectFactory> factories = new LinkedHashSet<ObjectFactory>();
        int i = 0;
        while (true) {
            ObjectFactory factory;
            switch (i) {
                case 0: {
                    factory = DefaultFactories.forBuildin(DatumFactory.class);
                    break;
                }
                case 1: {
                    factory = DefaultFactories.forBuildin(CSFactory.class);
                    break;
                }
                case 2: {
                    factory = DefaultFactories.forBuildin(CRSFactory.class);
                    break;
                }
                default: {
                    return factories;
                }
            }
            factories.add(factory);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> T create(Class<T> type, Map<String, ?> properties) throws FactoryException {
        MetadataStandard[] metadataStandardArray;
        if (this.factoryMethods != null) {
            metadataStandardArray = this.factoryMethods;
            // MONITORENTER : this.factoryMethods
            FactoryMethod method = this.factoryMethods.get(type);
            if (method == null) {
                method = FactoryMethod.find(type, this.factories);
                if (method == null) {
                    method = FactoryMethod.NULL;
                } else {
                    for (FactoryMethod existing : this.factoryMethods.values()) {
                        if (!method.equals(existing)) continue;
                        method = existing;
                        break;
                    }
                }
                this.factoryMethods.put(type, method);
            }
            // MONITOREXIT : metadataStandardArray
            Object metadata = method.create(properties);
            if (metadata != null) {
                return type.cast(metadata);
            }
        }
        ReflectiveOperationException failure = null;
        metadataStandardArray = this.standards;
        int n = metadataStandardArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                MetadataStandard standard = metadataStandardArray[n2];
                if (standard.isMetadata(type)) {
                    T metadata;
                    Class<T> impl = standard.getImplementation(type);
                    if (impl == null) {
                        impl = type;
                    }
                    try {
                        metadata = impl.newInstance();
                    }
                    catch (ReflectiveOperationException e) {
                        if (failure == null) {
                            failure = e;
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        throw new FactoryException(e.getLocalizedMessage(), e);
                    }
                    Map<String, Object> asMap = standard.asValueMap(metadata, null, KeyNamePolicy.JAVABEANS_PROPERTY, ValueExistencePolicy.NON_EMPTY);
                    try {
                        asMap.putAll(properties);
                        return type.cast(metadata);
                    }
                    catch (RuntimeException e) {
                        throw new FactoryException(e.getLocalizedMessage(), e);
                    }
                }
            }
            ++n2;
        }
        throw new FactoryException(Errors.format((short)191, type), failure);
    }
}

