/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.cs.Axes;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.util.InternationalString;

public final class PredefinedCS
extends Static {
    public static final DefaultCartesianCS PROJECTED = new DefaultCartesianCS((Map<String, ?>)PredefinedCS.name(209), (CoordinateSystemAxis)Axes.EASTING, (CoordinateSystemAxis)Axes.NORTHING);
    public static final DefaultCartesianCS CARTESIAN_2D = new DefaultCartesianCS((Map<String, ?>)PredefinedCS.name(20), (CoordinateSystemAxis)Axes.X, (CoordinateSystemAxis)Axes.Y);
    public static final DefaultCartesianCS CARTESIAN_3D = new DefaultCartesianCS((Map<String, ?>)PredefinedCS.name(21), (CoordinateSystemAxis)Axes.X, (CoordinateSystemAxis)Axes.Y, (CoordinateSystemAxis)Axes.Z);
    public static final DefaultCartesianCS GRID = new DefaultCartesianCS((Map<String, ?>)PredefinedCS.name(115), (CoordinateSystemAxis)Axes.COLUMN, (CoordinateSystemAxis)Axes.ROW);

    private PredefinedCS() {
    }

    private static Map<String, Object> name(int key) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", name.toString());
        properties.put("alias", name);
        return properties;
    }

    private static void ensureDimensionMatch(CoordinateSystem cs, String name, double[] coordinates) throws MismatchedDimensionException {
        int dimension = cs.getDimension();
        if (coordinates.length != dimension) {
            throw new MismatchedDimensionException(Errors.format((short)95, name, coordinates.length, dimension));
        }
    }

    private static DefaultCartesianCS createCartesian(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        switch (axis.length) {
            case 2: {
                return new DefaultCartesianCS(properties, axis[0], axis[1]);
            }
            case 3: {
                return new DefaultCartesianCS(properties, axis[0], axis[1], axis[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    private static DefaultEllipsoidalCS createEllipsoidal(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        switch (axis.length) {
            case 2: {
                return new DefaultEllipsoidalCS(properties, axis[0], axis[1]);
            }
            case 3: {
                return new DefaultEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Quantity<?> distance(CoordinateSystem cs, double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (cs instanceof CartesianCS) {
            return PredefinedCS.distance((CartesianCS)cs, coord1, coord2);
        }
        PredefinedCS.ensureDimensionMatch(cs, "coord1", coord1);
        PredefinedCS.ensureDimensionMatch(cs, "coord2", coord2);
        if (cs.getDimension() == 1) {
            return Quantities.create(Math.abs(coord1[0] - coord2[0]), cs.getAxis(0).getUnit());
        }
        throw new UnsupportedOperationException(Errors.format((short)201, cs.getClass()));
    }

    private static Quantity<?> distance(CartesianCS cs, double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        PredefinedCS.ensureDimensionMatch(cs, "coord1", coord1);
        PredefinedCS.ensureDimensionMatch(cs, "coord2", coord2);
        Unit<?> unit = PredefinedCS.getDistanceUnit(cs);
        UnitConverter[] converters = new UnitConverter[cs.getDimension()];
        for (int i = 0; i < converters.length; ++i) {
            Unit<?> axisUnit = cs.getAxis(i).getUnit();
            try {
                converters[i] = axisUnit.getConverterToAny(unit);
                continue;
            }
            catch (IncommensurableException e) {
                throw new UnsupportedOperationException(Errors.format((short)77, axisUnit), e);
            }
        }
        double[] delta = new double[converters.length];
        for (int i = 0; i < converters.length; ++i) {
            UnitConverter c = converters[i];
            delta[i] = c.convert(coord1[i]) - c.convert(coord2[i]);
        }
        return Quantities.create(MathFunctions.magnitude(delta), unit);
    }

    private static Unit<?> getDistanceUnit(CoordinateSystem cs) {
        Unit<?> unit = null;
        double maxScale = 0.0;
        int i = cs.getDimension();
        while (--i >= 0) {
            double scale;
            Unit<?> candidate = cs.getAxis(i).getUnit();
            if (candidate == null || !((scale = Math.abs(Units.toStandardUnit(candidate))) > maxScale)) continue;
            unit = candidate;
            maxScale = scale;
        }
        return unit;
    }

    private static CoordinateSystemAxis[] axisUsingUnit(CoordinateSystem cs, Unit<?> unit, Unit<?> ignore) throws IncommensurableException {
        int dimension = cs.getDimension();
        CoordinateSystemAxis[] newAxis = null;
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis converted;
            CoordinateSystemAxis a = cs.getAxis(i);
            Unit<?> current = a.getUnit();
            if (unit.equals(current) || ignore != null && ignore.equals(unit.getSystemUnit()) || (converted = Axes.usingUnit(a, unit)) == a) continue;
            if (newAxis == null) {
                newAxis = new CoordinateSystemAxis[dimension];
                for (int j = 0; j < i; ++j) {
                    newAxis[j] = cs.getAxis(j);
                }
            }
            newAxis[i] = converted;
        }
        return newAxis;
    }

    public static CartesianCS usingUnit(CartesianCS cs, Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] axes;
        try {
            axes = PredefinedCS.axisUsingUnit(cs, unit, null);
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
        if (axes == null) {
            return cs;
        }
        return PredefinedCS.createCartesian(PredefinedCS.getProperties(cs, null), axes);
    }

    public static EllipsoidalCS usingUnit(EllipsoidalCS cs, Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] axes;
        try {
            axes = PredefinedCS.axisUsingUnit(cs, unit, Units.isLinear(unit) ? Units.RADIAN : Units.METRE);
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
        if (axes == null) {
            return cs;
        }
        return PredefinedCS.createEllipsoidal(PredefinedCS.getProperties(cs, null), axes);
    }

    @Deprecated
    static Map<String, Object> getProperties(IdentifiedObject info, Citation authority) {
        HashMap<String, Object> properties = new HashMap<String, Object>(IdentifiedObjects.getProperties(info, new String[0]));
        properties.put("name", new NamedIdentifier(authority, info.getName().getCode()));
        properties.remove("identifiers");
        return properties;
    }
}

