/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.util.Map;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.geotoolkit.math.Complex;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class NewZealandMapGrid
extends UnitaryProjection {
    private static final long serialVersionUID = 8394817836243729133L;
    private static final Complex[] A = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final Complex[] B = new Complex[]{new Complex(1.3231270439, 0.0), new Complex(-0.577245789, -0.007809598), new Complex(0.508307513, -0.112208952), new Complex(-0.15094762, 0.18200602), new Complex(1.01418179, 1.64497696), new Complex(1.9660549, 2.5127645)};
    private static final double[] TPHI = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] TPSI = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};

    public static MathTransform2D create(OperationMethod descriptor, ParameterValueGroup values) {
        Parameters parameters = Parameters.castOrWrap(values);
        NewZealandMapGrid projection = new NewZealandMapGrid(descriptor, parameters);
        try {
            return (MathTransform2D)projection.createMapProjection(DefaultFactories.forBuildin(MathTransformFactory.class));
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected NewZealandMapGrid(OperationMethod method, Parameters parameters) {
        super(method, parameters, (Map<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>)null);
        MatrixSIS normalize = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.convertBefore(1, 2.0626480624709633, null);
        normalize.convertBefore(1, null, -this.getAndStore(parameters, org.geotoolkit.referencing.operation.provider.NewZealandMapGrid.LATITUDE_OF_ORIGIN));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        if (dstPts != null) {
            double dphi;
            double dphi_pow_i = dphi = srcPts[srcOff + 1];
            double dpsi = 0.0;
            for (int i = 0; i < TPSI.length; ++i) {
                dpsi += TPSI[i] * dphi_pow_i;
                dphi_pow_i *= dphi;
            }
            Complex theta = new Complex(dpsi, srcPts[srcOff]);
            Complex power = new Complex(theta);
            Complex z = new Complex();
            z.multiply(A[0], power);
            for (int i = 1; i < A.length; ++i) {
                power.multiply(power, theta);
                z.addMultiply(z, A[i], power);
            }
            dstPts[dstOff] = z.imag;
            dstPts[dstOff + 1] = z.real;
        }
        if (derivate) {
            throw new ProjectionException(Errors.format((short)5));
        }
        return null;
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double dpsi;
        Complex z = new Complex(srcPts[srcOff + 1], srcPts[srcOff]);
        Complex power = new Complex(z);
        Complex theta = new Complex();
        theta.multiply(B[0], z);
        for (int j = 1; j < B.length; ++j) {
            power.multiply(power, z);
            theta.addMultiply(theta, B[j], power);
        }
        Complex num = new Complex();
        Complex denom = new Complex();
        Complex t2 = new Complex();
        for (int j = 0; j < 3; ++j) {
            int k;
            power.power(theta, 2);
            num.addMultiply(z, A[1], power);
            for (k = 2; k < A.length; ++k) {
                power.multiply(power, theta);
                t2.multiply(A[k], power);
                t2.multiply(t2, k);
                num.add(num, t2);
            }
            power.real = 1.0;
            power.imag = 0.0;
            denom.copy(A[0]);
            for (k = 1; k < A.length; ++k) {
                power.multiply(power, theta);
                t2.multiply(A[k], power);
                t2.multiply(t2, k + 1);
                denom.add(denom, t2);
            }
            theta.divide(num, denom);
        }
        double dpsi_pow_i = dpsi = theta.real;
        double dphi = TPHI[0] * dpsi;
        for (int i = 1; i < TPHI.length; ++i) {
            dphi += TPHI[i] * (dpsi_pow_i *= dpsi);
        }
        dstPts[dstOff] = theta.imag;
        dstPts[dstOff + 1] = dphi;
    }
}

