/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.referencing.operation.transform.EarthGravitationalModel;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class EllipsoidToGeoid
extends MathTransformProvider {
    private static final long serialVersionUID = 914369333205211248L;
    public static final ParameterDescriptor<String> DATUM;
    public static final ParameterDescriptor<Integer> ORDER;
    public static final ParameterDescriptorGroup PARAMETERS;

    public EllipsoidToGeoid() {
        super(3, 3, PARAMETERS);
    }

    public Class<? extends Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        GeodeticDatum datum;
        String name = Parameters.castOrWrap(values).getValue(DATUM);
        if ("WGS84".equalsIgnoreCase(name)) {
            datum = CommonCRS.WGS84.datum();
        } else if ("WGS72".equalsIgnoreCase(name)) {
            datum = CommonCRS.WGS72.datum();
        } else {
            throw new IllegalArgumentException(Errors.format((short)205, name));
        }
        Integer order = Parameters.castOrWrap(values).getValue(ORDER);
        int nmax = order != null ? order : 180;
        return EarthGravitationalModel.create(datum, nmax);
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        ORDER = ((ParameterBuilder)builder.addName(Vocabulary.formatInternational(189))).createBounded(2, 180, 180);
        builder.setRequired(true);
        DATUM = ((ParameterBuilder)builder.addName(Vocabulary.formatInternational(54))).createEnumerated(String.class, new String[]{"WGS84", "WGS72"}, "WGS84");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(null, "Ellipsoid_To_Geoid")}, null, new ParameterDescriptor[]{DATUM, ORDER}, 0);
    }
}

