/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Containers;
import org.geotoolkit.internal.referencing.DeprecatedName;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.referencing.operation.provider.MapProjectionDescriptor;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;

@Deprecated
public final class UniversalParameters
extends DefaultParameterDescriptor<Double> {
    private static final long serialVersionUID = -4608976443553166518L;
    public static final UniversalParameters SEMI_MAJOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "Semi-major axis"), new NamedIdentifier(Citations.ESRI, "Semi_Major"), new NamedIdentifier(Citations.NETCDF, "semi_major_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMajor"), new NamedIdentifier(Citations.PROJ4, "a")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, Units.METRE, true);
    public static final UniversalParameters SEMI_MINOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "Semi-minor axis"), new NamedIdentifier(Citations.ESRI, "Semi_Minor"), new NamedIdentifier(Citations.NETCDF, "semi_minor_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMinor"), new NamedIdentifier(Citations.PROJ4, "b")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, Units.METRE, true);
    static final ParameterDescriptor<Double> EARTH_RADIUS = UniversalParameters.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.NETCDF, "earth_radius")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, Units.METRE, false);
    static final ParameterDescriptor<Double> INVERSE_FLATTENING = UniversalParameters.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.NETCDF, "inverse_flattening")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, Units.UNITY, false);
    public static final UniversalParameters CENTRAL_MERIDIAN = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "central_meridian"), new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.EPSG, "Longitude of origin"), new NamedIdentifier(Citations.EPSG, "Longitude of false origin"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical longitude of origin"), new NamedIdentifier(Citations.EPSG, "Longitude of projection centre"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(Citations.NETCDF, "longitude_of_projection_origin"), new NamedIdentifier(Citations.NETCDF, "longitude_of_central_meridian"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLong"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginLong"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLong"), new NamedIdentifier(Citations.GEOTIFF, "CenterLong"), new NamedIdentifier(Citations.GEOTIFF, "StraightVertPoleLong"), new NamedIdentifier(Citations.PROJ4, "lon_0")}, 0.0, -180.0, 180.0, Units.DEGREE, true);
    public static final UniversalParameters LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<double[]> STANDARD_PARALLEL;
    public static final UniversalParameters STANDARD_PARALLEL_1;
    public static final UniversalParameters STANDARD_PARALLEL_2;
    public static final UniversalParameters LAT_OF_1ST_POINT;
    public static final UniversalParameters LONG_OF_1ST_POINT;
    public static final UniversalParameters LAT_OF_2ND_POINT;
    public static final UniversalParameters LONG_OF_2ND_POINT;
    public static final UniversalParameters AZIMUTH;
    public static final UniversalParameters RECTIFIED_GRID_ANGLE;
    public static final UniversalParameters SCALE_FACTOR;
    public static final UniversalParameters X_SCALE;
    public static final UniversalParameters Y_SCALE;
    public static final UniversalParameters FALSE_EASTING;
    public static final UniversalParameters FALSE_NORTHING;
    private final NamedIdentifier[] identifiers;
    private final Map<String, NamedIdentifier> identifiersMap;

    private UniversalParameters(NamedIdentifier[] identifiers, double defaultValue, double minimum, double maximum, Unit<?> unit, boolean required) {
        super(UniversalParameters.toMap(identifiers), Double.class, null, Double.isNaN(defaultValue) ? null : Double.valueOf(defaultValue), minimum == Double.NEGATIVE_INFINITY ? null : Double.valueOf(minimum), maximum == Double.POSITIVE_INFINITY ? null : Double.valueOf(maximum), unit, required);
        this.identifiers = identifiers;
        this.identifiersMap = new HashMap<String, NamedIdentifier>(Containers.hashMapCapacity(identifiers.length));
        IdentityHashMap<NamedIdentifier, NamedIdentifier> nextSameName = null;
        int i = identifiers.length;
        while (--i >= 0) {
            NamedIdentifier id = identifiers[i];
            NamedIdentifier old = this.identifiersMap.put(id.getCode(), id);
            if (old == null) continue;
            if (nextSameName == null) {
                nextSameName = new IdentityHashMap<NamedIdentifier, NamedIdentifier>(4);
            }
            nextSameName.put(id, old);
        }
    }

    final ParameterDescriptor<Double> select(Citation[] excludes, String ... names) {
        return this.select(this.getMinimumOccurs() != 0, (Double)this.getDefaultValue(), excludes, null, names);
    }

    final ParameterDescriptor<Double> select(Boolean required, Double defaultValue, Citation[] excludes, String[] deprecated, String ... names) {
        HashMap<Citation, Boolean> authorities = new HashMap<Citation, Boolean>();
        Identifier[] selected = new NamedIdentifier[this.identifiers.length];
        long usedIdent = 0L;
        long usedNames = 0L;
        int included = 0;
        for (NamedIdentifier candidate : this.identifiers) {
            Citation authority = candidate.getAuthority();
            if (ArraysExt.contains(excludes, authority)) continue;
            selected[included] = candidate;
            String code = candidate.getCode();
            int j = names.length;
            while (--j >= 0) {
                if (!code.equals(names[j])) continue;
                if (authorities.put(authority, Boolean.TRUE) != null) {
                    throw new IllegalArgumentException(Errors.format((short)211, authority));
                }
                usedNames |= (long)(1 << j);
                usedIdent |= (long)(1 << included);
                break;
            }
            ++included;
        }
        if (usedNames != (long)((1 << names.length) - 1)) {
            throw new IllegalArgumentException(Errors.format((short)189, names[Long.numberOfTrailingZeros(usedNames ^ 0xFFFFFFFFFFFFFFFFL)]));
        }
        int n = 0;
        for (int i = 0; i < included; ++i) {
            Citation authority;
            Boolean explicit;
            NamedIdentifier candidate = selected[i];
            if ((usedIdent & (long)(1 << i)) == 0L && (explicit = authorities.put(authority = candidate.getAuthority(), Boolean.FALSE)) != null) {
                if (explicit.booleanValue()) {
                    authorities.put(authority, Boolean.TRUE);
                    continue;
                }
                throw new IllegalStateException(String.valueOf(candidate));
            }
            selected[n++] = candidate;
        }
        if (deprecated != null) {
            selected = ArraysExt.resize(selected, n + deprecated.length);
            for (String code : deprecated) {
                selected[n++] = new DeprecatedName(this.identifiersMap.get(code));
            }
        }
        selected = ArraysExt.resize(selected, n);
        return new DefaultParameterDescriptor<Double>(UniversalParameters.toMap(selected), Double.class, null, defaultValue != null ? defaultValue : (Double)this.getDefaultValue(), this.getMinimumValue(), this.getMaximumValue(), this.getUnit(), required != null ? required : this.getMinimumOccurs() != 0);
    }

    private static ParameterDescriptor<Double> createDescriptor(Identifier[] identifiers, double defaultValue, double minimum, double maximum, Unit<?> unit, boolean required) {
        return new DefaultParameterDescriptor<Double>(UniversalParameters.toMap(identifiers), Double.class, null, Double.isNaN(defaultValue) ? null : Double.valueOf(defaultValue), minimum == Double.NEGATIVE_INFINITY ? null : Double.valueOf(minimum), maximum == Double.POSITIVE_INFINITY ? null : Double.valueOf(maximum), unit, required);
    }

    static ParameterDescriptorGroup createDescriptorGroup(Identifier[] identifiers, Citation[] excludes, ParameterDescriptor<?>[] parameters, int supplement) {
        Map<String, Object> properties;
        if (excludes != null) {
            properties = new HashMap<String, Object>();
            for (int i = 0; i < parameters.length; ++i) {
                Object[] aliases;
                ParameterDescriptor<?> param = parameters[i];
                if (param.getValueClass() != Double.class) continue;
                properties.putAll(IdentifiedObjects.getProperties(param, new String[0]));
                boolean forAlias = false;
                boolean modified = false;
                do {
                    String key;
                    if ((aliases = (Object[])properties.get(key = forAlias ? "alias" : "identifiers")) == null) continue;
                    int n = 0;
                    for (Object alias : aliases) {
                        if (alias instanceof Identifier && ArraysExt.contains(excludes, ((Identifier)alias).getAuthority())) continue;
                        aliases[n++] = alias;
                    }
                    if (n == aliases.length) continue;
                    properties.put(key, Arrays.copyOf(aliases, n));
                    modified = true;
                } while (forAlias = !forAlias);
                if (modified) {
                    properties.put("name", aliases[0]);
                    parameters[i] = new DefaultParameterDescriptor<Double>(properties, Double.class, null, (Double)param.getDefaultValue(), param.getMinimumValue(), param.getMaximumValue(), param.getUnit(), param.getMinimumOccurs() != 0);
                }
                properties.clear();
            }
        }
        properties = UniversalParameters.toMap(identifiers);
        return supplement == 0 ? new DefaultParameterDescriptorGroup(properties, 1, 1, parameters) : new MapProjectionDescriptor(properties, parameters, supplement);
    }

    private static Map<String, Object> toMap(Identifier[] identifiers) {
        int idCount = 0;
        int aliasCount = 0;
        GenericName[] alias = null;
        Identifier[] id = null;
        for (int i = 0; i < identifiers.length; ++i) {
            Identifier candidate = identifiers[i];
            if (candidate instanceof GenericName) {
                if (alias == null) {
                    alias = new GenericName[identifiers.length - i];
                }
                alias[aliasCount++] = (GenericName)((Object)candidate);
                continue;
            }
            if (id == null) {
                id = new Identifier[identifiers.length - i];
            }
            id[idCount++] = candidate;
        }
        id = (Identifier[])ArraysExt.resize(id, idCount);
        alias = (GenericName[])ArraysExt.resize(alias, aliasCount);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", identifiers[0]);
        properties.put("identifiers", id);
        properties.put("alias", alias);
        return properties;
    }

    static {
        NamedIdentifier esri = new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1");
        NamedIdentifier epsg = new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel");
        NamedIdentifier nc = new NamedIdentifier(Citations.NETCDF, "standard_parallel");
        LATITUDE_OF_ORIGIN = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.EPSG, "Latitude of false origin"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical latitude of origin"), new NamedIdentifier(Citations.EPSG, "Latitude of projection centre"), epsg, new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), esri, new NamedIdentifier(Citations.NETCDF, "latitude_of_projection_origin"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLat"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginLat"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLat"), new NamedIdentifier(Citations.GEOTIFF, "CenterLat"), new NamedIdentifier(Citations.PROJ4, "lat_0")}, 0.0, -90.0, 90.0, Units.DEGREE, true);
        STANDARD_PARALLEL = new DefaultParameterDescriptor<Object>(Collections.singletonMap("name", nc), double[].class, null, null, null, null, Units.DEGREE, false);
        STANDARD_PARALLEL_1 = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.OGC, "pseudo_standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of standard parallel"), epsg, new NamedIdentifier(Citations.EPSG, "Latitude of pseudo standard parallel"), new NamedIdentifier(Citations.ESRI, "Pseudo_Standard_Parallel_1"), esri, new NamedIdentifier(Citations.NETCDF, "standard_parallel[1]"), nc, new NamedIdentifier(Citations.GEOTIFF, "StdParallel1"), new NamedIdentifier(Citations.PROJ4, "lat_1")}, Double.NaN, -90.0, 90.0, Units.DEGREE, false);
        STANDARD_PARALLEL_2 = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_2"), new NamedIdentifier(Citations.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_2"), new NamedIdentifier(Citations.NETCDF, "standard_parallel[2]"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel2"), new NamedIdentifier(Citations.PROJ4, "lat_2")}, Double.NaN, -90.0, 90.0, Units.DEGREE, false);
        LAT_OF_1ST_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_1st_Point")}, Double.NaN, -90.0, 90.0, Units.DEGREE, true);
        LONG_OF_1ST_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_1st_Point")}, Double.NaN, -180.0, 180.0, Units.DEGREE, true);
        LAT_OF_2ND_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_2nd_Point")}, Double.NaN, -90.0, 90.0, Units.DEGREE, true);
        LONG_OF_2ND_POINT = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_2nd_Point")}, Double.NaN, -180.0, 180.0, Units.DEGREE, true);
        AZIMUTH = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "azimuth"), new NamedIdentifier(Citations.EPSG, "Azimuth of initial line"), new NamedIdentifier(Citations.EPSG, "Co-latitude of cone axis"), new NamedIdentifier(Citations.ESRI, "Azimuth"), new NamedIdentifier(Citations.GEOTIFF, "AzimuthAngle")}, Double.NaN, -360.0, 360.0, Units.DEGREE, true);
        RECTIFIED_GRID_ANGLE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "rectified_grid_angle"), new NamedIdentifier(Citations.EPSG, "Angle from Rectified to Skew Grid"), new NamedIdentifier(Citations.ESRI, "XY_Plane_Rotation"), new NamedIdentifier(Citations.GEOTIFF, "RectifiedGridAngle")}, Double.NaN, -360.0, 360.0, Units.DEGREE, false);
        SCALE_FACTOR = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier(Citations.EPSG, "Scale factor at natural origin"), new NamedIdentifier(Citations.EPSG, "Scale factor on initial line"), new NamedIdentifier(Citations.EPSG, "Scale factor on pseudo standard parallel"), new NamedIdentifier(Citations.ESRI, "Scale_Factor"), new NamedIdentifier(Citations.NETCDF, "scale_factor_at_projection_origin"), new NamedIdentifier(Citations.NETCDF, "scale_factor_at_central_meridian"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter"), new NamedIdentifier(Citations.PROJ4, "k")}, 1.0, 0.0, Double.POSITIVE_INFINITY, Units.UNITY, true);
        X_SCALE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "X_Scale")}, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.UNITY, false);
        Y_SCALE = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Y_Scale")}, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.UNITY, false);
        FALSE_EASTING = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_easting"), new NamedIdentifier(Citations.EPSG, "False easting"), new NamedIdentifier(Citations.EPSG, "Easting at false origin"), new NamedIdentifier(Citations.EPSG, "Easting at projection centre"), new NamedIdentifier(Citations.ESRI, "False_Easting"), new NamedIdentifier(Citations.NETCDF, "false_easting"), new NamedIdentifier(Citations.GEOTIFF, "FalseEasting"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginEasting"), new NamedIdentifier(Citations.PROJ4, "x_0")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.METRE, true);
        FALSE_NORTHING = new UniversalParameters(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_northing"), new NamedIdentifier(Citations.EPSG, "False northing"), new NamedIdentifier(Citations.EPSG, "Northing at false origin"), new NamedIdentifier(Citations.EPSG, "Northing at projection centre"), new NamedIdentifier(Citations.ESRI, "False_Northing"), new NamedIdentifier(Citations.NETCDF, "false_northing"), new NamedIdentifier(Citations.GEOTIFF, "FalseNorthing"), new NamedIdentifier(Citations.GEOTIFF, "FalseOriginNorthing"), new NamedIdentifier(Citations.PROJ4, "y_0")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.METRE, true);
    }
}

