/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.object.DefaultDuration;
import org.geotoolkit.temporal.object.DefaultPeriodDuration;
import org.geotoolkit.temporal.object.DefaultTemporalGeometricPrimitive;
import org.opengis.temporal.Duration;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;

@XmlType(name="TimePeriod_Type", propOrder={"beginning", "ending", "duration"})
@XmlRootElement(name="TimePeriod")
public class DefaultPeriod
extends DefaultTemporalGeometricPrimitive
implements Period {
    private Instant begining;
    private Instant ending;

    private DefaultPeriod() {
    }

    public DefaultPeriod(Map<String, ?> properties, Instant begining, Instant ending) {
        super(properties);
        ArgumentChecks.ensureNonNull("begining", begining);
        ArgumentChecks.ensureNonNull("ending", ending);
        if (begining == null || !RelativePosition.BEFORE.equals(begining.relativePosition(ending)) && !RelativePosition.EQUALS.equals(begining.relativePosition(ending))) {
            throw new IllegalArgumentException("begining must be before or equals ending");
        }
        this.begining = begining;
        this.ending = ending;
    }

    private DefaultPeriod(Period object) {
        super(object);
        if (object != null) {
            this.begining = object.getBeginning();
            this.ending = object.getEnding();
            if (object instanceof DefaultPeriod) {
                // empty if block
            }
        }
    }

    public static DefaultPeriod castOrCopy(Period object) {
        if (object == null || object instanceof DefaultPeriod) {
            return (DefaultPeriod)object;
        }
        return new DefaultPeriod(object);
    }

    @Override
    @XmlElement(name="begin", required=true)
    public Instant getBeginning() {
        return this.begining;
    }

    public void setBegining(Instant begining) {
        this.begining = begining;
    }

    @Override
    @XmlElement(name="end", required=true)
    public Instant getEnding() {
        return this.ending;
    }

    @XmlElement(name="duration")
    private String getDuration() {
        Duration dur = super.length();
        if (dur != null && dur instanceof DefaultDuration) {
            DefaultPeriodDuration defPerDur = dur instanceof DefaultPeriodDuration ? (DefaultPeriodDuration)dur : new DefaultPeriodDuration(((DefaultDuration)dur).getTimeInMillis());
            return defPerDur.toString();
        }
        return null;
    }

    public void setEnding(Instant ending) {
        this.ending = ending;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comp) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriod) {
            DefaultPeriod that = (DefaultPeriod)object;
            return Objects.equals(this.begining, that.begining) && Objects.equals(this.ending, that.ending);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        int hash = 5;
        hash = 37 * hash + (this.begining != null ? this.begining.hashCode() : 0);
        hash = 37 * hash + (this.ending != null ? this.ending.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder("Period:").append('\n');
        if (this.begining != null) {
            s2.append("begin:").append(this.begining).append('\n');
        }
        if (this.ending != null) {
            s2.append("end:").append(this.ending).append('\n');
        }
        return s2.toString();
    }
}

