/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.sis.util.ArgumentChecks;

public class CollectorsExt {
    public static <ValueType, HiddenType, ResultType> Collector<ValueType, ?, ResultType> buffering(int maxBatchSize, Collector<? super List<ValueType>, HiddenType, ? extends ResultType> batchCollector) {
        return CollectorsExt.buffering(maxBatchSize, maxBatchSize, ArrayList::new, batchCollector);
    }

    public static <ValueType, BatchType extends Collection<ValueType>, HiddenType, ResultType> Collector<ValueType, ?, ResultType> buffering(int initBufferSize, int maxBatchSize, IntFunction<BatchType> bufferSupplier, Collector<? super BatchType, HiddenType, ? extends ResultType> batchCollector) {
        return new BufferingCollector(initBufferSize, maxBatchSize, bufferSupplier, batchCollector);
    }

    public static <ValueType, ResultType> Collector<ValueType, ResultType, ResultType> sinkSynchronized(ResultType container, BiConsumer<? super ResultType, ValueType> accumulator) {
        return Collector.of(() -> container, (c, v) -> {
            Object object = container;
            synchronized (object) {
                accumulator.accept((Object)c, (Object)v);
            }
        }, (c1, c2) -> {
            assert (c1 == c2) : "A single instance of container should exist";
            return c1;
        }, Collector.Characteristics.CONCURRENT);
    }

    public static <ValueType, ResultType> Collector<ValueType, ResultType, ResultType> sink(ResultType sink, BiConsumer<ResultType, ValueType> accumulator) {
        return Collector.of(() -> sink, accumulator, (sink1, sink2) -> {
            assert (sink1 == sink2) : "A single instance of output sink should exist";
            return sink1;
        }, Collector.Characteristics.CONCURRENT);
    }

    private static class BufferingCollector<V, B extends Collection<V>, H, R>
    implements Collector<V, Buffer, R> {
        final int initBufferSize;
        final int maxBatchSize;
        final IntFunction<B> bufferSupplier;
        final Collector<? super B, H, ? extends R> batchCollector;

        private BufferingCollector(int initBufferSize, int maxBatchSize, IntFunction<B> bufferSupplier, Collector<? super B, H, ? extends R> batchCollector) {
            if (maxBatchSize < 2) {
                throw new IllegalArgumentException("Buffering by batch of less than 2 elements is useless");
            }
            ArgumentChecks.ensureNonNull("Buffer supplier", bufferSupplier);
            ArgumentChecks.ensureNonNull("Batch collector", batchCollector);
            this.initBufferSize = initBufferSize < 1 || initBufferSize > maxBatchSize ? maxBatchSize : initBufferSize;
            this.maxBatchSize = maxBatchSize;
            this.bufferSupplier = bufferSupplier;
            this.batchCollector = batchCollector;
        }

        @Override
        public Supplier<Buffer> supplier() {
            Supplier<H> batchSupplier = this.batchCollector.supplier();
            BiConsumer<H, ? super B> batchAccumulator = this.batchCollector.accumulator();
            Function<H, ? extends R> batchFinisher = this.batchCollector.finisher();
            return () -> {
                Object batchContainer = batchSupplier.get();
                return new Buffer(batchContainer, batchAccumulator, batchFinisher);
            };
        }

        @Override
        public BiConsumer<Buffer, V> accumulator() {
            return Buffer::add;
        }

        @Override
        public BinaryOperator<Buffer> combiner() {
            return this::combine;
        }

        @Override
        public Function<Buffer, R> finisher() {
            return Buffer::finish;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.UNORDERED);
        }

        private Buffer combine(Buffer first, Buffer second) {
            int size2;
            int size1 = first.values.size();
            if ((long)size1 + (long)(size2 = second.values.size()) >= (long)this.maxBatchSize) {
                first.flush(false);
                second.flush(true);
                return second;
            }
            if (size1 > size2) {
                first.values.addAll(second.values);
                return first;
            }
            second.values.addAll(first.values);
            return second;
        }

        private class Buffer {
            B values;
            final H batchContainer;
            final BiConsumer<H, ? super B> batchAccumulator;
            final Function<H, ? extends R> batchFinisher;

            public Buffer(H batchContainer, BiConsumer<H, ? super B> batchAccumulator, Function<H, ? extends R> batchFinisher) {
                this.batchContainer = batchContainer;
                this.batchAccumulator = batchAccumulator;
                this.batchFinisher = batchFinisher;
                this.values = (Collection)BufferingCollector.this.bufferSupplier.apply(BufferingCollector.this.initBufferSize);
            }

            private void add(V value) {
                this.values.add(value);
                if (this.values.size() >= BufferingCollector.this.maxBatchSize) {
                    this.flush(true);
                }
            }

            private void flush(boolean reuse) {
                this.batchAccumulator.accept(this.batchContainer, this.values);
                this.values = reuse ? (Collection)BufferingCollector.this.bufferSupplier.apply(BufferingCollector.this.initBufferSize) : null;
            }

            private R finish() {
                this.flush(false);
                return BufferingCollector.this.batchCollector.finisher().apply(this.batchContainer);
            }
        }
    }
}

